/*
 * test_bt_ctf_field_type_validation.c
 *
 * Babeltrace CTF IR field type validation test
 *
 * Copyright (c) 2016 Philippe Proulx <pproulx@efficios.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; under version 2 of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */

#include <babeltrace/ctf-ir/field-types.h>
#include <babeltrace/ctf-ir/field-path.h>
#include <babeltrace/ctf-ir/event.h>
#include <babeltrace/ctf-ir/event-class.h>
#include <babeltrace/ctf-ir/stream-class.h>
#include <babeltrace/ctf-ir/trace.h>
#include <assert.h>
#include <stdbool.h>
#include <string.h>
#include <stdarg.h>
#include <glib.h>
#include "tap/tap.h"

static
struct bt_ctf_field_type *get_good_packet_header_type(void)
{
	/*
	Generated by bt-ctfirtg using the following input:

	class: struct
	fields:
	  magic:
	    class: int
	    size: 32
	  uuid:
	    class: array
	    length: 16
	    element-type:
	      class: int
	      size: 8
	  stream_id:
	    class: int
	    size: 32
	  iron:
	    class: struct
	    fields:
	      listen:
	        class: string
	      dust:
	        class: int
	        size: 23
	      parallel:
	        class: enum
	        value-type:
	          class: int
	          size: 10
	        members:
	          - RED
	          - BLUE
	          - YELLOW
	      fire:
	        class: struct
	        fields:
	          word:
	            class: int
	            size: 17
	          rabbit:
	            class: string
	          keen:
	            class: array
	            length: word
	            element-type:
	              class: variant
	              tag: iron.parallel
	              types:
	                RED:
	                  class: string
	                BLUE:
	                  class: array
	                  length: magic
	                  element-type:
	                    class: int
	                    size: 5
	                YELLOW:
	                  class: struct
	      report:
	        class: array
	        length: trace.packet.header.iron.dust
	        element-type:
	          class: string
	      group:
	        class: array
	        length: trace.packet.header.stream_id
	        element-type:
	          class: string
	  serious:
	    class: int
	    size: 1

	*/

	struct bt_ctf_field_type *root = NULL;
	struct bt_ctf_field_type *root_magic = NULL;
	struct bt_ctf_field_type *root_uuid = NULL;
	struct bt_ctf_field_type *root_uuid_elem = NULL;
	struct bt_ctf_field_type *root_stream_id = NULL;
	struct bt_ctf_field_type *root_iron = NULL;
	struct bt_ctf_field_type *root_iron_listen = NULL;
	struct bt_ctf_field_type *root_iron_dust = NULL;
	struct bt_ctf_field_type *root_iron_parallel = NULL;
	struct bt_ctf_field_type *root_iron_parallel_int = NULL;
	struct bt_ctf_field_type *root_iron_fire = NULL;
	struct bt_ctf_field_type *root_iron_fire_word = NULL;
	struct bt_ctf_field_type *root_iron_fire_rabbit = NULL;
	struct bt_ctf_field_type *root_iron_fire_keen = NULL;
	struct bt_ctf_field_type *root_iron_fire_keen_elem = NULL;
	struct bt_ctf_field_type *root_iron_fire_keen_elem_RED = NULL;
	struct bt_ctf_field_type *root_iron_fire_keen_elem_BLUE = NULL;
	struct bt_ctf_field_type *root_iron_fire_keen_elem_BLUE_elem = NULL;
	struct bt_ctf_field_type *root_iron_fire_keen_elem_YELLOW = NULL;
	struct bt_ctf_field_type *root_iron_report = NULL;
	struct bt_ctf_field_type *root_iron_report_elem = NULL;
	struct bt_ctf_field_type *root_iron_group = NULL;
	struct bt_ctf_field_type *root_iron_group_elem = NULL;
	struct bt_ctf_field_type *root_serious = NULL;

	int ret;
	root = bt_ctf_field_type_structure_create();
	assert(root);
	ret = bt_ctf_field_type_set_alignment(root, 8);
	assert(ret == 0);
	root_magic = bt_ctf_field_type_integer_create(32);
	assert(root_magic);
	ret = bt_ctf_field_type_integer_set_signed(root_magic, 0);
	assert(ret == 0);
	ret = bt_ctf_field_type_integer_set_base(root_magic, 10);
	assert(ret == 0);
	ret = bt_ctf_field_type_integer_set_encoding(root_magic, BT_CTF_STRING_ENCODING_NONE);
	assert(ret == 0);
	ret = bt_ctf_field_type_set_byte_order(root_magic, BT_CTF_BYTE_ORDER_LITTLE_ENDIAN);
	assert(ret == 0);
	ret = bt_ctf_field_type_set_alignment(root_magic, 8);
	assert(ret == 0);
	ret = bt_ctf_field_type_structure_add_field(root, root_magic, "magic");
	assert(ret == 0);
	root_uuid_elem = bt_ctf_field_type_integer_create(8);
	assert(root_uuid_elem);
	ret = bt_ctf_field_type_integer_set_signed(root_uuid_elem, 0);
	assert(ret == 0);
	ret = bt_ctf_field_type_integer_set_base(root_uuid_elem, 10);
	assert(ret == 0);
	ret = bt_ctf_field_type_integer_set_encoding(root_uuid_elem, BT_CTF_STRING_ENCODING_NONE);
	assert(ret == 0);
	ret = bt_ctf_field_type_set_byte_order(root_uuid_elem, BT_CTF_BYTE_ORDER_LITTLE_ENDIAN);
	assert(ret == 0);
	ret = bt_ctf_field_type_set_alignment(root_uuid_elem, 8);
	assert(ret == 0);
	root_uuid = bt_ctf_field_type_array_create(root_uuid_elem, 16);
	assert(root_uuid);
	ret = bt_ctf_field_type_structure_add_field(root, root_uuid, "uuid");
	assert(ret == 0);
	root_stream_id = bt_ctf_field_type_integer_create(32);
	assert(root_stream_id);
	ret = bt_ctf_field_type_integer_set_signed(root_stream_id, 0);
	assert(ret == 0);
	ret = bt_ctf_field_type_integer_set_base(root_stream_id, 10);
	assert(ret == 0);
	ret = bt_ctf_field_type_integer_set_encoding(root_stream_id, BT_CTF_STRING_ENCODING_NONE);
	assert(ret == 0);
	ret = bt_ctf_field_type_set_byte_order(root_stream_id, BT_CTF_BYTE_ORDER_LITTLE_ENDIAN);
	assert(ret == 0);
	ret = bt_ctf_field_type_set_alignment(root_stream_id, 8);
	assert(ret == 0);
	ret = bt_ctf_field_type_structure_add_field(root, root_stream_id, "stream_id");
	assert(ret == 0);
	root_iron = bt_ctf_field_type_structure_create();
	assert(root_iron);
	ret = bt_ctf_field_type_set_alignment(root_iron, 8);
	assert(ret == 0);
	root_iron_listen = bt_ctf_field_type_string_create();
	assert(root_iron_listen);
	ret = bt_ctf_field_type_string_set_encoding(root_iron_listen, BT_CTF_STRING_ENCODING_UTF8);
	assert(ret == 0);
	ret = bt_ctf_field_type_structure_add_field(root_iron, root_iron_listen, "listen");
	assert(ret == 0);
	root_iron_dust = bt_ctf_field_type_integer_create(23);
	assert(root_iron_dust);
	ret = bt_ctf_field_type_integer_set_signed(root_iron_dust, 0);
	assert(ret == 0);
	ret = bt_ctf_field_type_integer_set_base(root_iron_dust, 10);
	assert(ret == 0);
	ret = bt_ctf_field_type_integer_set_encoding(root_iron_dust, BT_CTF_STRING_ENCODING_NONE);
	assert(ret == 0);
	ret = bt_ctf_field_type_set_byte_order(root_iron_dust, BT_CTF_BYTE_ORDER_LITTLE_ENDIAN);
	assert(ret == 0);
	ret = bt_ctf_field_type_set_alignment(root_iron_dust, 1);
	assert(ret == 0);
	ret = bt_ctf_field_type_structure_add_field(root_iron, root_iron_dust, "dust");
	assert(ret == 0);
	root_iron_parallel_int = bt_ctf_field_type_integer_create(10);
	assert(root_iron_parallel_int);
	ret = bt_ctf_field_type_integer_set_signed(root_iron_parallel_int, 0);
	assert(ret == 0);
	ret = bt_ctf_field_type_integer_set_base(root_iron_parallel_int, 10);
	assert(ret == 0);
	ret = bt_ctf_field_type_integer_set_encoding(root_iron_parallel_int, BT_CTF_STRING_ENCODING_NONE);
	assert(ret == 0);
	ret = bt_ctf_field_type_set_byte_order(root_iron_parallel_int, BT_CTF_BYTE_ORDER_LITTLE_ENDIAN);
	assert(ret == 0);
	ret = bt_ctf_field_type_set_alignment(root_iron_parallel_int, 1);
	assert(ret == 0);
	root_iron_parallel = bt_ctf_field_type_enumeration_create(root_iron_parallel_int);
	assert(root_iron_parallel);
	ret = bt_ctf_field_type_enumeration_add_mapping(root_iron_parallel, "RED", 0, 0);
	assert(ret == 0);
	ret = bt_ctf_field_type_enumeration_add_mapping(root_iron_parallel, "BLUE", 1, 1);
	assert(ret == 0);
	ret = bt_ctf_field_type_enumeration_add_mapping(root_iron_parallel, "YELLOW", 2, 2);
	assert(ret == 0);
	ret = bt_ctf_field_type_structure_add_field(root_iron, root_iron_parallel, "parallel");
	assert(ret == 0);
	root_iron_fire = bt_ctf_field_type_structure_create();
	assert(root_iron_fire);
	ret = bt_ctf_field_type_set_alignment(root_iron_fire, 8);
	assert(ret == 0);
	root_iron_fire_word = bt_ctf_field_type_integer_create(17);
	assert(root_iron_fire_word);
	ret = bt_ctf_field_type_integer_set_signed(root_iron_fire_word, 0);
	assert(ret == 0);
	ret = bt_ctf_field_type_integer_set_base(root_iron_fire_word, 10);
	assert(ret == 0);
	ret = bt_ctf_field_type_integer_set_encoding(root_iron_fire_word, BT_CTF_STRING_ENCODING_NONE);
	assert(ret == 0);
	ret = bt_ctf_field_type_set_byte_order(root_iron_fire_word, BT_CTF_BYTE_ORDER_LITTLE_ENDIAN);
	assert(ret == 0);
	ret = bt_ctf_field_type_set_alignment(root_iron_fire_word, 1);
	assert(ret == 0);
	ret = bt_ctf_field_type_structure_add_field(root_iron_fire, root_iron_fire_word, "word");
	assert(ret == 0);
	root_iron_fire_rabbit = bt_ctf_field_type_string_create();
	assert(root_iron_fire_rabbit);
	ret = bt_ctf_field_type_string_set_encoding(root_iron_fire_rabbit, BT_CTF_STRING_ENCODING_UTF8);
	assert(ret == 0);
	ret = bt_ctf_field_type_structure_add_field(root_iron_fire, root_iron_fire_rabbit, "rabbit");
	assert(ret == 0);
	root_iron_fire_keen_elem = bt_ctf_field_type_variant_create(NULL, "iron.parallel");
	assert(root_iron_fire_keen_elem);
	root_iron_fire_keen_elem_RED = bt_ctf_field_type_string_create();
	assert(root_iron_fire_keen_elem_RED);
	ret = bt_ctf_field_type_string_set_encoding(root_iron_fire_keen_elem_RED, BT_CTF_STRING_ENCODING_UTF8);
	assert(ret == 0);
	ret = bt_ctf_field_type_variant_add_field(root_iron_fire_keen_elem, root_iron_fire_keen_elem_RED, "RED");
	assert(ret == 0);
	root_iron_fire_keen_elem_BLUE_elem = bt_ctf_field_type_integer_create(5);
	assert(root_iron_fire_keen_elem_BLUE_elem);
	ret = bt_ctf_field_type_integer_set_signed(root_iron_fire_keen_elem_BLUE_elem, 0);
	assert(ret == 0);
	ret = bt_ctf_field_type_integer_set_base(root_iron_fire_keen_elem_BLUE_elem, 10);
	assert(ret == 0);
	ret = bt_ctf_field_type_integer_set_encoding(root_iron_fire_keen_elem_BLUE_elem, BT_CTF_STRING_ENCODING_NONE);
	assert(ret == 0);
	ret = bt_ctf_field_type_set_byte_order(root_iron_fire_keen_elem_BLUE_elem, BT_CTF_BYTE_ORDER_LITTLE_ENDIAN);
	assert(ret == 0);
	ret = bt_ctf_field_type_set_alignment(root_iron_fire_keen_elem_BLUE_elem, 1);
	assert(ret == 0);
	root_iron_fire_keen_elem_BLUE = bt_ctf_field_type_sequence_create(root_iron_fire_keen_elem_BLUE_elem, "magic");
	assert(root_iron_fire_keen_elem_BLUE);
	ret = bt_ctf_field_type_variant_add_field(root_iron_fire_keen_elem, root_iron_fire_keen_elem_BLUE, "BLUE");
	assert(ret == 0);
	root_iron_fire_keen_elem_YELLOW = bt_ctf_field_type_structure_create();
	assert(root_iron_fire_keen_elem_YELLOW);
	ret = bt_ctf_field_type_set_alignment(root_iron_fire_keen_elem_YELLOW, 1);
	assert(ret == 0);
	ret = bt_ctf_field_type_variant_add_field(root_iron_fire_keen_elem, root_iron_fire_keen_elem_YELLOW, "YELLOW");
	assert(ret == 0);
	root_iron_fire_keen = bt_ctf_field_type_sequence_create(root_iron_fire_keen_elem, "word");
	assert(root_iron_fire_keen);
	ret = bt_ctf_field_type_structure_add_field(root_iron_fire, root_iron_fire_keen, "keen");
	assert(ret == 0);
	ret = bt_ctf_field_type_structure_add_field(root_iron, root_iron_fire, "fire");
	assert(ret == 0);
	root_iron_report_elem = bt_ctf_field_type_string_create();
	assert(root_iron_report_elem);
	ret = bt_ctf_field_type_string_set_encoding(root_iron_report_elem, BT_CTF_STRING_ENCODING_UTF8);
	assert(ret == 0);
	root_iron_report = bt_ctf_field_type_sequence_create(root_iron_report_elem, "trace.packet.header.iron.dust");
	assert(root_iron_report);
	ret = bt_ctf_field_type_structure_add_field(root_iron, root_iron_report, "report");
	assert(ret == 0);
	root_iron_group_elem = bt_ctf_field_type_string_create();
	assert(root_iron_group_elem);
	ret = bt_ctf_field_type_string_set_encoding(root_iron_group_elem, BT_CTF_STRING_ENCODING_UTF8);
	assert(ret == 0);
	root_iron_group = bt_ctf_field_type_sequence_create(root_iron_group_elem, "trace.packet.header.stream_id");
	assert(root_iron_group);
	ret = bt_ctf_field_type_structure_add_field(root_iron, root_iron_group, "group");
	assert(ret == 0);
	ret = bt_ctf_field_type_structure_add_field(root, root_iron, "iron");
	assert(ret == 0);
	root_serious = bt_ctf_field_type_integer_create(1);
	assert(root_serious);
	ret = bt_ctf_field_type_integer_set_signed(root_serious, 0);
	assert(ret == 0);
	ret = bt_ctf_field_type_integer_set_base(root_serious, 10);
	assert(ret == 0);
	ret = bt_ctf_field_type_integer_set_encoding(root_serious, BT_CTF_STRING_ENCODING_NONE);
	assert(ret == 0);
	ret = bt_ctf_field_type_set_byte_order(root_serious, BT_CTF_BYTE_ORDER_LITTLE_ENDIAN);
	assert(ret == 0);
	ret = bt_ctf_field_type_set_alignment(root_serious, 1);
	assert(ret == 0);
	ret = bt_ctf_field_type_structure_add_field(root, root_serious, "serious");
	assert(ret == 0);

	BT_PUT(root_magic);
	BT_PUT(root_uuid);
	BT_PUT(root_uuid_elem);
	BT_PUT(root_stream_id);
	BT_PUT(root_iron);
	BT_PUT(root_iron_listen);
	BT_PUT(root_iron_dust);
	BT_PUT(root_iron_parallel);
	BT_PUT(root_iron_parallel_int);
	BT_PUT(root_iron_fire);
	BT_PUT(root_iron_fire_word);
	BT_PUT(root_iron_fire_rabbit);
	BT_PUT(root_iron_fire_keen);
	BT_PUT(root_iron_fire_keen_elem);
	BT_PUT(root_iron_fire_keen_elem_RED);
	BT_PUT(root_iron_fire_keen_elem_BLUE);
	BT_PUT(root_iron_fire_keen_elem_BLUE_elem);
	BT_PUT(root_iron_fire_keen_elem_YELLOW);
	BT_PUT(root_iron_report);
	BT_PUT(root_iron_report_elem);
	BT_PUT(root_iron_group);
	BT_PUT(root_iron_group_elem);
	BT_PUT(root_serious);

	return root;
}

static
struct bt_ctf_field_type *get_good_packet_context_type(void)
{
	/*
	Generated by bt-ctfirtg using the following input:

	class: struct
	fields:
	  placid:
	    class: int
	    size: 32
	  meow:
	    class: string
	  serious:
	    class: int
	    size: 11
	  naive:
	    class: array
	    length: 17
	    element-type:
	      class: array
	      length: placid
	      element-type:
	        class: string
	  clover:
	    class: struct
	    fields:
	      oval:
	        class: int
	        size: 17
	      whole:
	        class: variant
	        tag: iron.parallel
	        types:
	          BLUE:
	            class: array
	            length: trace.packet.header.iron.fire.word
	            element-type:
	              class: string
	          RED:
	            class: int
	            size: 44
	          YELLOW:
	            class: string
	      egg:
	        class: array
	        length: stream.packet.context.clover.oval
	        element-type:
	          class: int
	          size: 55
	      square:
	        class: enum
	        value-type:
	          class: int
	          size: 12
	        members:
	          - YOUNG
	          - OLD
	      useful:
	        class: array
	        length: serious
	        element-type:
	          class: int
	          size: 2
	  tart:
	    class: string

	*/

	struct bt_ctf_field_type *root = NULL;
	struct bt_ctf_field_type *root_placid = NULL;
	struct bt_ctf_field_type *root_meow = NULL;
	struct bt_ctf_field_type *root_serious = NULL;
	struct bt_ctf_field_type *root_naive = NULL;
	struct bt_ctf_field_type *root_naive_elem = NULL;
	struct bt_ctf_field_type *root_naive_elem_elem = NULL;
	struct bt_ctf_field_type *root_clover = NULL;
	struct bt_ctf_field_type *root_clover_oval = NULL;
	struct bt_ctf_field_type *root_clover_whole = NULL;
	struct bt_ctf_field_type *root_clover_whole_BLUE = NULL;
	struct bt_ctf_field_type *root_clover_whole_BLUE_elem = NULL;
	struct bt_ctf_field_type *root_clover_whole_RED = NULL;
	struct bt_ctf_field_type *root_clover_whole_YELLOW = NULL;
	struct bt_ctf_field_type *root_clover_egg = NULL;
	struct bt_ctf_field_type *root_clover_egg_elem = NULL;
	struct bt_ctf_field_type *root_clover_square = NULL;
	struct bt_ctf_field_type *root_clover_square_int = NULL;
	struct bt_ctf_field_type *root_clover_useful = NULL;
	struct bt_ctf_field_type *root_clover_useful_elem = NULL;
	struct bt_ctf_field_type *root_tart = NULL;

	int ret;
	root = bt_ctf_field_type_structure_create();
	assert(root);
	ret = bt_ctf_field_type_set_alignment(root, 8);
	assert(ret == 0);
	root_placid = bt_ctf_field_type_integer_create(32);
	assert(root_placid);
	ret = bt_ctf_field_type_integer_set_signed(root_placid, 0);
	assert(ret == 0);
	ret = bt_ctf_field_type_integer_set_base(root_placid, 10);
	assert(ret == 0);
	ret = bt_ctf_field_type_integer_set_encoding(root_placid, BT_CTF_STRING_ENCODING_NONE);
	assert(ret == 0);
	ret = bt_ctf_field_type_set_byte_order(root_placid, BT_CTF_BYTE_ORDER_LITTLE_ENDIAN);
	assert(ret == 0);
	ret = bt_ctf_field_type_set_alignment(root_placid, 8);
	assert(ret == 0);
	ret = bt_ctf_field_type_structure_add_field(root, root_placid, "placid");
	assert(ret == 0);
	root_meow = bt_ctf_field_type_string_create();
	assert(root_meow);
	ret = bt_ctf_field_type_string_set_encoding(root_meow, BT_CTF_STRING_ENCODING_UTF8);
	assert(ret == 0);
	ret = bt_ctf_field_type_structure_add_field(root, root_meow, "meow");
	assert(ret == 0);
	root_serious = bt_ctf_field_type_integer_create(11);
	assert(root_serious);
	ret = bt_ctf_field_type_integer_set_signed(root_serious, 0);
	assert(ret == 0);
	ret = bt_ctf_field_type_integer_set_base(root_serious, 10);
	assert(ret == 0);
	ret = bt_ctf_field_type_integer_set_encoding(root_serious, BT_CTF_STRING_ENCODING_NONE);
	assert(ret == 0);
	ret = bt_ctf_field_type_set_byte_order(root_serious, BT_CTF_BYTE_ORDER_LITTLE_ENDIAN);
	assert(ret == 0);
	ret = bt_ctf_field_type_set_alignment(root_serious, 1);
	assert(ret == 0);
	ret = bt_ctf_field_type_structure_add_field(root, root_serious, "serious");
	assert(ret == 0);
	root_naive_elem_elem = bt_ctf_field_type_string_create();
	assert(root_naive_elem_elem);
	ret = bt_ctf_field_type_string_set_encoding(root_naive_elem_elem, BT_CTF_STRING_ENCODING_UTF8);
	assert(ret == 0);
	root_naive_elem = bt_ctf_field_type_sequence_create(root_naive_elem_elem, "placid");
	assert(root_naive_elem);
	root_naive = bt_ctf_field_type_array_create(root_naive_elem, 17);
	assert(root_naive);
	ret = bt_ctf_field_type_structure_add_field(root, root_naive, "naive");
	assert(ret == 0);
	root_clover = bt_ctf_field_type_structure_create();
	assert(root_clover);
	ret = bt_ctf_field_type_set_alignment(root_clover, 1);
	assert(ret == 0);
	root_clover_oval = bt_ctf_field_type_integer_create(17);
	assert(root_clover_oval);
	ret = bt_ctf_field_type_integer_set_signed(root_clover_oval, 0);
	assert(ret == 0);
	ret = bt_ctf_field_type_integer_set_base(root_clover_oval, 10);
	assert(ret == 0);
	ret = bt_ctf_field_type_integer_set_encoding(root_clover_oval, BT_CTF_STRING_ENCODING_NONE);
	assert(ret == 0);
	ret = bt_ctf_field_type_set_byte_order(root_clover_oval, BT_CTF_BYTE_ORDER_LITTLE_ENDIAN);
	assert(ret == 0);
	ret = bt_ctf_field_type_set_alignment(root_clover_oval, 1);
	assert(ret == 0);
	ret = bt_ctf_field_type_structure_add_field(root_clover, root_clover_oval, "oval");
	assert(ret == 0);
	root_clover_whole = bt_ctf_field_type_variant_create(NULL, "iron.parallel");
	assert(root_clover_whole);
	root_clover_whole_BLUE_elem = bt_ctf_field_type_string_create();
	assert(root_clover_whole_BLUE_elem);
	ret = bt_ctf_field_type_string_set_encoding(root_clover_whole_BLUE_elem, BT_CTF_STRING_ENCODING_UTF8);
	assert(ret == 0);
	root_clover_whole_BLUE = bt_ctf_field_type_sequence_create(root_clover_whole_BLUE_elem, "trace.packet.header.iron.fire.word");
	assert(root_clover_whole_BLUE);
	ret = bt_ctf_field_type_variant_add_field(root_clover_whole, root_clover_whole_BLUE, "BLUE");
	assert(ret == 0);
	root_clover_whole_RED = bt_ctf_field_type_integer_create(44);
	assert(root_clover_whole_RED);
	ret = bt_ctf_field_type_integer_set_signed(root_clover_whole_RED, 0);
	assert(ret == 0);
	ret = bt_ctf_field_type_integer_set_base(root_clover_whole_RED, 10);
	assert(ret == 0);
	ret = bt_ctf_field_type_integer_set_encoding(root_clover_whole_RED, BT_CTF_STRING_ENCODING_NONE);
	assert(ret == 0);
	ret = bt_ctf_field_type_set_byte_order(root_clover_whole_RED, BT_CTF_BYTE_ORDER_LITTLE_ENDIAN);
	assert(ret == 0);
	ret = bt_ctf_field_type_set_alignment(root_clover_whole_RED, 1);
	assert(ret == 0);
	ret = bt_ctf_field_type_variant_add_field(root_clover_whole, root_clover_whole_RED, "RED");
	assert(ret == 0);
	root_clover_whole_YELLOW = bt_ctf_field_type_string_create();
	assert(root_clover_whole_YELLOW);
	ret = bt_ctf_field_type_string_set_encoding(root_clover_whole_YELLOW, BT_CTF_STRING_ENCODING_UTF8);
	assert(ret == 0);
	ret = bt_ctf_field_type_variant_add_field(root_clover_whole, root_clover_whole_YELLOW, "YELLOW");
	assert(ret == 0);
	ret = bt_ctf_field_type_structure_add_field(root_clover, root_clover_whole, "whole");
	assert(ret == 0);
	root_clover_egg_elem = bt_ctf_field_type_integer_create(55);
	assert(root_clover_egg_elem);
	ret = bt_ctf_field_type_integer_set_signed(root_clover_egg_elem, 0);
	assert(ret == 0);
	ret = bt_ctf_field_type_integer_set_base(root_clover_egg_elem, 10);
	assert(ret == 0);
	ret = bt_ctf_field_type_integer_set_encoding(root_clover_egg_elem, BT_CTF_STRING_ENCODING_NONE);
	assert(ret == 0);
	ret = bt_ctf_field_type_set_byte_order(root_clover_egg_elem, BT_CTF_BYTE_ORDER_LITTLE_ENDIAN);
	assert(ret == 0);
	ret = bt_ctf_field_type_set_alignment(root_clover_egg_elem, 1);
	assert(ret == 0);
	root_clover_egg = bt_ctf_field_type_sequence_create(root_clover_egg_elem, "stream.packet.context.clover.oval");
	assert(root_clover_egg);
	ret = bt_ctf_field_type_structure_add_field(root_clover, root_clover_egg, "egg");
	assert(ret == 0);
	root_clover_square_int = bt_ctf_field_type_integer_create(12);
	assert(root_clover_square_int);
	ret = bt_ctf_field_type_integer_set_signed(root_clover_square_int, 0);
	assert(ret == 0);
	ret = bt_ctf_field_type_integer_set_base(root_clover_square_int, 10);
	assert(ret == 0);
	ret = bt_ctf_field_type_integer_set_encoding(root_clover_square_int, BT_CTF_STRING_ENCODING_NONE);
	assert(ret == 0);
	ret = bt_ctf_field_type_set_byte_order(root_clover_square_int, BT_CTF_BYTE_ORDER_LITTLE_ENDIAN);
	assert(ret == 0);
	ret = bt_ctf_field_type_set_alignment(root_clover_square_int, 1);
	assert(ret == 0);
	root_clover_square = bt_ctf_field_type_enumeration_create(root_clover_square_int);
	assert(root_clover_square);
	ret = bt_ctf_field_type_enumeration_add_mapping(root_clover_square, "YOUNG", 0, 0);
	assert(ret == 0);
	ret = bt_ctf_field_type_enumeration_add_mapping(root_clover_square, "OLD", 1, 1);
	assert(ret == 0);
	ret = bt_ctf_field_type_structure_add_field(root_clover, root_clover_square, "square");
	assert(ret == 0);
	root_clover_useful_elem = bt_ctf_field_type_integer_create(2);
	assert(root_clover_useful_elem);
	ret = bt_ctf_field_type_integer_set_signed(root_clover_useful_elem, 0);
	assert(ret == 0);
	ret = bt_ctf_field_type_integer_set_base(root_clover_useful_elem, 10);
	assert(ret == 0);
	ret = bt_ctf_field_type_integer_set_encoding(root_clover_useful_elem, BT_CTF_STRING_ENCODING_NONE);
	assert(ret == 0);
	ret = bt_ctf_field_type_set_byte_order(root_clover_useful_elem, BT_CTF_BYTE_ORDER_LITTLE_ENDIAN);
	assert(ret == 0);
	ret = bt_ctf_field_type_set_alignment(root_clover_useful_elem, 1);
	assert(ret == 0);
	root_clover_useful = bt_ctf_field_type_sequence_create(root_clover_useful_elem, "serious");
	assert(root_clover_useful);
	ret = bt_ctf_field_type_structure_add_field(root_clover, root_clover_useful, "useful");
	assert(ret == 0);
	ret = bt_ctf_field_type_structure_add_field(root, root_clover, "clover");
	assert(ret == 0);
	root_tart = bt_ctf_field_type_string_create();
	assert(root_tart);
	ret = bt_ctf_field_type_string_set_encoding(root_tart, BT_CTF_STRING_ENCODING_UTF8);
	assert(ret == 0);
	ret = bt_ctf_field_type_structure_add_field(root, root_tart, "tart");
	assert(ret == 0);

	BT_PUT(root_placid);
	BT_PUT(root_meow);
	BT_PUT(root_serious);
	BT_PUT(root_naive);
	BT_PUT(root_naive_elem);
	BT_PUT(root_naive_elem_elem);
	BT_PUT(root_clover);
	BT_PUT(root_clover_oval);
	BT_PUT(root_clover_whole);
	BT_PUT(root_clover_whole_BLUE);
	BT_PUT(root_clover_whole_BLUE_elem);
	BT_PUT(root_clover_whole_RED);
	BT_PUT(root_clover_whole_YELLOW);
	BT_PUT(root_clover_egg);
	BT_PUT(root_clover_egg_elem);
	BT_PUT(root_clover_square);
	BT_PUT(root_clover_square_int);
	BT_PUT(root_clover_useful);
	BT_PUT(root_clover_useful_elem);
	BT_PUT(root_tart);

	return root;
}


static
struct bt_ctf_field_type *get_good_event_header_type(void)
{
	/*
	Generated by bt-ctfirtg using the following input:

	class: struct
	fields:
	  id:
	    class: int
	    size: 17
	  timestamp:
	    class: int
	    size: 64
	  action:
	    class: struct
	    fields:
	      special:
	        class: int
	        size: 17
	      lucky:
	        class: array
	        length: stream.packet.context.placid
	        element-type:
	          class: string
	      dream:
	        class: string
	      grandiose:
	        class: array
	        length: trace.packet.header.serious
	        element-type:
	          class: int
	          size: 3
	  stiff:
	    class: array
	    length: clover.whole.RED
	    element-type:
	      class: string
	  fruit:
	    class: struct
	    fields:
	      apple:
	        class: array
	        length: action.special
	        element-type:
	          class: int
	          size: 5

	*/

	struct bt_ctf_field_type *root = NULL;
	struct bt_ctf_field_type *root_id = NULL;
	struct bt_ctf_field_type *root_timestamp = NULL;
	struct bt_ctf_field_type *root_action = NULL;
	struct bt_ctf_field_type *root_action_special = NULL;
	struct bt_ctf_field_type *root_action_lucky = NULL;
	struct bt_ctf_field_type *root_action_lucky_elem = NULL;
	struct bt_ctf_field_type *root_action_dream = NULL;
	struct bt_ctf_field_type *root_action_grandiose = NULL;
	struct bt_ctf_field_type *root_action_grandiose_elem = NULL;
	struct bt_ctf_field_type *root_stiff = NULL;
	struct bt_ctf_field_type *root_stiff_elem = NULL;
	struct bt_ctf_field_type *root_fruit = NULL;
	struct bt_ctf_field_type *root_fruit_apple = NULL;
	struct bt_ctf_field_type *root_fruit_apple_elem = NULL;

	int ret;
	root = bt_ctf_field_type_structure_create();
	assert(root);
	ret = bt_ctf_field_type_set_alignment(root, 8);
	assert(ret == 0);
	root_id = bt_ctf_field_type_integer_create(17);
	assert(root_id);
	ret = bt_ctf_field_type_integer_set_signed(root_id, 0);
	assert(ret == 0);
	ret = bt_ctf_field_type_integer_set_base(root_id, 10);
	assert(ret == 0);
	ret = bt_ctf_field_type_integer_set_encoding(root_id, BT_CTF_STRING_ENCODING_NONE);
	assert(ret == 0);
	ret = bt_ctf_field_type_set_byte_order(root_id, BT_CTF_BYTE_ORDER_LITTLE_ENDIAN);
	assert(ret == 0);
	ret = bt_ctf_field_type_set_alignment(root_id, 1);
	assert(ret == 0);
	ret = bt_ctf_field_type_structure_add_field(root, root_id, "id");
	assert(ret == 0);
	root_timestamp = bt_ctf_field_type_integer_create(64);
	assert(root_timestamp);
	ret = bt_ctf_field_type_integer_set_signed(root_timestamp, 0);
	assert(ret == 0);
	ret = bt_ctf_field_type_integer_set_base(root_timestamp, 10);
	assert(ret == 0);
	ret = bt_ctf_field_type_integer_set_encoding(root_timestamp, BT_CTF_STRING_ENCODING_NONE);
	assert(ret == 0);
	ret = bt_ctf_field_type_set_byte_order(root_timestamp, BT_CTF_BYTE_ORDER_LITTLE_ENDIAN);
	assert(ret == 0);
	ret = bt_ctf_field_type_set_alignment(root_timestamp, 8);
	assert(ret == 0);
	ret = bt_ctf_field_type_structure_add_field(root, root_timestamp, "timestamp");
	assert(ret == 0);
	root_action = bt_ctf_field_type_structure_create();
	assert(root_action);
	ret = bt_ctf_field_type_set_alignment(root_action, 8);
	assert(ret == 0);
	root_action_special = bt_ctf_field_type_integer_create(17);
	assert(root_action_special);
	ret = bt_ctf_field_type_integer_set_signed(root_action_special, 0);
	assert(ret == 0);
	ret = bt_ctf_field_type_integer_set_base(root_action_special, 10);
	assert(ret == 0);
	ret = bt_ctf_field_type_integer_set_encoding(root_action_special, BT_CTF_STRING_ENCODING_NONE);
	assert(ret == 0);
	ret = bt_ctf_field_type_set_byte_order(root_action_special, BT_CTF_BYTE_ORDER_LITTLE_ENDIAN);
	assert(ret == 0);
	ret = bt_ctf_field_type_set_alignment(root_action_special, 1);
	assert(ret == 0);
	ret = bt_ctf_field_type_structure_add_field(root_action, root_action_special, "special");
	assert(ret == 0);
	root_action_lucky_elem = bt_ctf_field_type_string_create();
	assert(root_action_lucky_elem);
	ret = bt_ctf_field_type_string_set_encoding(root_action_lucky_elem, BT_CTF_STRING_ENCODING_UTF8);
	assert(ret == 0);
	root_action_lucky = bt_ctf_field_type_sequence_create(root_action_lucky_elem, "stream.packet.context.placid");
	assert(root_action_lucky);
	ret = bt_ctf_field_type_structure_add_field(root_action, root_action_lucky, "lucky");
	assert(ret == 0);
	root_action_dream = bt_ctf_field_type_string_create();
	assert(root_action_dream);
	ret = bt_ctf_field_type_string_set_encoding(root_action_dream, BT_CTF_STRING_ENCODING_UTF8);
	assert(ret == 0);
	ret = bt_ctf_field_type_structure_add_field(root_action, root_action_dream, "dream");
	assert(ret == 0);
	root_action_grandiose_elem = bt_ctf_field_type_integer_create(3);
	assert(root_action_grandiose_elem);
	ret = bt_ctf_field_type_integer_set_signed(root_action_grandiose_elem, 0);
	assert(ret == 0);
	ret = bt_ctf_field_type_integer_set_base(root_action_grandiose_elem, 10);
	assert(ret == 0);
	ret = bt_ctf_field_type_integer_set_encoding(root_action_grandiose_elem, BT_CTF_STRING_ENCODING_NONE);
	assert(ret == 0);
	ret = bt_ctf_field_type_set_byte_order(root_action_grandiose_elem, BT_CTF_BYTE_ORDER_LITTLE_ENDIAN);
	assert(ret == 0);
	ret = bt_ctf_field_type_set_alignment(root_action_grandiose_elem, 1);
	assert(ret == 0);
	root_action_grandiose = bt_ctf_field_type_sequence_create(root_action_grandiose_elem, "trace.packet.header.serious");
	assert(root_action_grandiose);
	ret = bt_ctf_field_type_structure_add_field(root_action, root_action_grandiose, "grandiose");
	assert(ret == 0);
	ret = bt_ctf_field_type_structure_add_field(root, root_action, "action");
	assert(ret == 0);
	root_stiff_elem = bt_ctf_field_type_string_create();
	assert(root_stiff_elem);
	ret = bt_ctf_field_type_string_set_encoding(root_stiff_elem, BT_CTF_STRING_ENCODING_UTF8);
	assert(ret == 0);
	root_stiff = bt_ctf_field_type_sequence_create(root_stiff_elem, "clover.whole.RED");
	assert(root_stiff);
	ret = bt_ctf_field_type_structure_add_field(root, root_stiff, "stiff");
	assert(ret == 0);
	root_fruit = bt_ctf_field_type_structure_create();
	assert(root_fruit);
	ret = bt_ctf_field_type_set_alignment(root_fruit, 1);
	assert(ret == 0);
	root_fruit_apple_elem = bt_ctf_field_type_integer_create(5);
	assert(root_fruit_apple_elem);
	ret = bt_ctf_field_type_integer_set_signed(root_fruit_apple_elem, 0);
	assert(ret == 0);
	ret = bt_ctf_field_type_integer_set_base(root_fruit_apple_elem, 10);
	assert(ret == 0);
	ret = bt_ctf_field_type_integer_set_encoding(root_fruit_apple_elem, BT_CTF_STRING_ENCODING_NONE);
	assert(ret == 0);
	ret = bt_ctf_field_type_set_byte_order(root_fruit_apple_elem, BT_CTF_BYTE_ORDER_LITTLE_ENDIAN);
	assert(ret == 0);
	ret = bt_ctf_field_type_set_alignment(root_fruit_apple_elem, 1);
	assert(ret == 0);
	root_fruit_apple = bt_ctf_field_type_sequence_create(root_fruit_apple_elem, "action.special");
	assert(root_fruit_apple);
	ret = bt_ctf_field_type_structure_add_field(root_fruit, root_fruit_apple, "apple");
	assert(ret == 0);
	ret = bt_ctf_field_type_structure_add_field(root, root_fruit, "fruit");
	assert(ret == 0);

	BT_PUT(root_id);
	BT_PUT(root_timestamp);
	BT_PUT(root_action);
	BT_PUT(root_action_special);
	BT_PUT(root_action_lucky);
	BT_PUT(root_action_lucky_elem);
	BT_PUT(root_action_dream);
	BT_PUT(root_action_grandiose);
	BT_PUT(root_action_grandiose_elem);
	BT_PUT(root_stiff);
	BT_PUT(root_stiff_elem);
	BT_PUT(root_fruit);
	BT_PUT(root_fruit_apple);
	BT_PUT(root_fruit_apple_elem);

	return root;
}

static
struct bt_ctf_field_type *get_good_stream_event_context_type(void)
{
	/*
	Generated by bt-ctfirtg using the following input:

	class: struct
	fields:
	  face:
	    class: struct
	    fields:
	      branch:
	        class: array
	        length: serious
	        element-type:
	          class: string
	      income:
	        class: array
	        length: magic
	        element-type:
	          class: string
	      magic:
	        class: int
	        size: 23
	      lucky:
	        class: array
	        length: magic
	        element-type:
	          class: string
	  cats:
	    class: int
	    size: 5
	  dream:
	    class: array
	    length: stream.packet.context.placid
	    element-type:
	      class: array
	      length: trace.packet.header.iron.dust
	      element-type:
	        class: array
	        length: stream.event.context.face.magic
	        element-type:
	          class: string
	  stream_id:
	    class: int
	    size: 9

	*/

	struct bt_ctf_field_type *root = NULL;
	struct bt_ctf_field_type *root_face = NULL;
	struct bt_ctf_field_type *root_face_branch = NULL;
	struct bt_ctf_field_type *root_face_branch_elem = NULL;
	struct bt_ctf_field_type *root_face_income = NULL;
	struct bt_ctf_field_type *root_face_income_elem = NULL;
	struct bt_ctf_field_type *root_face_magic = NULL;
	struct bt_ctf_field_type *root_face_lucky = NULL;
	struct bt_ctf_field_type *root_face_lucky_elem = NULL;
	struct bt_ctf_field_type *root_cats = NULL;
	struct bt_ctf_field_type *root_dream = NULL;
	struct bt_ctf_field_type *root_dream_elem = NULL;
	struct bt_ctf_field_type *root_dream_elem_elem = NULL;
	struct bt_ctf_field_type *root_dream_elem_elem_elem = NULL;
	struct bt_ctf_field_type *root_stream_id = NULL;

	int ret;
	root = bt_ctf_field_type_structure_create();
	assert(root);
	ret = bt_ctf_field_type_set_alignment(root, 8);
	assert(ret == 0);
	root_face = bt_ctf_field_type_structure_create();
	assert(root_face);
	ret = bt_ctf_field_type_set_alignment(root_face, 8);
	assert(ret == 0);
	root_face_branch_elem = bt_ctf_field_type_string_create();
	assert(root_face_branch_elem);
	ret = bt_ctf_field_type_string_set_encoding(root_face_branch_elem, BT_CTF_STRING_ENCODING_UTF8);
	assert(ret == 0);
	root_face_branch = bt_ctf_field_type_sequence_create(root_face_branch_elem, "serious");
	assert(root_face_branch);
	ret = bt_ctf_field_type_structure_add_field(root_face, root_face_branch, "branch");
	assert(ret == 0);
	root_face_income_elem = bt_ctf_field_type_string_create();
	assert(root_face_income_elem);
	ret = bt_ctf_field_type_string_set_encoding(root_face_income_elem, BT_CTF_STRING_ENCODING_UTF8);
	assert(ret == 0);
	root_face_income = bt_ctf_field_type_sequence_create(root_face_income_elem, "magic");
	assert(root_face_income);
	ret = bt_ctf_field_type_structure_add_field(root_face, root_face_income, "income");
	assert(ret == 0);
	root_face_magic = bt_ctf_field_type_integer_create(23);
	assert(root_face_magic);
	ret = bt_ctf_field_type_integer_set_signed(root_face_magic, 0);
	assert(ret == 0);
	ret = bt_ctf_field_type_integer_set_base(root_face_magic, 10);
	assert(ret == 0);
	ret = bt_ctf_field_type_integer_set_encoding(root_face_magic, BT_CTF_STRING_ENCODING_NONE);
	assert(ret == 0);
	ret = bt_ctf_field_type_set_byte_order(root_face_magic, BT_CTF_BYTE_ORDER_LITTLE_ENDIAN);
	assert(ret == 0);
	ret = bt_ctf_field_type_set_alignment(root_face_magic, 1);
	assert(ret == 0);
	ret = bt_ctf_field_type_structure_add_field(root_face, root_face_magic, "magic");
	assert(ret == 0);
	root_face_lucky_elem = bt_ctf_field_type_string_create();
	assert(root_face_lucky_elem);
	ret = bt_ctf_field_type_string_set_encoding(root_face_lucky_elem, BT_CTF_STRING_ENCODING_UTF8);
	assert(ret == 0);
	root_face_lucky = bt_ctf_field_type_sequence_create(root_face_lucky_elem, "magic");
	assert(root_face_lucky);
	ret = bt_ctf_field_type_structure_add_field(root_face, root_face_lucky, "lucky");
	assert(ret == 0);
	ret = bt_ctf_field_type_structure_add_field(root, root_face, "face");
	assert(ret == 0);
	root_cats = bt_ctf_field_type_integer_create(5);
	assert(root_cats);
	ret = bt_ctf_field_type_integer_set_signed(root_cats, 0);
	assert(ret == 0);
	ret = bt_ctf_field_type_integer_set_base(root_cats, 10);
	assert(ret == 0);
	ret = bt_ctf_field_type_integer_set_encoding(root_cats, BT_CTF_STRING_ENCODING_NONE);
	assert(ret == 0);
	ret = bt_ctf_field_type_set_byte_order(root_cats, BT_CTF_BYTE_ORDER_LITTLE_ENDIAN);
	assert(ret == 0);
	ret = bt_ctf_field_type_set_alignment(root_cats, 1);
	assert(ret == 0);
	ret = bt_ctf_field_type_structure_add_field(root, root_cats, "cats");
	assert(ret == 0);
	root_dream_elem_elem_elem = bt_ctf_field_type_string_create();
	assert(root_dream_elem_elem_elem);
	ret = bt_ctf_field_type_string_set_encoding(root_dream_elem_elem_elem, BT_CTF_STRING_ENCODING_UTF8);
	assert(ret == 0);
	root_dream_elem_elem = bt_ctf_field_type_sequence_create(root_dream_elem_elem_elem, "stream.event.context.face.magic");
	assert(root_dream_elem_elem);
	root_dream_elem = bt_ctf_field_type_sequence_create(root_dream_elem_elem, "trace.packet.header.iron.dust");
	assert(root_dream_elem);
	root_dream = bt_ctf_field_type_sequence_create(root_dream_elem, "stream.packet.context.placid");
	assert(root_dream);
	ret = bt_ctf_field_type_structure_add_field(root, root_dream, "dream");
	assert(ret == 0);
	root_stream_id = bt_ctf_field_type_integer_create(9);
	assert(root_stream_id);
	ret = bt_ctf_field_type_integer_set_signed(root_stream_id, 0);
	assert(ret == 0);
	ret = bt_ctf_field_type_integer_set_base(root_stream_id, 10);
	assert(ret == 0);
	ret = bt_ctf_field_type_integer_set_encoding(root_stream_id, BT_CTF_STRING_ENCODING_NONE);
	assert(ret == 0);
	ret = bt_ctf_field_type_set_byte_order(root_stream_id, BT_CTF_BYTE_ORDER_LITTLE_ENDIAN);
	assert(ret == 0);
	ret = bt_ctf_field_type_set_alignment(root_stream_id, 1);
	assert(ret == 0);
	ret = bt_ctf_field_type_structure_add_field(root, root_stream_id, "stream_id");
	assert(ret == 0);

	BT_PUT(root_face);
	BT_PUT(root_face_branch);
	BT_PUT(root_face_branch_elem);
	BT_PUT(root_face_income);
	BT_PUT(root_face_income_elem);
	BT_PUT(root_face_magic);
	BT_PUT(root_face_lucky);
	BT_PUT(root_face_lucky_elem);
	BT_PUT(root_cats);
	BT_PUT(root_dream);
	BT_PUT(root_dream_elem);
	BT_PUT(root_dream_elem_elem);
	BT_PUT(root_dream_elem_elem_elem);
	BT_PUT(root_stream_id);

	return root;
}

static
struct bt_ctf_field_type *get_good_event_context_type(void)
{
	/*
	Generated by bt-ctfirtg using the following input:

	class: struct
	fields:
	  film:
	    class: int
	    size: 19
	  berry:
	    class: struct
	    fields:
	      pine:
	        class: array
	        length: stream_id
	        element-type:
	          class: string
	      porter:
	        class: array
	        length: face.magic
	        element-type:
	          class: string
	      mice:
	        class: array
	        length: action.special
	        element-type:
	          class: string
	      third:
	        class: int
	        size: 18
	      guard:
	        class: array
	        length: clover.oval
	        element-type:
	          class: string
	      one:
	        class: array
	        length: iron.fire.word
	        element-type:
	          class: string
	  cats:
	    class: int
	    size: 55
	  loud:
	    class: struct
	    fields:
	      toys:
	        class: array
	        length: trace.packet.header.iron.fire.word
	        element-type:
	          class: string
	      spoon:
	        class: array
	        length: stream.packet.context.clover.oval
	        element-type:
	          class: string
	      turkey:
	        class: array
	        length: stream.event.header.action.special
	        element-type:
	          class: string
	      inform:
	        class: array
	        length: stream.event.context.face.magic
	        element-type:
	          class: string
	      odd:
	        class: array
	        length: berry.third
	        element-type:
	          class: string
	      amuck:
	        class: array
	        length: event.context.film
	        element-type:
	          class: string

	*/

	struct bt_ctf_field_type *root = NULL;
	struct bt_ctf_field_type *root_film = NULL;
	struct bt_ctf_field_type *root_berry = NULL;
	struct bt_ctf_field_type *root_berry_pine = NULL;
	struct bt_ctf_field_type *root_berry_pine_elem = NULL;
	struct bt_ctf_field_type *root_berry_porter = NULL;
	struct bt_ctf_field_type *root_berry_porter_elem = NULL;
	struct bt_ctf_field_type *root_berry_mice = NULL;
	struct bt_ctf_field_type *root_berry_mice_elem = NULL;
	struct bt_ctf_field_type *root_berry_third = NULL;
	struct bt_ctf_field_type *root_berry_guard = NULL;
	struct bt_ctf_field_type *root_berry_guard_elem = NULL;
	struct bt_ctf_field_type *root_berry_one = NULL;
	struct bt_ctf_field_type *root_berry_one_elem = NULL;
	struct bt_ctf_field_type *root_cats = NULL;
	struct bt_ctf_field_type *root_loud = NULL;
	struct bt_ctf_field_type *root_loud_toys = NULL;
	struct bt_ctf_field_type *root_loud_toys_elem = NULL;
	struct bt_ctf_field_type *root_loud_spoon = NULL;
	struct bt_ctf_field_type *root_loud_spoon_elem = NULL;
	struct bt_ctf_field_type *root_loud_turkey = NULL;
	struct bt_ctf_field_type *root_loud_turkey_elem = NULL;
	struct bt_ctf_field_type *root_loud_inform = NULL;
	struct bt_ctf_field_type *root_loud_inform_elem = NULL;
	struct bt_ctf_field_type *root_loud_odd = NULL;
	struct bt_ctf_field_type *root_loud_odd_elem = NULL;
	struct bt_ctf_field_type *root_loud_amuck = NULL;
	struct bt_ctf_field_type *root_loud_amuck_elem = NULL;

	int ret;
	root = bt_ctf_field_type_structure_create();
	assert(root);
	ret = bt_ctf_field_type_set_alignment(root, 8);
	assert(ret == 0);
	root_film = bt_ctf_field_type_integer_create(19);
	assert(root_film);
	ret = bt_ctf_field_type_integer_set_signed(root_film, 0);
	assert(ret == 0);
	ret = bt_ctf_field_type_integer_set_base(root_film, 10);
	assert(ret == 0);
	ret = bt_ctf_field_type_integer_set_encoding(root_film, BT_CTF_STRING_ENCODING_NONE);
	assert(ret == 0);
	ret = bt_ctf_field_type_set_byte_order(root_film, BT_CTF_BYTE_ORDER_LITTLE_ENDIAN);
	assert(ret == 0);
	ret = bt_ctf_field_type_set_alignment(root_film, 1);
	assert(ret == 0);
	ret = bt_ctf_field_type_structure_add_field(root, root_film, "film");
	assert(ret == 0);
	root_berry = bt_ctf_field_type_structure_create();
	assert(root_berry);
	ret = bt_ctf_field_type_set_alignment(root_berry, 8);
	assert(ret == 0);
	root_berry_pine_elem = bt_ctf_field_type_string_create();
	assert(root_berry_pine_elem);
	ret = bt_ctf_field_type_string_set_encoding(root_berry_pine_elem, BT_CTF_STRING_ENCODING_UTF8);
	assert(ret == 0);
	root_berry_pine = bt_ctf_field_type_sequence_create(root_berry_pine_elem, "stream_id");
	assert(root_berry_pine);
	ret = bt_ctf_field_type_structure_add_field(root_berry, root_berry_pine, "pine");
	assert(ret == 0);
	root_berry_porter_elem = bt_ctf_field_type_string_create();
	assert(root_berry_porter_elem);
	ret = bt_ctf_field_type_string_set_encoding(root_berry_porter_elem, BT_CTF_STRING_ENCODING_UTF8);
	assert(ret == 0);
	root_berry_porter = bt_ctf_field_type_sequence_create(root_berry_porter_elem, "face.magic");
	assert(root_berry_porter);
	ret = bt_ctf_field_type_structure_add_field(root_berry, root_berry_porter, "porter");
	assert(ret == 0);
	root_berry_mice_elem = bt_ctf_field_type_string_create();
	assert(root_berry_mice_elem);
	ret = bt_ctf_field_type_string_set_encoding(root_berry_mice_elem, BT_CTF_STRING_ENCODING_UTF8);
	assert(ret == 0);
	root_berry_mice = bt_ctf_field_type_sequence_create(root_berry_mice_elem, "action.special");
	assert(root_berry_mice);
	ret = bt_ctf_field_type_structure_add_field(root_berry, root_berry_mice, "mice");
	assert(ret == 0);
	root_berry_third = bt_ctf_field_type_integer_create(18);
	assert(root_berry_third);
	ret = bt_ctf_field_type_integer_set_signed(root_berry_third, 0);
	assert(ret == 0);
	ret = bt_ctf_field_type_integer_set_base(root_berry_third, 10);
	assert(ret == 0);
	ret = bt_ctf_field_type_integer_set_encoding(root_berry_third, BT_CTF_STRING_ENCODING_NONE);
	assert(ret == 0);
	ret = bt_ctf_field_type_set_byte_order(root_berry_third, BT_CTF_BYTE_ORDER_LITTLE_ENDIAN);
	assert(ret == 0);
	ret = bt_ctf_field_type_set_alignment(root_berry_third, 1);
	assert(ret == 0);
	ret = bt_ctf_field_type_structure_add_field(root_berry, root_berry_third, "third");
	assert(ret == 0);
	root_berry_guard_elem = bt_ctf_field_type_string_create();
	assert(root_berry_guard_elem);
	ret = bt_ctf_field_type_string_set_encoding(root_berry_guard_elem, BT_CTF_STRING_ENCODING_UTF8);
	assert(ret == 0);
	root_berry_guard = bt_ctf_field_type_sequence_create(root_berry_guard_elem, "clover.oval");
	assert(root_berry_guard);
	ret = bt_ctf_field_type_structure_add_field(root_berry, root_berry_guard, "guard");
	assert(ret == 0);
	root_berry_one_elem = bt_ctf_field_type_string_create();
	assert(root_berry_one_elem);
	ret = bt_ctf_field_type_string_set_encoding(root_berry_one_elem, BT_CTF_STRING_ENCODING_UTF8);
	assert(ret == 0);
	root_berry_one = bt_ctf_field_type_sequence_create(root_berry_one_elem, "iron.fire.word");
	assert(root_berry_one);
	ret = bt_ctf_field_type_structure_add_field(root_berry, root_berry_one, "one");
	assert(ret == 0);
	ret = bt_ctf_field_type_structure_add_field(root, root_berry, "berry");
	assert(ret == 0);
	root_cats = bt_ctf_field_type_integer_create(55);
	assert(root_cats);
	ret = bt_ctf_field_type_integer_set_signed(root_cats, 0);
	assert(ret == 0);
	ret = bt_ctf_field_type_integer_set_base(root_cats, 10);
	assert(ret == 0);
	ret = bt_ctf_field_type_integer_set_encoding(root_cats, BT_CTF_STRING_ENCODING_NONE);
	assert(ret == 0);
	ret = bt_ctf_field_type_set_byte_order(root_cats, BT_CTF_BYTE_ORDER_LITTLE_ENDIAN);
	assert(ret == 0);
	ret = bt_ctf_field_type_set_alignment(root_cats, 1);
	assert(ret == 0);
	ret = bt_ctf_field_type_structure_add_field(root, root_cats, "cats");
	assert(ret == 0);
	root_loud = bt_ctf_field_type_structure_create();
	assert(root_loud);
	ret = bt_ctf_field_type_set_alignment(root_loud, 8);
	assert(ret == 0);
	root_loud_toys_elem = bt_ctf_field_type_string_create();
	assert(root_loud_toys_elem);
	ret = bt_ctf_field_type_string_set_encoding(root_loud_toys_elem, BT_CTF_STRING_ENCODING_UTF8);
	assert(ret == 0);
	root_loud_toys = bt_ctf_field_type_sequence_create(root_loud_toys_elem, "trace.packet.header.iron.fire.word");
	assert(root_loud_toys);
	ret = bt_ctf_field_type_structure_add_field(root_loud, root_loud_toys, "toys");
	assert(ret == 0);
	root_loud_spoon_elem = bt_ctf_field_type_string_create();
	assert(root_loud_spoon_elem);
	ret = bt_ctf_field_type_string_set_encoding(root_loud_spoon_elem, BT_CTF_STRING_ENCODING_UTF8);
	assert(ret == 0);
	root_loud_spoon = bt_ctf_field_type_sequence_create(root_loud_spoon_elem, "stream.packet.context.clover.oval");
	assert(root_loud_spoon);
	ret = bt_ctf_field_type_structure_add_field(root_loud, root_loud_spoon, "spoon");
	assert(ret == 0);
	root_loud_turkey_elem = bt_ctf_field_type_string_create();
	assert(root_loud_turkey_elem);
	ret = bt_ctf_field_type_string_set_encoding(root_loud_turkey_elem, BT_CTF_STRING_ENCODING_UTF8);
	assert(ret == 0);
	root_loud_turkey = bt_ctf_field_type_sequence_create(root_loud_turkey_elem, "stream.event.header.action.special");
	assert(root_loud_turkey);
	ret = bt_ctf_field_type_structure_add_field(root_loud, root_loud_turkey, "turkey");
	assert(ret == 0);
	root_loud_inform_elem = bt_ctf_field_type_string_create();
	assert(root_loud_inform_elem);
	ret = bt_ctf_field_type_string_set_encoding(root_loud_inform_elem, BT_CTF_STRING_ENCODING_UTF8);
	assert(ret == 0);
	root_loud_inform = bt_ctf_field_type_sequence_create(root_loud_inform_elem, "stream.event.context.face.magic");
	assert(root_loud_inform);
	ret = bt_ctf_field_type_structure_add_field(root_loud, root_loud_inform, "inform");
	assert(ret == 0);
	root_loud_odd_elem = bt_ctf_field_type_string_create();
	assert(root_loud_odd_elem);
	ret = bt_ctf_field_type_string_set_encoding(root_loud_odd_elem, BT_CTF_STRING_ENCODING_UTF8);
	assert(ret == 0);
	root_loud_odd = bt_ctf_field_type_sequence_create(root_loud_odd_elem, "berry.third");
	assert(root_loud_odd);
	ret = bt_ctf_field_type_structure_add_field(root_loud, root_loud_odd, "odd");
	assert(ret == 0);
	root_loud_amuck_elem = bt_ctf_field_type_string_create();
	assert(root_loud_amuck_elem);
	ret = bt_ctf_field_type_string_set_encoding(root_loud_amuck_elem, BT_CTF_STRING_ENCODING_UTF8);
	assert(ret == 0);
	root_loud_amuck = bt_ctf_field_type_sequence_create(root_loud_amuck_elem, "event.context.film");
	assert(root_loud_amuck);
	ret = bt_ctf_field_type_structure_add_field(root_loud, root_loud_amuck, "amuck");
	assert(ret == 0);
	ret = bt_ctf_field_type_structure_add_field(root, root_loud, "loud");
	assert(ret == 0);

	BT_PUT(root_film);
	BT_PUT(root_berry);
	BT_PUT(root_berry_pine);
	BT_PUT(root_berry_pine_elem);
	BT_PUT(root_berry_porter);
	BT_PUT(root_berry_porter_elem);
	BT_PUT(root_berry_mice);
	BT_PUT(root_berry_mice_elem);
	BT_PUT(root_berry_third);
	BT_PUT(root_berry_guard);
	BT_PUT(root_berry_guard_elem);
	BT_PUT(root_berry_one);
	BT_PUT(root_berry_one_elem);
	BT_PUT(root_cats);
	BT_PUT(root_loud);
	BT_PUT(root_loud_toys);
	BT_PUT(root_loud_toys_elem);
	BT_PUT(root_loud_spoon);
	BT_PUT(root_loud_spoon_elem);
	BT_PUT(root_loud_turkey);
	BT_PUT(root_loud_turkey_elem);
	BT_PUT(root_loud_inform);
	BT_PUT(root_loud_inform_elem);
	BT_PUT(root_loud_odd);
	BT_PUT(root_loud_odd_elem);
	BT_PUT(root_loud_amuck);
	BT_PUT(root_loud_amuck_elem);

	return root;
}

static
struct bt_ctf_field_type *get_good_event_payload_type(void)
{
	/*
	Generated by bt-ctfirtg using the following input:

	class: struct
	fields:
	  splendid:
	    class: int
	    size: 12
	  relative:
	    class: struct
	    fields:
	      equal:
	        class: array
	        length: splendid
	        element-type:
	          class: string
	      amuck:
	        class: array
	        length: cats
	        element-type:
	          class: string
	      push:
	        class: array
	        length: berry.third
	        element-type:
	          class: string
	      brick:
	        class: array
	        length: face.magic
	        element-type:
	          class: string
	      amuck:
	        class: array
	        length: id
	        element-type:
	          class: string
	      crush:
	        class: array
	        length: serious
	        element-type:
	          class: string
	      canvas:
	        class: array
	        length: iron.dust
	        element-type:
	          class: string
	  absolute:
	    class: struct
	    fields:
	      equal:
	        class: array
	        length: event.fields.splendid
	        element-type:
	          class: string
	      amuck:
	        class: array
	        length: event.context.cats
	        element-type:
	          class: string
	      push:
	        class: array
	        length: event.context.berry.third
	        element-type:
	          class: string
	      brick:
	        class: array
	        length: stream.event.context.face.magic
	        element-type:
	          class: string
	      amuck:
	        class: array
	        length: stream.event.header.id
	        element-type:
	          class: string
	      crush:
	        class: array
	        length: stream.packet.context.serious
	        element-type:
	          class: string
	      canvas:
	        class: array
	        length: trace.packet.header.iron.dust
	        element-type:
	          class: string

	*/

	struct bt_ctf_field_type *root = NULL;
	struct bt_ctf_field_type *root_splendid = NULL;
	struct bt_ctf_field_type *root_relative = NULL;
	struct bt_ctf_field_type *root_relative_equal = NULL;
	struct bt_ctf_field_type *root_relative_equal_elem = NULL;
	struct bt_ctf_field_type *root_relative_amuck = NULL;
	struct bt_ctf_field_type *root_relative_amuck_elem = NULL;
	struct bt_ctf_field_type *root_relative_push = NULL;
	struct bt_ctf_field_type *root_relative_push_elem = NULL;
	struct bt_ctf_field_type *root_relative_brick = NULL;
	struct bt_ctf_field_type *root_relative_brick_elem = NULL;
	struct bt_ctf_field_type *root_relative_crush = NULL;
	struct bt_ctf_field_type *root_relative_crush_elem = NULL;
	struct bt_ctf_field_type *root_relative_canvas = NULL;
	struct bt_ctf_field_type *root_relative_canvas_elem = NULL;
	struct bt_ctf_field_type *root_absolute = NULL;
	struct bt_ctf_field_type *root_absolute_equal = NULL;
	struct bt_ctf_field_type *root_absolute_equal_elem = NULL;
	struct bt_ctf_field_type *root_absolute_amuck = NULL;
	struct bt_ctf_field_type *root_absolute_amuck_elem = NULL;
	struct bt_ctf_field_type *root_absolute_push = NULL;
	struct bt_ctf_field_type *root_absolute_push_elem = NULL;
	struct bt_ctf_field_type *root_absolute_brick = NULL;
	struct bt_ctf_field_type *root_absolute_brick_elem = NULL;
	struct bt_ctf_field_type *root_absolute_crush = NULL;
	struct bt_ctf_field_type *root_absolute_crush_elem = NULL;
	struct bt_ctf_field_type *root_absolute_canvas = NULL;
	struct bt_ctf_field_type *root_absolute_canvas_elem = NULL;

	int ret;
	root = bt_ctf_field_type_structure_create();
	assert(root);
	ret = bt_ctf_field_type_set_alignment(root, 8);
	assert(ret == 0);
	root_splendid = bt_ctf_field_type_integer_create(12);
	assert(root_splendid);
	ret = bt_ctf_field_type_integer_set_signed(root_splendid, 0);
	assert(ret == 0);
	ret = bt_ctf_field_type_integer_set_base(root_splendid, 10);
	assert(ret == 0);
	ret = bt_ctf_field_type_integer_set_encoding(root_splendid, BT_CTF_STRING_ENCODING_NONE);
	assert(ret == 0);
	ret = bt_ctf_field_type_set_byte_order(root_splendid, BT_CTF_BYTE_ORDER_LITTLE_ENDIAN);
	assert(ret == 0);
	ret = bt_ctf_field_type_set_alignment(root_splendid, 1);
	assert(ret == 0);
	ret = bt_ctf_field_type_structure_add_field(root, root_splendid, "splendid");
	assert(ret == 0);
	root_relative = bt_ctf_field_type_structure_create();
	assert(root_relative);
	ret = bt_ctf_field_type_set_alignment(root_relative, 8);
	assert(ret == 0);
	root_relative_equal_elem = bt_ctf_field_type_string_create();
	assert(root_relative_equal_elem);
	ret = bt_ctf_field_type_string_set_encoding(root_relative_equal_elem, BT_CTF_STRING_ENCODING_UTF8);
	assert(ret == 0);
	root_relative_equal = bt_ctf_field_type_sequence_create(root_relative_equal_elem, "splendid");
	assert(root_relative_equal);
	ret = bt_ctf_field_type_structure_add_field(root_relative, root_relative_equal, "equal");
	assert(ret == 0);
	root_relative_amuck_elem = bt_ctf_field_type_string_create();
	assert(root_relative_amuck_elem);
	ret = bt_ctf_field_type_string_set_encoding(root_relative_amuck_elem, BT_CTF_STRING_ENCODING_UTF8);
	assert(ret == 0);
	root_relative_amuck = bt_ctf_field_type_sequence_create(root_relative_amuck_elem, "id");
	assert(root_relative_amuck);
	ret = bt_ctf_field_type_structure_add_field(root_relative, root_relative_amuck, "amuck");
	assert(ret == 0);
	root_relative_push_elem = bt_ctf_field_type_string_create();
	assert(root_relative_push_elem);
	ret = bt_ctf_field_type_string_set_encoding(root_relative_push_elem, BT_CTF_STRING_ENCODING_UTF8);
	assert(ret == 0);
	root_relative_push = bt_ctf_field_type_sequence_create(root_relative_push_elem, "berry.third");
	assert(root_relative_push);
	ret = bt_ctf_field_type_structure_add_field(root_relative, root_relative_push, "push");
	assert(ret == 0);
	root_relative_brick_elem = bt_ctf_field_type_string_create();
	assert(root_relative_brick_elem);
	ret = bt_ctf_field_type_string_set_encoding(root_relative_brick_elem, BT_CTF_STRING_ENCODING_UTF8);
	assert(ret == 0);
	root_relative_brick = bt_ctf_field_type_sequence_create(root_relative_brick_elem, "face.magic");
	assert(root_relative_brick);
	ret = bt_ctf_field_type_structure_add_field(root_relative, root_relative_brick, "brick");
	assert(ret == 0);
	root_relative_crush_elem = bt_ctf_field_type_string_create();
	assert(root_relative_crush_elem);
	ret = bt_ctf_field_type_string_set_encoding(root_relative_crush_elem, BT_CTF_STRING_ENCODING_UTF8);
	assert(ret == 0);
	root_relative_crush = bt_ctf_field_type_sequence_create(root_relative_crush_elem, "serious");
	assert(root_relative_crush);
	ret = bt_ctf_field_type_structure_add_field(root_relative, root_relative_crush, "crush");
	assert(ret == 0);
	root_relative_canvas_elem = bt_ctf_field_type_string_create();
	assert(root_relative_canvas_elem);
	ret = bt_ctf_field_type_string_set_encoding(root_relative_canvas_elem, BT_CTF_STRING_ENCODING_UTF8);
	assert(ret == 0);
	root_relative_canvas = bt_ctf_field_type_sequence_create(root_relative_canvas_elem, "iron.dust");
	assert(root_relative_canvas);
	ret = bt_ctf_field_type_structure_add_field(root_relative, root_relative_canvas, "canvas");
	assert(ret == 0);
	ret = bt_ctf_field_type_structure_add_field(root, root_relative, "relative");
	assert(ret == 0);
	root_absolute = bt_ctf_field_type_structure_create();
	assert(root_absolute);
	ret = bt_ctf_field_type_set_alignment(root_absolute, 8);
	assert(ret == 0);
	root_absolute_equal_elem = bt_ctf_field_type_string_create();
	assert(root_absolute_equal_elem);
	ret = bt_ctf_field_type_string_set_encoding(root_absolute_equal_elem, BT_CTF_STRING_ENCODING_UTF8);
	assert(ret == 0);
	root_absolute_equal = bt_ctf_field_type_sequence_create(root_absolute_equal_elem, "event.fields.splendid");
	assert(root_absolute_equal);
	ret = bt_ctf_field_type_structure_add_field(root_absolute, root_absolute_equal, "equal");
	assert(ret == 0);
	root_absolute_amuck_elem = bt_ctf_field_type_string_create();
	assert(root_absolute_amuck_elem);
	ret = bt_ctf_field_type_string_set_encoding(root_absolute_amuck_elem, BT_CTF_STRING_ENCODING_UTF8);
	assert(ret == 0);
	root_absolute_amuck = bt_ctf_field_type_sequence_create(root_absolute_amuck_elem, "stream.event.header.id");
	assert(root_absolute_amuck);
	ret = bt_ctf_field_type_structure_add_field(root_absolute, root_absolute_amuck, "amuck");
	assert(ret == 0);
	root_absolute_push_elem = bt_ctf_field_type_string_create();
	assert(root_absolute_push_elem);
	ret = bt_ctf_field_type_string_set_encoding(root_absolute_push_elem, BT_CTF_STRING_ENCODING_UTF8);
	assert(ret == 0);
	root_absolute_push = bt_ctf_field_type_sequence_create(root_absolute_push_elem, "event.context.berry.third");
	assert(root_absolute_push);
	ret = bt_ctf_field_type_structure_add_field(root_absolute, root_absolute_push, "push");
	assert(ret == 0);
	root_absolute_brick_elem = bt_ctf_field_type_string_create();
	assert(root_absolute_brick_elem);
	ret = bt_ctf_field_type_string_set_encoding(root_absolute_brick_elem, BT_CTF_STRING_ENCODING_UTF8);
	assert(ret == 0);
	root_absolute_brick = bt_ctf_field_type_sequence_create(root_absolute_brick_elem, "stream.event.context.face.magic");
	assert(root_absolute_brick);
	ret = bt_ctf_field_type_structure_add_field(root_absolute, root_absolute_brick, "brick");
	assert(ret == 0);
	root_absolute_crush_elem = bt_ctf_field_type_string_create();
	assert(root_absolute_crush_elem);
	ret = bt_ctf_field_type_string_set_encoding(root_absolute_crush_elem, BT_CTF_STRING_ENCODING_UTF8);
	assert(ret == 0);
	root_absolute_crush = bt_ctf_field_type_sequence_create(root_absolute_crush_elem, "stream.packet.context.serious");
	assert(root_absolute_crush);
	ret = bt_ctf_field_type_structure_add_field(root_absolute, root_absolute_crush, "crush");
	assert(ret == 0);
	root_absolute_canvas_elem = bt_ctf_field_type_string_create();
	assert(root_absolute_canvas_elem);
	ret = bt_ctf_field_type_string_set_encoding(root_absolute_canvas_elem, BT_CTF_STRING_ENCODING_UTF8);
	assert(ret == 0);
	root_absolute_canvas = bt_ctf_field_type_sequence_create(root_absolute_canvas_elem, "trace.packet.header.iron.dust");
	assert(root_absolute_canvas);
	ret = bt_ctf_field_type_structure_add_field(root_absolute, root_absolute_canvas, "canvas");
	assert(ret == 0);
	ret = bt_ctf_field_type_structure_add_field(root, root_absolute, "absolute");
	assert(ret == 0);

	BT_PUT(root_splendid);
	BT_PUT(root_relative);
	BT_PUT(root_relative_equal);
	BT_PUT(root_relative_equal_elem);
	BT_PUT(root_relative_amuck);
	BT_PUT(root_relative_amuck_elem);
	BT_PUT(root_relative_push);
	BT_PUT(root_relative_push_elem);
	BT_PUT(root_relative_brick);
	BT_PUT(root_relative_brick_elem);
	BT_PUT(root_relative_crush);
	BT_PUT(root_relative_crush_elem);
	BT_PUT(root_relative_canvas);
	BT_PUT(root_relative_canvas_elem);
	BT_PUT(root_absolute);
	BT_PUT(root_absolute_equal);
	BT_PUT(root_absolute_equal_elem);
	BT_PUT(root_absolute_amuck);
	BT_PUT(root_absolute_amuck_elem);
	BT_PUT(root_absolute_push);
	BT_PUT(root_absolute_push_elem);
	BT_PUT(root_absolute_brick);
	BT_PUT(root_absolute_brick_elem);
	BT_PUT(root_absolute_crush);
	BT_PUT(root_absolute_crush_elem);
	BT_PUT(root_absolute_canvas);
	BT_PUT(root_absolute_canvas_elem);

	return root;
}

static
struct bt_ctf_field_type *get_child_ft(struct bt_ctf_field_type *parent_ft,
		const char *name)
{
	struct bt_ctf_field_type *ft = NULL;

	switch (bt_ctf_field_type_get_type_id(parent_ft)) {
	case CTF_TYPE_STRUCT:
		ft = bt_ctf_field_type_structure_get_field_type_by_name(
			parent_ft, name);
		break;

	case CTF_TYPE_VARIANT:
		ft = bt_ctf_field_type_variant_get_field_type_by_name(
			parent_ft, name);
		break;

	case CTF_TYPE_ARRAY:
		ft = bt_ctf_field_type_array_get_element_type(parent_ft);
		break;

	case CTF_TYPE_SEQUENCE:
		ft = bt_ctf_field_type_sequence_get_element_type(parent_ft);
		break;

	case CTF_TYPE_ENUM:
		ft = bt_ctf_field_type_enumeration_get_container_type(
			parent_ft);
		break;

	default:
		break;
	}

	assert(ft);

	return ft;
}

static
struct bt_ctf_field_type *get_ft(struct bt_ctf_field_type *root_ft, ...)
{
	struct bt_ctf_field_type *child_ft = NULL;
	struct bt_ctf_field_type *ft = root_ft;
	va_list ap;

	va_start(ap, root_ft);
	bt_get(ft);

	while (true) {
		const char *field_name = va_arg(ap, const char *);

		if (field_name == NULL) {
			break;
		}

		child_ft = get_child_ft(ft, field_name);

		if (!child_ft) {
			BT_PUT(ft);
			goto end;
		}

		BT_MOVE(ft, child_ft);
	}

end:
	va_end(ap);

	return ft;
}

#define FIELD_PATH_END	-2

static
int validate_field_path(struct bt_ctf_field_type *field_type, int int_root, ...)
{
	enum bt_ctf_scope root = int_root;
	int ret = 0;
	int len;
	int expected_index;
	int actual_index;
	int i = 0;
	struct bt_ctf_field_path *field_path = NULL;
	va_list ap;

	va_start(ap, int_root);
	if (bt_ctf_field_type_is_sequence(field_type)) {
		field_path = bt_ctf_field_type_sequence_get_length_field_path(
				field_type);
	} else if (bt_ctf_field_type_is_variant(field_type)) {
		field_path = bt_ctf_field_type_variant_get_tag_field_path(
				field_type);
	}

	if (!field_path) {
		ret = -1;
		goto end;
	}

	if (bt_ctf_field_path_get_root_scope(field_path) != root) {
		ret = -1;
		goto end;
	}

	len = bt_ctf_field_path_get_index_count(field_path);

	while (true) {
		expected_index = va_arg(ap, int);

		if (expected_index == FIELD_PATH_END) {
			break;
		}

		if (i == len) {
			break;
		}

		actual_index = bt_ctf_field_path_get_index(field_path, i);

		if (actual_index == INT_MIN) {
			ret = -1;
			goto end;
		}

		i++;
	}

	if (i != len || expected_index != FIELD_PATH_END) {
		ret = -1;
	}

end:
	BT_PUT(field_path);
	va_end(ap);

	return ret;
}

static
void validate_test_pass(struct bt_ctf_trace *trace)
{
	struct bt_ctf_stream_class *sc;
	struct bt_ctf_event_class *ec;
	struct bt_ctf_field_type *ph;
	struct bt_ctf_field_type *pc;
	struct bt_ctf_field_type *eh;
	struct bt_ctf_field_type *sec;
	struct bt_ctf_field_type *ectx;
	struct bt_ctf_field_type *ep;
	struct bt_ctf_field_type *ft_src = NULL;
	struct bt_ctf_field_type *ft_target = NULL;
	struct bt_ctf_field_type *ft_tag = NULL;

	sc = bt_ctf_trace_get_stream_class_by_index(trace, 0);
	assert(sc);
	ec = bt_ctf_stream_class_get_event_class_by_index(sc, 0);
	assert(ec);

	ph = bt_ctf_trace_get_packet_header_type(trace);
	ok(ph, "Trace packet header still exists after successful validation");
	pc = bt_ctf_stream_class_get_packet_context_type(sc);
	ok(pc, "Stream packet context still exists after successful validation");
	eh = bt_ctf_stream_class_get_event_header_type(sc);
	ok(eh, "Stream event header still exists after successful validation");
	sec = bt_ctf_stream_class_get_event_context_type(sc);
	ok(sec, "Stream event context still exists after successful validation");
	ectx = bt_ctf_event_class_get_context_type(ec);
	ok(ectx, "Event context still exists after successful validation");
	ep = bt_ctf_event_class_get_payload_type(ec);
	ok(ep, "Event payload still exists after successful validation");

	/* trace.packet.header.iron.fire.keen */
	ft_src = get_ft(ph, "iron", "fire", "keen", NULL);
	ok(!validate_field_path(ft_src, BT_CTF_SCOPE_TRACE_PACKET_HEADER,
		3, 3, 0, FIELD_PATH_END),
		"trace.packet.header.iron.fire.keen has the correct field path");
	BT_PUT(ft_src);

	/* trace.packet.header.iron.fire.keen.[element] */
	ft_src = get_ft(ph, "iron", "fire", "keen", "", NULL);
	ok(!validate_field_path(ft_src,
		BT_CTF_SCOPE_TRACE_PACKET_HEADER, 3, 2, FIELD_PATH_END),
		"trace.packet.header.iron.fire.keen.[element] has the correct field path");
	ft_target = get_ft(ph, "iron", "parallel", NULL);
	ft_tag = bt_ctf_field_type_variant_get_tag_type(ft_src);
	ok(ft_tag == ft_target,
		"trace.packet.header.iron.fire.keen.[element] has the correct tag type");
	BT_PUT(ft_src);
	BT_PUT(ft_target);
	BT_PUT(ft_tag);

	/* trace.packet.header.iron.fire.keen.[element].BLUE */
	ft_src = get_ft(ph, "iron", "fire", "keen", "", "BLUE", NULL);
	ok(!validate_field_path(ft_src,
		BT_CTF_SCOPE_TRACE_PACKET_HEADER, 0, FIELD_PATH_END),
		"trace.packet.header.iron.fire.keen.[element].BLUE has the correct field path");
	BT_PUT(ft_src);

	/* trace.packet.header.iron.report */
	ft_src = get_ft(ph, "iron", "report", NULL);
	ok(!validate_field_path(ft_src,
		BT_CTF_SCOPE_TRACE_PACKET_HEADER, 3, 1, FIELD_PATH_END),
		"trace.packet.header.iron.report has the correct field path");
	BT_PUT(ft_src);

	/* trace.packet.header.iron.group */
	ft_src = get_ft(ph, "iron", "group", NULL);
	ok(!validate_field_path(ft_src,
		BT_CTF_SCOPE_TRACE_PACKET_HEADER, 2, FIELD_PATH_END),
		"trace.packet.header.iron.group has the correct field path");
	BT_PUT(ft_src);

	/* stream.packet.context.naive.[element] */
	ft_src = get_ft(pc, "naive", "", NULL);
	ok(!validate_field_path(ft_src,
		BT_CTF_SCOPE_STREAM_PACKET_CONTEXT, 0, FIELD_PATH_END),
		"stream.packet.context.naive.[element] has the correct field path");
	BT_PUT(ft_src);

	/* stream.packet.context.clover.whole */
	ft_src = get_ft(pc, "clover", "whole", NULL);
	ok(!validate_field_path(ft_src,
		BT_CTF_SCOPE_TRACE_PACKET_HEADER, 3, 2, FIELD_PATH_END),
		"stream.packet.context.clover.whole has the correct field path");
	ft_target = get_ft(ph, "iron", "parallel", NULL);
	ft_tag = bt_ctf_field_type_variant_get_tag_type(ft_src);
	ok(ft_tag == ft_target,
		"stream.packet.context.clover.whole has the correct tag type");
	BT_PUT(ft_src);
	BT_PUT(ft_target);
	BT_PUT(ft_tag);

	/* stream.packet.context.clover.whole.BLUE */
	ft_src = get_ft(pc, "clover", "whole", "BLUE", NULL);
	ok(!validate_field_path(ft_src,
		BT_CTF_SCOPE_TRACE_PACKET_HEADER, 3, 3, 0, FIELD_PATH_END),
		"stream.packet.context.clover.whole.BLUE has the correct field path");
	BT_PUT(ft_src);

	/* stream.packet.context.clover.egg */
	ft_src = get_ft(pc, "clover", "egg", NULL);
	ok(!validate_field_path(ft_src,
		BT_CTF_SCOPE_STREAM_PACKET_CONTEXT, 4, 0, FIELD_PATH_END),
		"stream.packet.context.clover.egg has the correct field path");
	BT_PUT(ft_src);

	/* stream.packet.context.clover.useful */
	ft_src = get_ft(pc, "clover", "useful", NULL);
	ok(!validate_field_path(ft_src,
		BT_CTF_SCOPE_STREAM_PACKET_CONTEXT, 2, FIELD_PATH_END),
		"stream.packet.context.clover.useful has the correct field path");
	BT_PUT(ft_src);

	/* stream.event.header.action.lucky */
	ft_src = get_ft(eh, "action", "lucky", NULL);
	ok(!validate_field_path(ft_src,
		BT_CTF_SCOPE_STREAM_PACKET_CONTEXT, 0, FIELD_PATH_END),
		"stream.event.header.action.lucky has the correct field path");
	BT_PUT(ft_src);

	/* stream.event.header.stiff */
	ft_src = get_ft(eh, "stiff", NULL);
	ok(!validate_field_path(ft_src,
		BT_CTF_SCOPE_STREAM_PACKET_CONTEXT, 4, 1, 1, FIELD_PATH_END),
		"stream.event.header.stiff has the correct field path");
	BT_PUT(ft_src);

	/* stream.event.header.fruit.apple */
	ft_src = get_ft(eh, "fruit", "apple", NULL);
	ok(!validate_field_path(ft_src,
		BT_CTF_SCOPE_STREAM_EVENT_HEADER, 2, 0, FIELD_PATH_END),
		"stream.event.header.fruit.apple has the correct field path");
	BT_PUT(ft_src);

	/* stream.event.context.face.branch */
	ft_src = get_ft(sec, "face", "branch", NULL);
	ok(!validate_field_path(ft_src,
		BT_CTF_SCOPE_STREAM_PACKET_CONTEXT, 2, FIELD_PATH_END),
		"stream.event.context.face.branch has the correct field path");
	BT_PUT(ft_src);

	/* stream.event.context.face.income */
	ft_src = get_ft(sec, "face", "income", NULL);
	ok(!validate_field_path(ft_src,
		BT_CTF_SCOPE_TRACE_PACKET_HEADER, 0, FIELD_PATH_END),
		"stream.event.context.face.income has the correct field path");
	BT_PUT(ft_src);

	/* stream.event.context.face.lucky */
	ft_src = get_ft(sec, "face", "lucky", NULL);
	ok(!validate_field_path(ft_src,
		BT_CTF_SCOPE_STREAM_EVENT_CONTEXT, 0, 2, FIELD_PATH_END),
		"stream.event.context.face.lucky has the correct field path");
	BT_PUT(ft_src);

	/* stream.event.context.dream */
	ft_src = get_ft(sec, "dream", NULL);
	ok(!validate_field_path(ft_src,
		BT_CTF_SCOPE_STREAM_PACKET_CONTEXT, 0, FIELD_PATH_END),
		"stream.event.context.dream has the correct field path");
	BT_PUT(ft_src);

	/* stream.event.context.dream.[element] */
	ft_src = get_ft(sec, "dream", "", NULL);
	ok(!validate_field_path(ft_src,
		BT_CTF_SCOPE_TRACE_PACKET_HEADER, 3, 1, FIELD_PATH_END),
		"stream.event.context.dream.[element] has the correct field path");
	BT_PUT(ft_src);

	/* stream.event.context.dream.[element].[element] */
	ft_src = get_ft(sec, "dream", "", "", NULL);
	ok(!validate_field_path(ft_src,
		BT_CTF_SCOPE_STREAM_EVENT_CONTEXT, 0, 2, FIELD_PATH_END),
		"stream.event.context.dream.[element].[element] has the correct field path");
	BT_PUT(ft_src);

	/* event.context.berry.porter */
	ft_src = get_ft(ectx, "berry", "porter", NULL);
	ok(!validate_field_path(ft_src,
		BT_CTF_SCOPE_STREAM_EVENT_CONTEXT, 0, 2, FIELD_PATH_END),
		"event.context.berry.porter has the correct field path");
	BT_PUT(ft_src);

	/* event.context.berry.porter */
	ft_src = get_ft(ectx, "berry", "porter", NULL);
	ok(!validate_field_path(ft_src,
		BT_CTF_SCOPE_STREAM_EVENT_CONTEXT, 0, 2, FIELD_PATH_END),
		"event.context.berry.porter has the correct field path");
	BT_PUT(ft_src);

	/* event.context.berry.mice */
	ft_src = get_ft(ectx, "berry", "mice", NULL);
	ok(!validate_field_path(ft_src,
		BT_CTF_SCOPE_STREAM_EVENT_HEADER, 2, 0, FIELD_PATH_END),
		"event.context.berry.mice has the correct field path");
	BT_PUT(ft_src);

	/* event.context.berry.guard */
	ft_src = get_ft(ectx, "berry", "guard", NULL);
	ok(!validate_field_path(ft_src,
		BT_CTF_SCOPE_STREAM_PACKET_CONTEXT, 4, 0, FIELD_PATH_END),
		"event.context.berry.guard has the correct field path");
	BT_PUT(ft_src);

	/* event.context.berry.one */
	ft_src = get_ft(ectx, "berry", "one", NULL);
	ok(!validate_field_path(ft_src,
		BT_CTF_SCOPE_TRACE_PACKET_HEADER, 3, 3, 0, FIELD_PATH_END),
		"event.context.berry.one has the correct field path");
	BT_PUT(ft_src);

	/* event.context.loud.toys */
	ft_src = get_ft(ectx, "loud", "toys", NULL);
	ok(!validate_field_path(ft_src,
		BT_CTF_SCOPE_TRACE_PACKET_HEADER, 3, 3, 0, FIELD_PATH_END),
		"event.context.loud.toys has the correct field path");
	BT_PUT(ft_src);

	/* event.context.loud.spoon */
	ft_src = get_ft(ectx, "loud", "spoon", NULL);
	ok(!validate_field_path(ft_src,
		BT_CTF_SCOPE_STREAM_PACKET_CONTEXT, 4, 0, FIELD_PATH_END),
		"event.context.loud.spoon has the correct field path");
	BT_PUT(ft_src);

	/* event.context.loud.turkey */
	ft_src = get_ft(ectx, "loud", "turkey", NULL);
	ok(!validate_field_path(ft_src,
		BT_CTF_SCOPE_STREAM_EVENT_HEADER, 2, 0, FIELD_PATH_END),
		"event.context.loud.turkey has the correct field path");
	BT_PUT(ft_src);

	/* event.context.loud.inform */
	ft_src = get_ft(ectx, "loud", "inform", NULL);
	ok(!validate_field_path(ft_src,
		BT_CTF_SCOPE_STREAM_EVENT_CONTEXT, 0, 2, FIELD_PATH_END),
		"event.context.loud.inform has the correct field path");
	BT_PUT(ft_src);

	/* event.context.loud.odd */
	ft_src = get_ft(ectx, "loud", "odd", NULL);
	ok(!validate_field_path(ft_src,
		BT_CTF_SCOPE_EVENT_CONTEXT, 1, 3, FIELD_PATH_END),
		"event.context.loud.odd has the correct field path");
	BT_PUT(ft_src);

	/* event.context.loud.amuck */
	ft_src = get_ft(ectx, "loud", "amuck", NULL);
	ok(!validate_field_path(ft_src,
		BT_CTF_SCOPE_EVENT_CONTEXT, 0, FIELD_PATH_END),
		"event.context.loud.amuck has the correct field path");
	BT_PUT(ft_src);

	/* event.fields.relative.equal */
	ft_src = get_ft(ep, "relative", "equal", NULL);
	ok(!validate_field_path(ft_src,
		BT_CTF_SCOPE_EVENT_FIELDS, 0, FIELD_PATH_END),
		"event.fields.relative.equal has the correct field path");
	BT_PUT(ft_src);

	/* event.fields.relative.amuck */
	ft_src = get_ft(ep, "relative", "amuck", NULL);
	ok(!validate_field_path(ft_src,
		BT_CTF_SCOPE_STREAM_EVENT_HEADER, 0, FIELD_PATH_END),
		"event.fields.relative.amuck has the correct field path");
	BT_PUT(ft_src);

	/* event.fields.relative.push */
	ft_src = get_ft(ep, "relative", "push", NULL);
	ok(!validate_field_path(ft_src,
		BT_CTF_SCOPE_EVENT_CONTEXT, 1, 3, FIELD_PATH_END),
		"event.fields.relative.push has the correct field path");
	BT_PUT(ft_src);

	/* event.fields.relative.brick */
	ft_src = get_ft(ep, "relative", "brick", NULL);
	ok(!validate_field_path(ft_src,
		BT_CTF_SCOPE_STREAM_EVENT_CONTEXT, 0, 2, FIELD_PATH_END),
		"event.fields.relative.brick has the correct field path");
	BT_PUT(ft_src);

	/* event.fields.relative.crush */
	ft_src = get_ft(ep, "relative", "crush", NULL);
	ok(!validate_field_path(ft_src,
		BT_CTF_SCOPE_STREAM_PACKET_CONTEXT, 2, FIELD_PATH_END),
		"event.fields.relative.crush has the correct field path");
	BT_PUT(ft_src);

	/* event.fields.relative.canvas */
	ft_src = get_ft(ep, "relative", "canvas", NULL);
	ok(!validate_field_path(ft_src,
		BT_CTF_SCOPE_TRACE_PACKET_HEADER, 3, 1, FIELD_PATH_END),
		"event.fields.relative.canvas has the correct field path");
	BT_PUT(ft_src);

	/* event.fields.absolute.equal */
	ft_src = get_ft(ep, "absolute", "equal", NULL);
	ok(!validate_field_path(ft_src,
		BT_CTF_SCOPE_EVENT_FIELDS, 0, FIELD_PATH_END),
		"event.fields.absolute.equal has the correct field path");
	BT_PUT(ft_src);

	/* event.fields.absolute.amuck */
	ft_src = get_ft(ep, "absolute", "amuck", NULL);
	ok(!validate_field_path(ft_src,
		BT_CTF_SCOPE_STREAM_EVENT_HEADER, 0, FIELD_PATH_END),
		"event.fields.absolute.amuck has the correct field path");
	BT_PUT(ft_src);

	/* event.fields.absolute.push */
	ft_src = get_ft(ep, "absolute", "push", NULL);
	ok(!validate_field_path(ft_src,
		BT_CTF_SCOPE_EVENT_CONTEXT, 1, 3, FIELD_PATH_END),
		"event.fields.absolute.push has the correct field path");
	BT_PUT(ft_src);

	/* event.fields.absolute.brick */
	ft_src = get_ft(ep, "absolute", "brick", NULL);
	ok(!validate_field_path(ft_src,
		BT_CTF_SCOPE_STREAM_EVENT_CONTEXT, 0, 2, FIELD_PATH_END),
		"event.fields.absolute.brick has the correct field path");
	BT_PUT(ft_src);

	/* event.fields.absolute.crush */
	ft_src = get_ft(ep, "absolute", "crush", NULL);
	ok(!validate_field_path(ft_src,
		BT_CTF_SCOPE_STREAM_PACKET_CONTEXT, 2, FIELD_PATH_END),
		"event.fields.absolute.crush has the correct field path");
	BT_PUT(ft_src);

	/* event.fields.absolute.canvas */
	ft_src = get_ft(ep, "absolute", "canvas", NULL);
	ok(!validate_field_path(ft_src,
		BT_CTF_SCOPE_TRACE_PACKET_HEADER, 3, 1, FIELD_PATH_END),
		"event.fields.absolute.canvas has the correct field path");
	BT_PUT(ft_src);

	BT_PUT(ft_src);
	BT_PUT(ft_target);
	BT_PUT(ph);
	BT_PUT(pc);
	BT_PUT(eh);
	BT_PUT(sec);
	BT_PUT(ectx);
	BT_PUT(ep);
	BT_PUT(sc);
	BT_PUT(ec);
}

static
void test_pass(void)
{
	int ret;
	struct bt_ctf_trace *trace;
	struct bt_ctf_stream_class *sc;
	struct bt_ctf_event_class *ec;
	struct bt_ctf_field_type *ph;
	struct bt_ctf_field_type *pc;
	struct bt_ctf_field_type *eh;
	struct bt_ctf_field_type *sec;
	struct bt_ctf_field_type *ectx;
	struct bt_ctf_field_type *ep;

	trace = bt_ctf_trace_create();
	assert(trace);
	sc = bt_ctf_stream_class_create("nice_piece_of_stream_class");
	assert(sc);
	ec = bt_ctf_event_class_create("oh_what_an_event_class");
	assert(ec);

	ph = get_good_packet_header_type();
	assert(ph);
	pc = get_good_packet_context_type();
	assert(pc);
	eh = get_good_event_header_type();
	assert(eh);
	sec = get_good_stream_event_context_type();
	assert(sec);
	ectx = get_good_event_context_type();
	assert(ec);
	ep = get_good_event_payload_type();
	assert(ep);

	ret = bt_ctf_trace_set_packet_header_type(trace, ph);
	assert(ret == 0);
	ret = bt_ctf_stream_class_set_packet_context_type(sc, pc);
	assert(ret == 0);
	ret = bt_ctf_stream_class_set_event_header_type(sc, eh);
	assert(ret == 0);
	ret = bt_ctf_stream_class_set_event_context_type(sc, sec);
	assert(ret == 0);
	ret = bt_ctf_event_class_set_context_type(ec, ectx);
	assert(ret == 0);
	ret = bt_ctf_event_class_set_payload_type(ec, ep);
	assert(ret == 0);

	ret = bt_ctf_stream_class_add_event_class(sc, ec);
	assert(ret == 0);

	/* Validation happens here */
	ret = bt_ctf_trace_add_stream_class(trace, sc);
	ok(ret == 0, "Valid type system is considered valid");

	validate_test_pass(trace);

	BT_PUT(ph);
	BT_PUT(pc);
	BT_PUT(eh);
	BT_PUT(sec);
	BT_PUT(ectx);
	BT_PUT(ep);
	BT_PUT(trace);
	BT_PUT(sc);
	BT_PUT(ec);
}

static
struct bt_ctf_event *create_event_with_context_and_payload(
		struct bt_ctf_field_type *ectx, struct bt_ctf_field_type *ep)
{
	int ret;
	struct bt_ctf_stream_class *sc;
	struct bt_ctf_event_class *ec;
	struct bt_ctf_event *event;

	sc = bt_ctf_stream_class_create("sc");
	assert(sc);
	ec = bt_ctf_event_class_create("ec");
	assert(ec);

	if (ectx) {
		ret = bt_ctf_event_class_set_context_type(ec, ectx);
		assert(ret == 0);
	}

	if (ep) {
		ret = bt_ctf_event_class_set_payload_type(ec, ep);
		assert(ret == 0);
	}

	ret = bt_ctf_stream_class_add_event_class(sc, ec);
	assert(ret == 0);

	/* Validation happens here */
	event = bt_ctf_event_create(ec);

	BT_PUT(ec);
	BT_PUT(sc);

	return event;
}


static
struct bt_ctf_field_type *test_fail_unavailable_root_get_event_payload(void)
{
	/*
	Generated by bt-ctfirtg using the following input:

	class: struct
	fields:
	  a:
	    class: int
	    size: 32
	  b:
	    class: array
	    length: stream.event.context.lol
	    element-type:
	      class: string
	  c:
	    class: string

	*/

	struct bt_ctf_field_type *root = NULL;
	struct bt_ctf_field_type *root_a = NULL;
	struct bt_ctf_field_type *root_b = NULL;
	struct bt_ctf_field_type *root_b_elem = NULL;
	struct bt_ctf_field_type *root_c = NULL;

	int ret;
	root = bt_ctf_field_type_structure_create();
	assert(root);
	ret = bt_ctf_field_type_set_alignment(root, 8);
	assert(ret == 0);
	root_a = bt_ctf_field_type_integer_create(32);
	assert(root_a);
	ret = bt_ctf_field_type_integer_set_signed(root_a, 0);
	assert(ret == 0);
	ret = bt_ctf_field_type_integer_set_base(root_a, 10);
	assert(ret == 0);
	ret = bt_ctf_field_type_integer_set_encoding(root_a, BT_CTF_STRING_ENCODING_NONE);
	assert(ret == 0);
	ret = bt_ctf_field_type_set_byte_order(root_a, BT_CTF_BYTE_ORDER_LITTLE_ENDIAN);
	assert(ret == 0);
	ret = bt_ctf_field_type_set_alignment(root_a, 8);
	assert(ret == 0);
	ret = bt_ctf_field_type_structure_add_field(root, root_a, "a");
	assert(ret == 0);
	root_b_elem = bt_ctf_field_type_string_create();
	assert(root_b_elem);
	ret = bt_ctf_field_type_string_set_encoding(root_b_elem, BT_CTF_STRING_ENCODING_UTF8);
	assert(ret == 0);
	root_b = bt_ctf_field_type_sequence_create(root_b_elem, "stream.event.context.lol");
	assert(root_b);
	ret = bt_ctf_field_type_structure_add_field(root, root_b, "b");
	assert(ret == 0);
	root_c = bt_ctf_field_type_string_create();
	assert(root_c);
	ret = bt_ctf_field_type_string_set_encoding(root_c, BT_CTF_STRING_ENCODING_UTF8);
	assert(ret == 0);
	ret = bt_ctf_field_type_structure_add_field(root, root_c, "c");
	assert(ret == 0);

	BT_PUT(root_a);
	BT_PUT(root_b);
	BT_PUT(root_b_elem);
	BT_PUT(root_c);

	return root;
}

static
void test_fail_unavailable_root(void)
{
	struct bt_ctf_field_type *ep;
	struct bt_ctf_event *event;

	ep = test_fail_unavailable_root_get_event_payload();
	assert(ep);
	event = create_event_with_context_and_payload(NULL, ep);
	ok(!event, "Sequence FT with length in unavailable root is invalid");

	BT_PUT(ep);
	BT_PUT(event);
}

static
struct bt_ctf_field_type *test_fail_target_is_root_get_event_payload(void)
{
	/*
	Generated by bt-ctfirtg using the following input:

	class: struct
	fields:
	  a:
	    class: int
	    size: 32
	  b:
	    class: array
	    length: event.fields
	    element-type:
	      class: string
	  c:
	    class: string

	*/

	struct bt_ctf_field_type *root = NULL;
	struct bt_ctf_field_type *root_a = NULL;
	struct bt_ctf_field_type *root_b = NULL;
	struct bt_ctf_field_type *root_b_elem = NULL;
	struct bt_ctf_field_type *root_c = NULL;

	int ret;
	root = bt_ctf_field_type_structure_create();
	assert(root);
	ret = bt_ctf_field_type_set_alignment(root, 8);
	assert(ret == 0);
	root_a = bt_ctf_field_type_integer_create(32);
	assert(root_a);
	ret = bt_ctf_field_type_integer_set_signed(root_a, 0);
	assert(ret == 0);
	ret = bt_ctf_field_type_integer_set_base(root_a, 10);
	assert(ret == 0);
	ret = bt_ctf_field_type_integer_set_encoding(root_a, BT_CTF_STRING_ENCODING_NONE);
	assert(ret == 0);
	ret = bt_ctf_field_type_set_byte_order(root_a, BT_CTF_BYTE_ORDER_LITTLE_ENDIAN);
	assert(ret == 0);
	ret = bt_ctf_field_type_set_alignment(root_a, 8);
	assert(ret == 0);
	ret = bt_ctf_field_type_structure_add_field(root, root_a, "a");
	assert(ret == 0);
	root_b_elem = bt_ctf_field_type_string_create();
	assert(root_b_elem);
	ret = bt_ctf_field_type_string_set_encoding(root_b_elem, BT_CTF_STRING_ENCODING_UTF8);
	assert(ret == 0);
	root_b = bt_ctf_field_type_sequence_create(root_b_elem, "event.fields");
	assert(root_b);
	ret = bt_ctf_field_type_structure_add_field(root, root_b, "b");
	assert(ret == 0);
	root_c = bt_ctf_field_type_string_create();
	assert(root_c);
	ret = bt_ctf_field_type_string_set_encoding(root_c, BT_CTF_STRING_ENCODING_UTF8);
	assert(ret == 0);
	ret = bt_ctf_field_type_structure_add_field(root, root_c, "c");
	assert(ret == 0);

	BT_PUT(root_a);
	BT_PUT(root_b);
	BT_PUT(root_b_elem);
	BT_PUT(root_c);

	return root;
}

static
void test_fail_target_is_root(void)
{
	struct bt_ctf_field_type *ep;
	struct bt_ctf_event *event;

	ep = test_fail_target_is_root_get_event_payload();
	assert(ep);
	event = create_event_with_context_and_payload(NULL, ep);
	ok(!event, "Sequence FT with root as its length is invalid");

	BT_PUT(ep);
	BT_PUT(event);
}

static
struct bt_ctf_field_type *test_fail_target_is_after_source_get_ep(void)
{
	/*
	Generated by bt-ctfirtg using the following input:

	class: struct
	fields:
	  a:
	    class: int
	    size: 32
	  b:
	    class: array
	    length: d
	    element-type:
	      class: string
	  c:
	    class: string
	  d:
	    class: int
	    size: 17

	*/

	struct bt_ctf_field_type *root = NULL;
	struct bt_ctf_field_type *root_a = NULL;
	struct bt_ctf_field_type *root_b = NULL;
	struct bt_ctf_field_type *root_b_elem = NULL;
	struct bt_ctf_field_type *root_c = NULL;
	struct bt_ctf_field_type *root_d = NULL;

	int ret;
	root = bt_ctf_field_type_structure_create();
	assert(root);
	ret = bt_ctf_field_type_set_alignment(root, 8);
	assert(ret == 0);
	root_a = bt_ctf_field_type_integer_create(32);
	assert(root_a);
	ret = bt_ctf_field_type_integer_set_signed(root_a, 0);
	assert(ret == 0);
	ret = bt_ctf_field_type_integer_set_base(root_a, 10);
	assert(ret == 0);
	ret = bt_ctf_field_type_integer_set_encoding(root_a, BT_CTF_STRING_ENCODING_NONE);
	assert(ret == 0);
	ret = bt_ctf_field_type_set_byte_order(root_a, BT_CTF_BYTE_ORDER_LITTLE_ENDIAN);
	assert(ret == 0);
	ret = bt_ctf_field_type_set_alignment(root_a, 8);
	assert(ret == 0);
	ret = bt_ctf_field_type_structure_add_field(root, root_a, "a");
	assert(ret == 0);
	root_b_elem = bt_ctf_field_type_string_create();
	assert(root_b_elem);
	ret = bt_ctf_field_type_string_set_encoding(root_b_elem, BT_CTF_STRING_ENCODING_UTF8);
	assert(ret == 0);
	root_b = bt_ctf_field_type_sequence_create(root_b_elem, "d");
	assert(root_b);
	ret = bt_ctf_field_type_structure_add_field(root, root_b, "b");
	assert(ret == 0);
	root_c = bt_ctf_field_type_string_create();
	assert(root_c);
	ret = bt_ctf_field_type_string_set_encoding(root_c, BT_CTF_STRING_ENCODING_UTF8);
	assert(ret == 0);
	ret = bt_ctf_field_type_structure_add_field(root, root_c, "c");
	assert(ret == 0);
	root_d = bt_ctf_field_type_integer_create(17);
	assert(root_d);
	ret = bt_ctf_field_type_integer_set_signed(root_d, 0);
	assert(ret == 0);
	ret = bt_ctf_field_type_integer_set_base(root_d, 10);
	assert(ret == 0);
	ret = bt_ctf_field_type_integer_set_encoding(root_d, BT_CTF_STRING_ENCODING_NONE);
	assert(ret == 0);
	ret = bt_ctf_field_type_set_byte_order(root_d, BT_CTF_BYTE_ORDER_LITTLE_ENDIAN);
	assert(ret == 0);
	ret = bt_ctf_field_type_set_alignment(root_d, 1);
	assert(ret == 0);
	ret = bt_ctf_field_type_structure_add_field(root, root_d, "d");
	assert(ret == 0);

	BT_PUT(root_a);
	BT_PUT(root_b);
	BT_PUT(root_b_elem);
	BT_PUT(root_c);
	BT_PUT(root_d);

	return root;
}

static
void test_fail_target_is_after_source(void)
{
	struct bt_ctf_field_type *ep;
	struct bt_ctf_event *event;

	ep = test_fail_target_is_after_source_get_ep();
	assert(ep);
	event = create_event_with_context_and_payload(NULL, ep);
	ok(!event, "Sequence FT with length after it is invalid");

	BT_PUT(ep);
	BT_PUT(event);
}

static
struct bt_ctf_field_type *test_fail_target_is_ancestor_of_source_get_ep(void)
{
	/*
	Generated by bt-ctfirtg using the following input:

	class: struct
	fields:
	  a:
	    class: int
	    size: 32
	  z:
	    class: struct
	    fields:
	      b:
	        class: array
	        length: z
	        element-type:
	          class: string
	  c:
	    class: string
	  d:
	    class: int
	    size: 17

	*/

	struct bt_ctf_field_type *root = NULL;
	struct bt_ctf_field_type *root_a = NULL;
	struct bt_ctf_field_type *root_z = NULL;
	struct bt_ctf_field_type *root_z_b = NULL;
	struct bt_ctf_field_type *root_z_b_elem = NULL;
	struct bt_ctf_field_type *root_c = NULL;
	struct bt_ctf_field_type *root_d = NULL;

	int ret;
	root = bt_ctf_field_type_structure_create();
	assert(root);
	ret = bt_ctf_field_type_set_alignment(root, 8);
	assert(ret == 0);
	root_a = bt_ctf_field_type_integer_create(32);
	assert(root_a);
	ret = bt_ctf_field_type_integer_set_signed(root_a, 0);
	assert(ret == 0);
	ret = bt_ctf_field_type_integer_set_base(root_a, 10);
	assert(ret == 0);
	ret = bt_ctf_field_type_integer_set_encoding(root_a, BT_CTF_STRING_ENCODING_NONE);
	assert(ret == 0);
	ret = bt_ctf_field_type_set_byte_order(root_a, BT_CTF_BYTE_ORDER_LITTLE_ENDIAN);
	assert(ret == 0);
	ret = bt_ctf_field_type_set_alignment(root_a, 8);
	assert(ret == 0);
	ret = bt_ctf_field_type_structure_add_field(root, root_a, "a");
	assert(ret == 0);
	root_z = bt_ctf_field_type_structure_create();
	assert(root_z);
	ret = bt_ctf_field_type_set_alignment(root_z, 8);
	assert(ret == 0);
	root_z_b_elem = bt_ctf_field_type_string_create();
	assert(root_z_b_elem);
	ret = bt_ctf_field_type_string_set_encoding(root_z_b_elem, BT_CTF_STRING_ENCODING_UTF8);
	assert(ret == 0);
	root_z_b = bt_ctf_field_type_sequence_create(root_z_b_elem, "z");
	assert(root_z_b);
	ret = bt_ctf_field_type_structure_add_field(root_z, root_z_b, "b");
	assert(ret == 0);
	ret = bt_ctf_field_type_structure_add_field(root, root_z, "z");
	assert(ret == 0);
	root_c = bt_ctf_field_type_string_create();
	assert(root_c);
	ret = bt_ctf_field_type_string_set_encoding(root_c, BT_CTF_STRING_ENCODING_UTF8);
	assert(ret == 0);
	ret = bt_ctf_field_type_structure_add_field(root, root_c, "c");
	assert(ret == 0);
	root_d = bt_ctf_field_type_integer_create(17);
	assert(root_d);
	ret = bt_ctf_field_type_integer_set_signed(root_d, 0);
	assert(ret == 0);
	ret = bt_ctf_field_type_integer_set_base(root_d, 10);
	assert(ret == 0);
	ret = bt_ctf_field_type_integer_set_encoding(root_d, BT_CTF_STRING_ENCODING_NONE);
	assert(ret == 0);
	ret = bt_ctf_field_type_set_byte_order(root_d, BT_CTF_BYTE_ORDER_LITTLE_ENDIAN);
	assert(ret == 0);
	ret = bt_ctf_field_type_set_alignment(root_d, 1);
	assert(ret == 0);
	ret = bt_ctf_field_type_structure_add_field(root, root_d, "d");
	assert(ret == 0);

	BT_PUT(root_a);
	BT_PUT(root_z);
	BT_PUT(root_z_b);
	BT_PUT(root_z_b_elem);
	BT_PUT(root_c);
	BT_PUT(root_d);

	return root;
}

static
void test_fail_target_is_ancestor_of_source(void)
{
	struct bt_ctf_field_type *ep;
	struct bt_ctf_event *event;

	ep = test_fail_target_is_ancestor_of_source_get_ep();
	assert(ep);
	event = create_event_with_context_and_payload(NULL, ep);
	ok(!event, "Sequence FT with ancestor as its length is invalid");

	BT_PUT(ep);
	BT_PUT(event);
}

static
struct bt_ctf_field_type *test_fail_target_is_source_get_event_payload(void)
{
	/*
	Generated by bt-ctfirtg using the following input:

	class: struct
	fields:
	  a:
	    class: int
	    size: 32
	  b:
	    class: array
	    length: event.fields.b
	    element-type:
	      class: string
	  c:
	    class: string
	  d:
	    class: int
	    size: 17

	*/

	struct bt_ctf_field_type *root = NULL;
	struct bt_ctf_field_type *root_a = NULL;
	struct bt_ctf_field_type *root_b = NULL;
	struct bt_ctf_field_type *root_b_elem = NULL;
	struct bt_ctf_field_type *root_c = NULL;
	struct bt_ctf_field_type *root_d = NULL;

	int ret;
	root = bt_ctf_field_type_structure_create();
	assert(root);
	ret = bt_ctf_field_type_set_alignment(root, 8);
	assert(ret == 0);
	root_a = bt_ctf_field_type_integer_create(32);
	assert(root_a);
	ret = bt_ctf_field_type_integer_set_signed(root_a, 0);
	assert(ret == 0);
	ret = bt_ctf_field_type_integer_set_base(root_a, 10);
	assert(ret == 0);
	ret = bt_ctf_field_type_integer_set_encoding(root_a, BT_CTF_STRING_ENCODING_NONE);
	assert(ret == 0);
	ret = bt_ctf_field_type_set_byte_order(root_a, BT_CTF_BYTE_ORDER_LITTLE_ENDIAN);
	assert(ret == 0);
	ret = bt_ctf_field_type_set_alignment(root_a, 8);
	assert(ret == 0);
	ret = bt_ctf_field_type_structure_add_field(root, root_a, "a");
	assert(ret == 0);
	root_b_elem = bt_ctf_field_type_string_create();
	assert(root_b_elem);
	ret = bt_ctf_field_type_string_set_encoding(root_b_elem, BT_CTF_STRING_ENCODING_UTF8);
	assert(ret == 0);
	root_b = bt_ctf_field_type_sequence_create(root_b_elem, "event.fields.b");
	assert(root_b);
	ret = bt_ctf_field_type_structure_add_field(root, root_b, "b");
	assert(ret == 0);
	root_c = bt_ctf_field_type_string_create();
	assert(root_c);
	ret = bt_ctf_field_type_string_set_encoding(root_c, BT_CTF_STRING_ENCODING_UTF8);
	assert(ret == 0);
	ret = bt_ctf_field_type_structure_add_field(root, root_c, "c");
	assert(ret == 0);
	root_d = bt_ctf_field_type_integer_create(17);
	assert(root_d);
	ret = bt_ctf_field_type_integer_set_signed(root_d, 0);
	assert(ret == 0);
	ret = bt_ctf_field_type_integer_set_base(root_d, 10);
	assert(ret == 0);
	ret = bt_ctf_field_type_integer_set_encoding(root_d, BT_CTF_STRING_ENCODING_NONE);
	assert(ret == 0);
	ret = bt_ctf_field_type_set_byte_order(root_d, BT_CTF_BYTE_ORDER_LITTLE_ENDIAN);
	assert(ret == 0);
	ret = bt_ctf_field_type_set_alignment(root_d, 1);
	assert(ret == 0);
	ret = bt_ctf_field_type_structure_add_field(root, root_d, "d");
	assert(ret == 0);

	BT_PUT(root_a);
	BT_PUT(root_b);
	BT_PUT(root_b_elem);
	BT_PUT(root_c);
	BT_PUT(root_d);

	return root;
}

static
void test_fail_target_is_source(void)
{
	struct bt_ctf_field_type *ep;
	struct bt_ctf_event *event;

	ep = test_fail_target_is_source_get_event_payload();
	assert(ep);
	event = create_event_with_context_and_payload(NULL, ep);
	ok(!event, "Sequence FT with itself as its length is invalid");

	BT_PUT(ep);
	BT_PUT(event);
}

static
struct bt_ctf_field_type *test_fail_variant_tag_is_not_enum_get_ep(void)
{
	/*
	Generated by bt-ctfirtg using the following input:

	class: struct
	fields:
	  a:
	    class: int
	    size: 32
	  b:
	    class: variant
	    tag: a
	    types:
	      HELLO:
	        class: string
	  c:
	    class: string
	  d:
	    class: int
	    size: 17

	*/

	struct bt_ctf_field_type *root = NULL;
	struct bt_ctf_field_type *root_a = NULL;
	struct bt_ctf_field_type *root_b = NULL;
	struct bt_ctf_field_type *root_b_HELLO = NULL;
	struct bt_ctf_field_type *root_c = NULL;
	struct bt_ctf_field_type *root_d = NULL;

	int ret;
	root = bt_ctf_field_type_structure_create();
	assert(root);
	ret = bt_ctf_field_type_set_alignment(root, 8);
	assert(ret == 0);
	root_a = bt_ctf_field_type_integer_create(32);
	assert(root_a);
	ret = bt_ctf_field_type_integer_set_signed(root_a, 0);
	assert(ret == 0);
	ret = bt_ctf_field_type_integer_set_base(root_a, 10);
	assert(ret == 0);
	ret = bt_ctf_field_type_integer_set_encoding(root_a, BT_CTF_STRING_ENCODING_NONE);
	assert(ret == 0);
	ret = bt_ctf_field_type_set_byte_order(root_a, BT_CTF_BYTE_ORDER_LITTLE_ENDIAN);
	assert(ret == 0);
	ret = bt_ctf_field_type_set_alignment(root_a, 8);
	assert(ret == 0);
	ret = bt_ctf_field_type_structure_add_field(root, root_a, "a");
	assert(ret == 0);
	root_b = bt_ctf_field_type_variant_create(NULL, "a");
	assert(root_b);
	root_b_HELLO = bt_ctf_field_type_string_create();
	assert(root_b_HELLO);
	ret = bt_ctf_field_type_string_set_encoding(root_b_HELLO, BT_CTF_STRING_ENCODING_UTF8);
	assert(ret == 0);
	ret = bt_ctf_field_type_variant_add_field(root_b, root_b_HELLO, "HELLO");
	assert(ret == 0);
	ret = bt_ctf_field_type_structure_add_field(root, root_b, "b");
	assert(ret == 0);
	root_c = bt_ctf_field_type_string_create();
	assert(root_c);
	ret = bt_ctf_field_type_string_set_encoding(root_c, BT_CTF_STRING_ENCODING_UTF8);
	assert(ret == 0);
	ret = bt_ctf_field_type_structure_add_field(root, root_c, "c");
	assert(ret == 0);
	root_d = bt_ctf_field_type_integer_create(17);
	assert(root_d);
	ret = bt_ctf_field_type_integer_set_signed(root_d, 0);
	assert(ret == 0);
	ret = bt_ctf_field_type_integer_set_base(root_d, 10);
	assert(ret == 0);
	ret = bt_ctf_field_type_integer_set_encoding(root_d, BT_CTF_STRING_ENCODING_NONE);
	assert(ret == 0);
	ret = bt_ctf_field_type_set_byte_order(root_d, BT_CTF_BYTE_ORDER_LITTLE_ENDIAN);
	assert(ret == 0);
	ret = bt_ctf_field_type_set_alignment(root_d, 1);
	assert(ret == 0);
	ret = bt_ctf_field_type_structure_add_field(root, root_d, "d");
	assert(ret == 0);

	BT_PUT(root_a);
	BT_PUT(root_b);
	BT_PUT(root_b_HELLO);
	BT_PUT(root_c);
	BT_PUT(root_d);

	return root;
}

static
void test_fail_variant_tag_is_not_enum(void)
{
	struct bt_ctf_field_type *ep;
	struct bt_ctf_event *event;

	ep = test_fail_variant_tag_is_not_enum_get_ep();
	assert(ep);
	event = create_event_with_context_and_payload(NULL, ep);
	ok(!event, "Variant FT with non-enum FT as its tag FT is invalid");

	BT_PUT(ep);
	BT_PUT(event);
}

static
struct bt_ctf_field_type *test_fail_variant_tag_mismatch_mappings_get_ep(void)
{
	/*
	Generated by bt-ctfirtg using the following input:

	class: struct
	fields:
	  a:
	    class: enum
	    value-type:
	      class: int
	      size: 16
	    members:
	      - GLASS
	      - OF
	      - WATER
	  b:
	    class: variant
	    tag: a
	    types:
	      GLASS:
	        class: string
	      OF:
	        class: int
	        size: 2
	  c:
	    class: string

	*/

	struct bt_ctf_field_type *root = NULL;
	struct bt_ctf_field_type *root_a = NULL;
	struct bt_ctf_field_type *root_a_int = NULL;
	struct bt_ctf_field_type *root_b = NULL;
	struct bt_ctf_field_type *root_b_GLASS = NULL;
	struct bt_ctf_field_type *root_b_OF = NULL;
	struct bt_ctf_field_type *root_c = NULL;

	int ret;
	root = bt_ctf_field_type_structure_create();
	assert(root);
	ret = bt_ctf_field_type_set_alignment(root, 8);
	assert(ret == 0);
	root_a_int = bt_ctf_field_type_integer_create(16);
	assert(root_a_int);
	ret = bt_ctf_field_type_integer_set_signed(root_a_int, 0);
	assert(ret == 0);
	ret = bt_ctf_field_type_integer_set_base(root_a_int, 10);
	assert(ret == 0);
	ret = bt_ctf_field_type_integer_set_encoding(root_a_int, BT_CTF_STRING_ENCODING_NONE);
	assert(ret == 0);
	ret = bt_ctf_field_type_set_byte_order(root_a_int, BT_CTF_BYTE_ORDER_LITTLE_ENDIAN);
	assert(ret == 0);
	ret = bt_ctf_field_type_set_alignment(root_a_int, 8);
	assert(ret == 0);
	root_a = bt_ctf_field_type_enumeration_create(root_a_int);
	assert(root_a);
	ret = bt_ctf_field_type_enumeration_add_mapping(root_a, "GLASS", 0, 0);
	assert(ret == 0);
	ret = bt_ctf_field_type_enumeration_add_mapping(root_a, "OF", 1, 1);
	assert(ret == 0);
	ret = bt_ctf_field_type_enumeration_add_mapping(root_a, "WATER", 2, 2);
	assert(ret == 0);
	ret = bt_ctf_field_type_structure_add_field(root, root_a, "a");
	assert(ret == 0);
	root_b = bt_ctf_field_type_variant_create(NULL, "a");
	assert(root_b);
	root_b_GLASS = bt_ctf_field_type_string_create();
	assert(root_b_GLASS);
	ret = bt_ctf_field_type_string_set_encoding(root_b_GLASS, BT_CTF_STRING_ENCODING_UTF8);
	assert(ret == 0);
	ret = bt_ctf_field_type_variant_add_field(root_b, root_b_GLASS, "GLASS");
	assert(ret == 0);
	root_b_OF = bt_ctf_field_type_integer_create(2);
	assert(root_b_OF);
	ret = bt_ctf_field_type_integer_set_signed(root_b_OF, 0);
	assert(ret == 0);
	ret = bt_ctf_field_type_integer_set_base(root_b_OF, 10);
	assert(ret == 0);
	ret = bt_ctf_field_type_integer_set_encoding(root_b_OF, BT_CTF_STRING_ENCODING_NONE);
	assert(ret == 0);
	ret = bt_ctf_field_type_set_byte_order(root_b_OF, BT_CTF_BYTE_ORDER_LITTLE_ENDIAN);
	assert(ret == 0);
	ret = bt_ctf_field_type_set_alignment(root_b_OF, 1);
	assert(ret == 0);
	ret = bt_ctf_field_type_variant_add_field(root_b, root_b_OF, "OF");
	assert(ret == 0);
	ret = bt_ctf_field_type_structure_add_field(root, root_b, "b");
	assert(ret == 0);
	root_c = bt_ctf_field_type_string_create();
	assert(root_c);
	ret = bt_ctf_field_type_string_set_encoding(root_c, BT_CTF_STRING_ENCODING_UTF8);
	assert(ret == 0);
	ret = bt_ctf_field_type_structure_add_field(root, root_c, "c");
	assert(ret == 0);

	BT_PUT(root_a);
	BT_PUT(root_a_int);
	BT_PUT(root_b);
	BT_PUT(root_b_GLASS);
	BT_PUT(root_b_OF);
	BT_PUT(root_c);

	return root;
}

static
void test_fail_variant_tag_mismatch_mappings(void)
{
	struct bt_ctf_field_type *ep;
	struct bt_ctf_event *event;

	ep = test_fail_variant_tag_mismatch_mappings_get_ep();
	assert(ep);
	event = create_event_with_context_and_payload(NULL, ep);
	ok(!event, "Variant FT with mismatching tag FT is invalid");

	BT_PUT(ep);
	BT_PUT(event);
}

static
struct bt_ctf_field_type *test_fail_sequence_tag_is_not_int_get_ep(void)
{
	/*
	Generated by bt-ctfirtg using the following input:

	class: struct
	fields:
	  a:
	    class: string
	  b:
	    class: array
	    length: a
	    element-type:
	      class: string
	  c:
	    class: string

	*/

	struct bt_ctf_field_type *root = NULL;
	struct bt_ctf_field_type *root_a = NULL;
	struct bt_ctf_field_type *root_b = NULL;
	struct bt_ctf_field_type *root_b_elem = NULL;
	struct bt_ctf_field_type *root_c = NULL;

	int ret;
	root = bt_ctf_field_type_structure_create();
	assert(root);
	ret = bt_ctf_field_type_set_alignment(root, 8);
	assert(ret == 0);
	root_a = bt_ctf_field_type_string_create();
	assert(root_a);
	ret = bt_ctf_field_type_string_set_encoding(root_a, BT_CTF_STRING_ENCODING_UTF8);
	assert(ret == 0);
	ret = bt_ctf_field_type_structure_add_field(root, root_a, "a");
	assert(ret == 0);
	root_b_elem = bt_ctf_field_type_string_create();
	assert(root_b_elem);
	ret = bt_ctf_field_type_string_set_encoding(root_b_elem, BT_CTF_STRING_ENCODING_UTF8);
	assert(ret == 0);
	root_b = bt_ctf_field_type_sequence_create(root_b_elem, "a");
	assert(root_b);
	ret = bt_ctf_field_type_structure_add_field(root, root_b, "b");
	assert(ret == 0);
	root_c = bt_ctf_field_type_string_create();
	assert(root_c);
	ret = bt_ctf_field_type_string_set_encoding(root_c, BT_CTF_STRING_ENCODING_UTF8);
	assert(ret == 0);
	ret = bt_ctf_field_type_structure_add_field(root, root_c, "c");
	assert(ret == 0);

	BT_PUT(root_a);
	BT_PUT(root_b);
	BT_PUT(root_b_elem);
	BT_PUT(root_c);

	return root;
}

static
void test_fail_sequence_tag_is_not_int(void)
{
	struct bt_ctf_field_type *ep;
	struct bt_ctf_event *event;

	ep = test_fail_sequence_tag_is_not_int_get_ep();
	assert(ep);
	event = create_event_with_context_and_payload(NULL, ep);
	ok(!event, "Sequence FT with non-enum length FT is invalid");

	BT_PUT(ep);
	BT_PUT(event);
}

static
void test_fail(void)
{
	test_fail_unavailable_root();
	test_fail_target_is_root();
	test_fail_target_is_after_source();
	test_fail_target_is_ancestor_of_source();
	test_fail_target_is_source();
	test_fail_variant_tag_is_not_enum();
	test_fail_variant_tag_mismatch_mappings();
	test_fail_sequence_tag_is_not_int();
}

int main(void)
{
	plan_no_plan();

	test_pass();
	test_fail();

	return 0;
}
