#!/bin/sh

check_coverage() {
	coverage run $@
}

PYTHON_BUILD_DIR="/home/jgalar/EfficiOS/src/babeltrace/bindings/python"
BT2_NATIVE_LIBS_DIR="/home/jgalar/EfficiOS/src/babeltrace/bindings/python/bt2/.libs"
TESTS_UTILS_PYTHON_DIR="/home/jgalar/EfficiOS/src/babeltrace/tests/utils/python"
TESTRUNNER_PY="/home/jgalar/EfficiOS/src/babeltrace/tests/utils/python/testrunner.py"
THIS_DIR="/home/jgalar/EfficiOS/src/babeltrace/tests/bindings/python/bt2"

if test "x$TESTALL_COVERAGE" = "x1"; then
	EXEC=check_coverage
else
	EXEC=""

fi

PYTHONPATH="$PYTHON_BUILD_DIR:$BT2_NATIVE_LIBS_DIR:$TESTS_UTILS_PYTHON_DIR" \
	"$EXEC" "$TESTRUNNER_PY" "$THIS_DIR"
res=$?

if test "x$TESTALL_COVERAGE_REPORT" = "x1"; then
	coverage report -m
fi

if test "x$TESTALL_COVERAGE_HTML" = "x1"; then
	coverage html
fi

exit $res
