
/* A Bison parser, made by GNU Bison 2.4.1.  */

/* Skeleton implementation for Bison's Yacc-like parsers in C
   
      Copyright (C) 1984, 1989, 1990, 2000, 2001, 2002, 2003, 2004, 2005, 2006
   Free Software Foundation, Inc.
   
   This program is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.
   
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
   
   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <http://www.gnu.org/licenses/>.  */

/* As a special exception, you may create a larger work that contains
   part or all of the Bison parser skeleton and distribute that work
   under terms of your choice, so long as that work isn't itself a
   parser generator using the skeleton or a modified version thereof
   as a parser skeleton.  Alternatively, if you modify or redistribute
   the parser skeleton itself, you may (at your option) remove this
   special exception, which will cause the skeleton and the resulting
   Bison output files to be licensed under the GNU General Public
   License without this special exception.
   
   This special exception was added by the Free Software Foundation in
   version 2.2 of Bison.  */

/* C LALR(1) parser skeleton written by Richard Stallman, by
   simplifying the original so-called "semantic" parser.  */

/* All symbols defined below should begin with yy or YY, to avoid
   infringing on user name space.  This should be done even for local
   variables, as they might otherwise be expanded by user macros.
   There are some unavoidable exceptions within include files to
   define necessary library symbols; they are noted "INFRINGES ON
   USER NAME SPACE" below.  */

/* Identify Bison output.  */
#define YYBISON 1

/* Bison version.  */
#define YYBISON_VERSION "2.4.1"

/* Skeleton name.  */
#define YYSKELETON_NAME "yacc.c"

/* Pure parsers.  */
#define YYPURE 1

/* Push parsers.  */
#define YYPUSH 0

/* Pull parsers.  */
#define YYPULL 1

/* Using locations.  */
#define YYLSP_NEEDED 0



/* Copy the first part of user declarations.  */

/* Line 189 of yacc.c  */
#line 1 "ctf-parser.y"

/*
 * ctf-parser.y
 *
 * Common Trace Format Metadata Grammar.
 *
 * Copyright 2010 - Mathieu Desnoyers <mathieu.desnoyers@efficios.com>
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 */

#include <stdio.h>
#include <unistd.h>
#include <string.h>
#include <stdlib.h>
#include <assert.h>
#include <glib.h>
#include <errno.h>
#include <inttypes.h>
#include <babeltrace/list.h>
#include <babeltrace/babeltrace-internal.h>
#include "ctf-scanner.h"
#include "ctf-parser.h"
#include "ctf-ast.h"

int yydebug;

/* Join two lists, put "add" at the end of "head".  */
static inline void
_cds_list_splice_tail (struct cds_list_head *add, struct cds_list_head *head)
{
	/* Do nothing if the list which gets added is empty.  */
	if (add != add->next) {
		add->next->prev = head->prev;
		add->prev->next = head;
		head->prev->next = add->next;
		head->prev = add->prev;
	}
}

int yyparse(struct ctf_scanner *scanner);
int yylex(union YYSTYPE *yyval, struct ctf_scanner *scanner);
int yylex_init_extra(struct ctf_scanner *scanner, yyscan_t * ptr_yy_globals);
int yylex_destroy(yyscan_t yyscanner);
void yyrestart(FILE * in_str, yyscan_t scanner);

int yydebug;

struct gc_string {
	struct cds_list_head gc;
	size_t alloclen;
	char s[];
};

static const char *node_type_to_str[] = {
	[ NODE_UNKNOWN ] = "NODE_UNKNOWN",
	[ NODE_ROOT ] = "NODE_ROOT",
	[ NODE_EVENT ] = "NODE_EVENT",
	[ NODE_STREAM ] = "NODE_STREAM",
	[ NODE_TRACE ] = "NODE_TRACE",
	[ NODE_CTF_EXPRESSION ] = "NODE_CTF_EXPRESSION",
	[ NODE_UNARY_EXPRESSION ] = "NODE_UNARY_EXPRESSION",
	[ NODE_TYPEDEF ] = "NODE_TYPEDEF",
	[ NODE_TYPEALIAS_TARGET ] = "NODE_TYPEALIAS_TARGET",
	[ NODE_TYPEALIAS_ALIAS ] = "NODE_TYPEALIAS_ALIAS",
	[ NODE_TYPEALIAS ] = "NODE_TYPEALIAS",
	[ NODE_TYPE_SPECIFIER ] = "NODE_TYPE_SPECIFIER",
	[ NODE_TYPE_SPECIFIER_LIST ] = "NODE_TYPE_SPECIFIER_LIST",
	[ NODE_POINTER ] = "NODE_POINTER",
	[ NODE_TYPE_DECLARATOR ] = "NODE_TYPE_DECLARATOR",
	[ NODE_FLOATING_POINT ] = "NODE_FLOATING_POINT",
	[ NODE_INTEGER ] = "NODE_INTEGER",
	[ NODE_STRING ] = "NODE_STRING",
	[ NODE_ENUMERATOR ] = "NODE_ENUMERATOR",
	[ NODE_ENUM ] = "NODE_ENUM",
	[ NODE_STRUCT_OR_VARIANT_DECLARATION ] = "NODE_STRUCT_OR_VARIANT_DECLARATION",
	[ NODE_VARIANT ] = "NODE_VARIANT",
	[ NODE_STRUCT ] = "NODE_STRUCT",
};

const char *node_type(struct ctf_node *node)
{
	if (node->type < NR_NODE_TYPES)
		return node_type_to_str[node->type];
	else
		return NULL;
}

static struct gc_string *gc_string_alloc(struct ctf_scanner *scanner,
					 size_t len)
{
	struct gc_string *gstr;
	size_t alloclen;

	/* TODO: could be faster with find first bit or glib Gstring */
	/* sizeof long to account for malloc header (int or long ?) */
	for (alloclen = 8; alloclen < sizeof(long) + sizeof(*gstr) + len;
	     alloclen *= 2);

	gstr = malloc(alloclen);
	cds_list_add(&gstr->gc, &scanner->allocated_strings);
	gstr->alloclen = alloclen;
	return gstr;
}

/*
 * note: never use gc_string_append on a string that has external references.
 * gsrc will be garbage collected immediately, and gstr might be.
 * Should only be used to append characters to a string literal or constant.
 */
struct gc_string *gc_string_append(struct ctf_scanner *scanner,
				   struct gc_string *gstr,
				   struct gc_string *gsrc)
{
	size_t newlen = strlen(gsrc->s) + strlen(gstr->s) + 1;
	size_t alloclen;

	/* TODO: could be faster with find first bit or glib Gstring */
	/* sizeof long to account for malloc header (int or long ?) */
	for (alloclen = 8; alloclen < sizeof(long) + sizeof(*gstr) + newlen;
	     alloclen *= 2);

	if (alloclen > gstr->alloclen) {
		struct gc_string *newgstr;

		newgstr = gc_string_alloc(scanner, newlen);
		strcpy(newgstr->s, gstr->s);
		strcat(newgstr->s, gsrc->s);
		cds_list_del(&gstr->gc);
		free(gstr);
		gstr = newgstr;
	} else {
		strcat(gstr->s, gsrc->s);
	}
	cds_list_del(&gsrc->gc);
	free(gsrc);
	return gstr;
}

void setstring(struct ctf_scanner *scanner, YYSTYPE *lvalp, const char *src)
{
	lvalp->gs = gc_string_alloc(scanner, strlen(src) + 1);
	strcpy(lvalp->gs->s, src);
}

static void init_scope(struct ctf_scanner_scope *scope,
		       struct ctf_scanner_scope *parent)
{
	scope->parent = parent;
	scope->types = g_hash_table_new_full(g_str_hash, g_str_equal,
					     NULL, NULL);
}

static void finalize_scope(struct ctf_scanner_scope *scope)
{
	g_hash_table_destroy(scope->types);
}

static void push_scope(struct ctf_scanner *scanner)
{
	struct ctf_scanner_scope *ns;

	printf_debug("push scope\n");
	ns = malloc(sizeof(struct ctf_scanner_scope));
	init_scope(ns, scanner->cs);
	scanner->cs = ns;
}

static void pop_scope(struct ctf_scanner *scanner)
{
	struct ctf_scanner_scope *os;

	printf_debug("pop scope\n");
	os = scanner->cs;
	scanner->cs = os->parent;
	finalize_scope(os);
	free(os);
}

static int lookup_type(struct ctf_scanner_scope *s, const char *id)
{
	int ret;

	ret = (int) (long) g_hash_table_lookup(s->types, id);
	printf_debug("lookup %p %s %d\n", s, id, ret);
	return ret;
}

int is_type(struct ctf_scanner *scanner, const char *id)
{
	struct ctf_scanner_scope *it;
	int ret = 0;

	for (it = scanner->cs; it != NULL; it = it->parent) {
		if (lookup_type(it, id)) {
			ret = 1;
			break;
		}
	}
	printf_debug("is type %s %d\n", id, ret);
	return ret;
}

static void add_type(struct ctf_scanner *scanner, struct gc_string *id)
{
	printf_debug("add type %s\n", id->s);
	if (lookup_type(scanner->cs, id->s))
		return;
	g_hash_table_insert(scanner->cs->types, id->s, id->s);
}

static struct ctf_node *make_node(struct ctf_scanner *scanner,
				  enum node_type type)
{
	struct ctf_ast *ast = ctf_scanner_get_ast(scanner);
	struct ctf_node *node;

	node = malloc(sizeof(*node));
	if (!node)
		return NULL;
	memset(node, 0, sizeof(*node));
	node->type = type;
	CDS_INIT_LIST_HEAD(&node->tmp_head);
	cds_list_add(&node->gc, &ast->allocated_nodes);
	cds_list_add(&node->siblings, &node->tmp_head);

	switch (type) {
	case NODE_ROOT:
		fprintf(stderr, "[error] %s: trying to create root node\n", __func__);
		break;

	case NODE_EVENT:
		CDS_INIT_LIST_HEAD(&node->u.event.declaration_list);
		break;
	case NODE_STREAM:
		CDS_INIT_LIST_HEAD(&node->u.stream.declaration_list);
		break;
	case NODE_TRACE:
		CDS_INIT_LIST_HEAD(&node->u.trace.declaration_list);
		break;

	case NODE_CTF_EXPRESSION:
		CDS_INIT_LIST_HEAD(&node->u.ctf_expression.left);
		CDS_INIT_LIST_HEAD(&node->u.ctf_expression.right);
		break;
	case NODE_UNARY_EXPRESSION:
		break;

	case NODE_TYPEDEF:
		CDS_INIT_LIST_HEAD(&node->u._typedef.type_declarators);
		break;
	case NODE_TYPEALIAS_TARGET:
		CDS_INIT_LIST_HEAD(&node->u.typealias_target.type_declarators);
		break;
	case NODE_TYPEALIAS_ALIAS:
		CDS_INIT_LIST_HEAD(&node->u.typealias_alias.type_declarators);
		break;
	case NODE_TYPEALIAS:
		break;

	case NODE_TYPE_SPECIFIER:
		break;
	case NODE_TYPE_SPECIFIER_LIST:
		CDS_INIT_LIST_HEAD(&node->u.type_specifier_list.head);
		break;
	case NODE_POINTER:
		break;
	case NODE_TYPE_DECLARATOR:
		CDS_INIT_LIST_HEAD(&node->u.type_declarator.pointers);
		break;

	case NODE_FLOATING_POINT:
		CDS_INIT_LIST_HEAD(&node->u.floating_point.expressions);
		break;
	case NODE_INTEGER:
		CDS_INIT_LIST_HEAD(&node->u.integer.expressions);
		break;
	case NODE_STRING:
		CDS_INIT_LIST_HEAD(&node->u.string.expressions);
		break;
	case NODE_ENUMERATOR:
		CDS_INIT_LIST_HEAD(&node->u.enumerator.values);
		break;
	case NODE_ENUM:
		CDS_INIT_LIST_HEAD(&node->u._enum.enumerator_list);
		break;
	case NODE_STRUCT_OR_VARIANT_DECLARATION:
		CDS_INIT_LIST_HEAD(&node->u.struct_or_variant_declaration.type_declarators);
		break;
	case NODE_VARIANT:
		CDS_INIT_LIST_HEAD(&node->u.variant.declaration_list);
		break;
	case NODE_STRUCT:
		CDS_INIT_LIST_HEAD(&node->u._struct.declaration_list);
		CDS_INIT_LIST_HEAD(&node->u._struct.min_align);
		break;

	case NODE_UNKNOWN:
	default:
		fprintf(stderr, "[error] %s: unknown node type %d\n", __func__,
			(int) type);
		break;
	}

	return node;
}

static int reparent_ctf_expression(struct ctf_node *node,
				   struct ctf_node *parent)
{
	switch (parent->type) {
	case NODE_EVENT:
		_cds_list_splice_tail(&node->tmp_head, &parent->u.event.declaration_list);
		break;
	case NODE_STREAM:
		_cds_list_splice_tail(&node->tmp_head, &parent->u.stream.declaration_list);
		break;
	case NODE_TRACE:
		_cds_list_splice_tail(&node->tmp_head, &parent->u.trace.declaration_list);
		break;
	case NODE_FLOATING_POINT:
		_cds_list_splice_tail(&node->tmp_head, &parent->u.floating_point.expressions);
		break;
	case NODE_INTEGER:
		_cds_list_splice_tail(&node->tmp_head, &parent->u.integer.expressions);
		break;
	case NODE_STRING:
		_cds_list_splice_tail(&node->tmp_head, &parent->u.string.expressions);
		break;

	case NODE_ROOT:
	case NODE_CTF_EXPRESSION:
	case NODE_TYPEDEF:
	case NODE_TYPEALIAS_TARGET:
	case NODE_TYPEALIAS_ALIAS:
	case NODE_TYPEALIAS:
	case NODE_TYPE_SPECIFIER:
	case NODE_TYPE_SPECIFIER_LIST:
	case NODE_POINTER:
	case NODE_TYPE_DECLARATOR:
	case NODE_ENUMERATOR:
	case NODE_ENUM:
	case NODE_STRUCT_OR_VARIANT_DECLARATION:
	case NODE_VARIANT:
	case NODE_STRUCT:
	case NODE_UNARY_EXPRESSION:
		return -EPERM;

	case NODE_UNKNOWN:
	default:
		fprintf(stderr, "[error] %s: unknown node type %d\n", __func__,
			(int) parent->type);
		return -EINVAL;
	}
	return 0;
}

static int reparent_typedef(struct ctf_node *node, struct ctf_node *parent)
{
	switch (parent->type) {
	case NODE_ROOT:
		_cds_list_splice_tail(&node->tmp_head, &parent->u.root.declaration_list);
		break;
	case NODE_EVENT:
		_cds_list_splice_tail(&node->tmp_head, &parent->u.event.declaration_list);
		break;
	case NODE_STREAM:
		_cds_list_splice_tail(&node->tmp_head, &parent->u.stream.declaration_list);
		break;
	case NODE_TRACE:
		_cds_list_splice_tail(&node->tmp_head, &parent->u.trace.declaration_list);
		break;
	case NODE_VARIANT:
		_cds_list_splice_tail(&node->tmp_head, &parent->u.variant.declaration_list);
		break;
	case NODE_STRUCT:
		_cds_list_splice_tail(&node->tmp_head, &parent->u._struct.declaration_list);
		break;

	case NODE_FLOATING_POINT:
	case NODE_INTEGER:
	case NODE_STRING:
	case NODE_CTF_EXPRESSION:
	case NODE_TYPEDEF:
	case NODE_TYPEALIAS_TARGET:
	case NODE_TYPEALIAS_ALIAS:
	case NODE_TYPEALIAS:
	case NODE_TYPE_SPECIFIER:
	case NODE_TYPE_SPECIFIER_LIST:
	case NODE_POINTER:
	case NODE_TYPE_DECLARATOR:
	case NODE_ENUMERATOR:
	case NODE_ENUM:
	case NODE_STRUCT_OR_VARIANT_DECLARATION:
	case NODE_UNARY_EXPRESSION:
		return -EPERM;

	case NODE_UNKNOWN:
	default:
		fprintf(stderr, "[error] %s: unknown node type %d\n", __func__,
			(int) parent->type);
		return -EINVAL;
	}
	return 0;
}

static int reparent_typealias(struct ctf_node *node, struct ctf_node *parent)
{
	switch (parent->type) {
	case NODE_ROOT:
		_cds_list_splice_tail(&node->tmp_head, &parent->u.root.declaration_list);
		break;
	case NODE_EVENT:
		_cds_list_splice_tail(&node->tmp_head, &parent->u.event.declaration_list);
		break;
	case NODE_STREAM:
		_cds_list_splice_tail(&node->tmp_head, &parent->u.stream.declaration_list);
		break;
	case NODE_TRACE:
		_cds_list_splice_tail(&node->tmp_head, &parent->u.trace.declaration_list);
		break;
	case NODE_VARIANT:
		_cds_list_splice_tail(&node->tmp_head, &parent->u.variant.declaration_list);
		break;
	case NODE_STRUCT:
		_cds_list_splice_tail(&node->tmp_head, &parent->u._struct.declaration_list);
		break;

	case NODE_FLOATING_POINT:
	case NODE_INTEGER:
	case NODE_STRING:
	case NODE_CTF_EXPRESSION:
	case NODE_TYPEDEF:
	case NODE_TYPEALIAS_TARGET:
	case NODE_TYPEALIAS_ALIAS:
	case NODE_TYPEALIAS:
	case NODE_TYPE_SPECIFIER:
	case NODE_TYPE_SPECIFIER_LIST:
	case NODE_POINTER:
	case NODE_TYPE_DECLARATOR:
	case NODE_ENUMERATOR:
	case NODE_ENUM:
	case NODE_STRUCT_OR_VARIANT_DECLARATION:
	case NODE_UNARY_EXPRESSION:
		return -EPERM;

	case NODE_UNKNOWN:
	default:
		fprintf(stderr, "[error] %s: unknown node type %d\n", __func__,
			(int) parent->type);
		return -EINVAL;
	}
	return 0;
}

static int reparent_type_specifier(struct ctf_node *node,
				   struct ctf_node *parent)
{
	switch (parent->type) {
	case NODE_TYPE_SPECIFIER_LIST:
		_cds_list_splice_tail(&node->tmp_head, &parent->u.type_specifier_list.head);
		break;

	case NODE_TYPE_SPECIFIER:
	case NODE_EVENT:
	case NODE_STREAM:
	case NODE_TRACE:
	case NODE_VARIANT:
	case NODE_STRUCT:
	case NODE_TYPEDEF:
	case NODE_TYPEALIAS_TARGET:
	case NODE_TYPEALIAS_ALIAS:
	case NODE_TYPE_DECLARATOR:
	case NODE_ENUM:
	case NODE_STRUCT_OR_VARIANT_DECLARATION:
	case NODE_TYPEALIAS:
	case NODE_FLOATING_POINT:
	case NODE_INTEGER:
	case NODE_STRING:
	case NODE_CTF_EXPRESSION:
	case NODE_POINTER:
	case NODE_ENUMERATOR:
	case NODE_UNARY_EXPRESSION:
		return -EPERM;

	case NODE_UNKNOWN:
	default:
		fprintf(stderr, "[error] %s: unknown node type %d\n", __func__,
			(int) parent->type);
		return -EINVAL;
	}
	return 0;
}

static int reparent_type_specifier_list(struct ctf_node *node,
					struct ctf_node *parent)
{
	switch (parent->type) {
	case NODE_ROOT:
		cds_list_add_tail(&node->siblings, &parent->u.root.declaration_list);
		break;
	case NODE_EVENT:
		cds_list_add_tail(&node->siblings, &parent->u.event.declaration_list);
		break;
	case NODE_STREAM:
		cds_list_add_tail(&node->siblings, &parent->u.stream.declaration_list);
		break;
	case NODE_TRACE:
		cds_list_add_tail(&node->siblings, &parent->u.trace.declaration_list);
		break;
	case NODE_VARIANT:
		cds_list_add_tail(&node->siblings, &parent->u.variant.declaration_list);
		break;
	case NODE_STRUCT:
		cds_list_add_tail(&node->siblings, &parent->u._struct.declaration_list);
		break;
	case NODE_TYPEDEF:
		parent->u._typedef.type_specifier_list = node;
		break;
	case NODE_TYPEALIAS_TARGET:
		parent->u.typealias_target.type_specifier_list = node;
		break;
	case NODE_TYPEALIAS_ALIAS:
		parent->u.typealias_alias.type_specifier_list = node;
		break;
	case NODE_ENUM:
		parent->u._enum.container_type = node;
		break;
	case NODE_STRUCT_OR_VARIANT_DECLARATION:
		parent->u.struct_or_variant_declaration.type_specifier_list = node;
		break;
	case NODE_TYPE_DECLARATOR:
	case NODE_TYPE_SPECIFIER:
	case NODE_TYPEALIAS:
	case NODE_FLOATING_POINT:
	case NODE_INTEGER:
	case NODE_STRING:
	case NODE_CTF_EXPRESSION:
	case NODE_POINTER:
	case NODE_ENUMERATOR:
	case NODE_UNARY_EXPRESSION:
		return -EPERM;

	case NODE_UNKNOWN:
	default:
		fprintf(stderr, "[error] %s: unknown node type %d\n", __func__,
			(int) parent->type);
		return -EINVAL;
	}
	return 0;
}

static int reparent_type_declarator(struct ctf_node *node,
				    struct ctf_node *parent)
{
	switch (parent->type) {
	case NODE_TYPE_DECLARATOR:
		parent->u.type_declarator.type = TYPEDEC_NESTED;
		parent->u.type_declarator.u.nested.type_declarator = node;
		break;
	case NODE_STRUCT_OR_VARIANT_DECLARATION:
		_cds_list_splice_tail(&node->tmp_head, &parent->u.struct_or_variant_declaration.type_declarators);
		break;
	case NODE_TYPEDEF:
		_cds_list_splice_tail(&node->tmp_head, &parent->u._typedef.type_declarators);
		break;
	case NODE_TYPEALIAS_TARGET:
		_cds_list_splice_tail(&node->tmp_head, &parent->u.typealias_target.type_declarators);
		break;
	case NODE_TYPEALIAS_ALIAS:
		_cds_list_splice_tail(&node->tmp_head, &parent->u.typealias_alias.type_declarators);
		break;

	case NODE_ROOT:
	case NODE_EVENT:
	case NODE_STREAM:
	case NODE_TRACE:
	case NODE_VARIANT:
	case NODE_STRUCT:
	case NODE_TYPEALIAS:
	case NODE_ENUM:
	case NODE_FLOATING_POINT:
	case NODE_INTEGER:
	case NODE_STRING:
	case NODE_CTF_EXPRESSION:
	case NODE_TYPE_SPECIFIER:
	case NODE_TYPE_SPECIFIER_LIST:
	case NODE_POINTER:
	case NODE_ENUMERATOR:
	case NODE_UNARY_EXPRESSION:
		return -EPERM;

	case NODE_UNKNOWN:
	default:
		fprintf(stderr, "[error] %s: unknown node type %d\n", __func__,
			(int) parent->type);
		return -EINVAL;
	}
	return 0;
}

/*
 * set_parent_node
 *
 * Link node to parent. Returns 0 on success, -EPERM if it is not permitted to
 * create the link declared by the input, -ENOENT if node or parent is NULL,
 * -EINVAL if there is an internal structure problem.
 */
static int set_parent_node(struct ctf_node *node,
			 struct ctf_node *parent)
{
	if (!node || !parent)
		return -ENOENT;

	/* Note: Linking to parent will be done only by an external visitor */

	switch (node->type) {
	case NODE_ROOT:
		fprintf(stderr, "[error] %s: trying to reparent root node\n", __func__);
		return -EINVAL;

	case NODE_EVENT:
		if (parent->type == NODE_ROOT) {
			_cds_list_splice_tail(&node->tmp_head, &parent->u.root.event);
		} else {
			return -EPERM;
		}
		break;
	case NODE_STREAM:
		if (parent->type == NODE_ROOT) {
			_cds_list_splice_tail(&node->tmp_head, &parent->u.root.stream);
		} else {
			return -EPERM;
		}
		break;
	case NODE_TRACE:
		if (parent->type == NODE_ROOT) {
			_cds_list_splice_tail(&node->tmp_head, &parent->u.root.trace);
		} else {
			return -EPERM;
		}
		break;

	case NODE_CTF_EXPRESSION:
		return reparent_ctf_expression(node, parent);
	case NODE_UNARY_EXPRESSION:
		if (parent->type == NODE_TYPE_DECLARATOR)
			parent->u.type_declarator.bitfield_len = node;
		else
			return -EPERM;
		break;

	case NODE_TYPEDEF:
		return reparent_typedef(node, parent);
	case NODE_TYPEALIAS_TARGET:
		if (parent->type == NODE_TYPEALIAS)
			parent->u.typealias.target = node;
		else
			return -EINVAL;
	case NODE_TYPEALIAS_ALIAS:
		if (parent->type == NODE_TYPEALIAS)
			parent->u.typealias.alias = node;
		else
			return -EINVAL;
	case NODE_TYPEALIAS:
		return reparent_typealias(node, parent);

	case NODE_POINTER:
		if (parent->type == NODE_TYPE_DECLARATOR) {
			_cds_list_splice_tail(&node->tmp_head, &parent->u.type_declarator.pointers);
		} else
			return -EPERM;
		break;
	case NODE_TYPE_DECLARATOR:
		return reparent_type_declarator(node, parent);

	case NODE_TYPE_SPECIFIER_LIST:
		return reparent_type_specifier_list(node, parent);

	case NODE_TYPE_SPECIFIER:
		return reparent_type_specifier(node, parent);

	case NODE_FLOATING_POINT:
	case NODE_INTEGER:
	case NODE_STRING:
	case NODE_ENUM:
	case NODE_VARIANT:
	case NODE_STRUCT:
		return -EINVAL;	/* Dealt with internally within grammar */

	case NODE_ENUMERATOR:
		if (parent->type == NODE_ENUM) {
			_cds_list_splice_tail(&node->tmp_head, &parent->u._enum.enumerator_list);
		} else {
			return -EPERM;
		}
		break;
	case NODE_STRUCT_OR_VARIANT_DECLARATION:
		switch (parent->type) {
		case NODE_STRUCT:
			_cds_list_splice_tail(&node->tmp_head, &parent->u._struct.declaration_list);
			break;
		case NODE_VARIANT:
			_cds_list_splice_tail(&node->tmp_head, &parent->u.variant.declaration_list);
			break;
		default:
			return -EINVAL;
		}
		break;

	case NODE_UNKNOWN:
	default:
		fprintf(stderr, "[error] %s: unknown node type %d\n", __func__,
			(int) parent->type);
		return -EINVAL;
	}
	return 0;
}

void yyerror(struct ctf_scanner *scanner, const char *str)
{
	fprintf(stderr, "error %s\n", str);
}
 
int yywrap(void)
{
	return 1;
} 

#define reparent_error(scanner, str)				\
do {								\
	yyerror(scanner, YY_("reparent_error: " str "\n"));	\
	YYERROR;						\
} while (0)

static void free_strings(struct cds_list_head *list)
{
	struct gc_string *gstr, *tmp;

	cds_list_for_each_entry_safe(gstr, tmp, list, gc)
		free(gstr);
}

static struct ctf_ast *ctf_ast_alloc(void)
{
	struct ctf_ast *ast;

	ast = malloc(sizeof(*ast));
	if (!ast)
		return NULL;
	memset(ast, 0, sizeof(*ast));
	CDS_INIT_LIST_HEAD(&ast->allocated_nodes);
	ast->root.type = NODE_ROOT;
	CDS_INIT_LIST_HEAD(&ast->root.tmp_head);
	CDS_INIT_LIST_HEAD(&ast->root.u.root.declaration_list);
	CDS_INIT_LIST_HEAD(&ast->root.u.root.trace);
	CDS_INIT_LIST_HEAD(&ast->root.u.root.stream);
	CDS_INIT_LIST_HEAD(&ast->root.u.root.event);
	return ast;
}

static void ctf_ast_free(struct ctf_ast *ast)
{
	struct ctf_node *node, *tmp;

	cds_list_for_each_entry_safe(node, tmp, &ast->allocated_nodes, gc)
		free(node);
}

int ctf_scanner_append_ast(struct ctf_scanner *scanner)
{
	return yyparse(scanner);
}

struct ctf_scanner *ctf_scanner_alloc(FILE *input)
{
	struct ctf_scanner *scanner;
	int ret;

	yydebug = babeltrace_debug;

	scanner = malloc(sizeof(*scanner));
	if (!scanner)
		return NULL;
	memset(scanner, 0, sizeof(*scanner));

	ret = yylex_init_extra(scanner, &scanner->scanner);
	if (ret) {
		fprintf(stderr, "yylex_init error\n");
		goto cleanup_scanner;
	}
	/* Start processing new stream */
	yyrestart(input, scanner->scanner);

	scanner->ast = ctf_ast_alloc();
	if (!scanner->ast)
		goto cleanup_lexer;
	init_scope(&scanner->root_scope, NULL);
	scanner->cs = &scanner->root_scope;
	CDS_INIT_LIST_HEAD(&scanner->allocated_strings);

	if (yydebug)
		fprintf(stdout, "Scanner input is a%s.\n",
			isatty(fileno(input)) ? "n interactive tty" :
						" noninteractive file");

	return scanner;

cleanup_lexer:
	ret = yylex_destroy(scanner->scanner);
	if (!ret)
		fprintf(stderr, "yylex_destroy error\n");
cleanup_scanner:
	free(scanner);
	return NULL;
}

void ctf_scanner_free(struct ctf_scanner *scanner)
{
	int ret;

	finalize_scope(&scanner->root_scope);
	free_strings(&scanner->allocated_strings);
	ctf_ast_free(scanner->ast);
	ret = yylex_destroy(scanner->scanner);
	if (ret)
		fprintf(stderr, "yylex_destroy error\n");
	free(scanner);
}



/* Line 189 of yacc.c  */
#line 914 "ctf-parser.c"

/* Enabling traces.  */
#ifndef YYDEBUG
# define YYDEBUG 1
#endif

/* Enabling verbose error messages.  */
#ifdef YYERROR_VERBOSE
# undef YYERROR_VERBOSE
# define YYERROR_VERBOSE 1
#else
# define YYERROR_VERBOSE 0
#endif

/* Enabling the token table.  */
#ifndef YYTOKEN_TABLE
# define YYTOKEN_TABLE 0
#endif


/* Tokens.  */
#ifndef YYTOKENTYPE
# define YYTOKENTYPE
   /* Put the tokens into the symbol table, so that GDB and other debuggers
      know about them.  */
   enum yytokentype {
     CHARACTER_CONSTANT_START = 258,
     SQUOTE = 259,
     STRING_LITERAL_START = 260,
     DQUOTE = 261,
     ESCSEQ = 262,
     CHAR_STRING_TOKEN = 263,
     LSBRAC = 264,
     RSBRAC = 265,
     LPAREN = 266,
     RPAREN = 267,
     LBRAC = 268,
     RBRAC = 269,
     RARROW = 270,
     STAR = 271,
     PLUS = 272,
     MINUS = 273,
     LT = 274,
     GT = 275,
     TYPEASSIGN = 276,
     COLON = 277,
     SEMICOLON = 278,
     DOTDOTDOT = 279,
     DOT = 280,
     EQUAL = 281,
     COMMA = 282,
     CONST = 283,
     CHAR = 284,
     DOUBLE = 285,
     ENUM = 286,
     EVENT = 287,
     FLOATING_POINT = 288,
     FLOAT = 289,
     INTEGER = 290,
     INT = 291,
     LONG = 292,
     SHORT = 293,
     SIGNED = 294,
     STREAM = 295,
     STRING = 296,
     STRUCT = 297,
     TRACE = 298,
     TYPEALIAS = 299,
     TYPEDEF = 300,
     UNSIGNED = 301,
     VARIANT = 302,
     VOID = 303,
     _BOOL = 304,
     _COMPLEX = 305,
     _IMAGINARY = 306,
     DECIMAL_CONSTANT = 307,
     OCTAL_CONSTANT = 308,
     HEXADECIMAL_CONSTANT = 309,
     TOK_ALIGN = 310,
     IDENTIFIER = 311,
     ID_TYPE = 312,
     ERROR = 313
   };
#endif
/* Tokens.  */
#define CHARACTER_CONSTANT_START 258
#define SQUOTE 259
#define STRING_LITERAL_START 260
#define DQUOTE 261
#define ESCSEQ 262
#define CHAR_STRING_TOKEN 263
#define LSBRAC 264
#define RSBRAC 265
#define LPAREN 266
#define RPAREN 267
#define LBRAC 268
#define RBRAC 269
#define RARROW 270
#define STAR 271
#define PLUS 272
#define MINUS 273
#define LT 274
#define GT 275
#define TYPEASSIGN 276
#define COLON 277
#define SEMICOLON 278
#define DOTDOTDOT 279
#define DOT 280
#define EQUAL 281
#define COMMA 282
#define CONST 283
#define CHAR 284
#define DOUBLE 285
#define ENUM 286
#define EVENT 287
#define FLOATING_POINT 288
#define FLOAT 289
#define INTEGER 290
#define INT 291
#define LONG 292
#define SHORT 293
#define SIGNED 294
#define STREAM 295
#define STRING 296
#define STRUCT 297
#define TRACE 298
#define TYPEALIAS 299
#define TYPEDEF 300
#define UNSIGNED 301
#define VARIANT 302
#define VOID 303
#define _BOOL 304
#define _COMPLEX 305
#define _IMAGINARY 306
#define DECIMAL_CONSTANT 307
#define OCTAL_CONSTANT 308
#define HEXADECIMAL_CONSTANT 309
#define TOK_ALIGN 310
#define IDENTIFIER 311
#define ID_TYPE 312
#define ERROR 313




#if ! defined YYSTYPE && ! defined YYSTYPE_IS_DECLARED
typedef union YYSTYPE
{

/* Line 214 of yacc.c  */
#line 859 "ctf-parser.y"

	long long ll;
	char c;
	struct gc_string *gs;
	struct ctf_node *n;



/* Line 214 of yacc.c  */
#line 1075 "ctf-parser.c"
} YYSTYPE;
# define YYSTYPE_IS_TRIVIAL 1
# define yystype YYSTYPE /* obsolescent; will be withdrawn */
# define YYSTYPE_IS_DECLARED 1
#endif


/* Copy the second part of user declarations.  */


/* Line 264 of yacc.c  */
#line 1087 "ctf-parser.c"

#ifdef short
# undef short
#endif

#ifdef YYTYPE_UINT8
typedef YYTYPE_UINT8 yytype_uint8;
#else
typedef unsigned char yytype_uint8;
#endif

#ifdef YYTYPE_INT8
typedef YYTYPE_INT8 yytype_int8;
#elif (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
typedef signed char yytype_int8;
#else
typedef short int yytype_int8;
#endif

#ifdef YYTYPE_UINT16
typedef YYTYPE_UINT16 yytype_uint16;
#else
typedef unsigned short int yytype_uint16;
#endif

#ifdef YYTYPE_INT16
typedef YYTYPE_INT16 yytype_int16;
#else
typedef short int yytype_int16;
#endif

#ifndef YYSIZE_T
# ifdef __SIZE_TYPE__
#  define YYSIZE_T __SIZE_TYPE__
# elif defined size_t
#  define YYSIZE_T size_t
# elif ! defined YYSIZE_T && (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
#  include <stddef.h> /* INFRINGES ON USER NAME SPACE */
#  define YYSIZE_T size_t
# else
#  define YYSIZE_T unsigned int
# endif
#endif

#define YYSIZE_MAXIMUM ((YYSIZE_T) -1)

#ifndef YY_
# if YYENABLE_NLS
#  if ENABLE_NLS
#   include <libintl.h> /* INFRINGES ON USER NAME SPACE */
#   define YY_(msgid) dgettext ("bison-runtime", msgid)
#  endif
# endif
# ifndef YY_
#  define YY_(msgid) msgid
# endif
#endif

/* Suppress unused-variable warnings by "using" E.  */
#if ! defined lint || defined __GNUC__
# define YYUSE(e) ((void) (e))
#else
# define YYUSE(e) /* empty */
#endif

/* Identity function, used to suppress warnings about constant conditions.  */
#ifndef lint
# define YYID(n) (n)
#else
#if (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
static int
YYID (int yyi)
#else
static int
YYID (yyi)
    int yyi;
#endif
{
  return yyi;
}
#endif

#if ! defined yyoverflow || YYERROR_VERBOSE

/* The parser invokes alloca or malloc; define the necessary symbols.  */

# ifdef YYSTACK_USE_ALLOCA
#  if YYSTACK_USE_ALLOCA
#   ifdef __GNUC__
#    define YYSTACK_ALLOC __builtin_alloca
#   elif defined __BUILTIN_VA_ARG_INCR
#    include <alloca.h> /* INFRINGES ON USER NAME SPACE */
#   elif defined _AIX
#    define YYSTACK_ALLOC __alloca
#   elif defined _MSC_VER
#    include <malloc.h> /* INFRINGES ON USER NAME SPACE */
#    define alloca _alloca
#   else
#    define YYSTACK_ALLOC alloca
#    if ! defined _ALLOCA_H && ! defined _STDLIB_H && (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
#     include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
#     ifndef _STDLIB_H
#      define _STDLIB_H 1
#     endif
#    endif
#   endif
#  endif
# endif

# ifdef YYSTACK_ALLOC
   /* Pacify GCC's `empty if-body' warning.  */
#  define YYSTACK_FREE(Ptr) do { /* empty */; } while (YYID (0))
#  ifndef YYSTACK_ALLOC_MAXIMUM
    /* The OS might guarantee only one guard page at the bottom of the stack,
       and a page size can be as small as 4096 bytes.  So we cannot safely
       invoke alloca (N) if N exceeds 4096.  Use a slightly smaller number
       to allow for a few compiler-allocated temporary stack slots.  */
#   define YYSTACK_ALLOC_MAXIMUM 4032 /* reasonable circa 2006 */
#  endif
# else
#  define YYSTACK_ALLOC YYMALLOC
#  define YYSTACK_FREE YYFREE
#  ifndef YYSTACK_ALLOC_MAXIMUM
#   define YYSTACK_ALLOC_MAXIMUM YYSIZE_MAXIMUM
#  endif
#  if (defined __cplusplus && ! defined _STDLIB_H \
       && ! ((defined YYMALLOC || defined malloc) \
	     && (defined YYFREE || defined free)))
#   include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
#   ifndef _STDLIB_H
#    define _STDLIB_H 1
#   endif
#  endif
#  ifndef YYMALLOC
#   define YYMALLOC malloc
#   if ! defined malloc && ! defined _STDLIB_H && (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
void *malloc (YYSIZE_T); /* INFRINGES ON USER NAME SPACE */
#   endif
#  endif
#  ifndef YYFREE
#   define YYFREE free
#   if ! defined free && ! defined _STDLIB_H && (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
void free (void *); /* INFRINGES ON USER NAME SPACE */
#   endif
#  endif
# endif
#endif /* ! defined yyoverflow || YYERROR_VERBOSE */


#if (! defined yyoverflow \
     && (! defined __cplusplus \
	 || (defined YYSTYPE_IS_TRIVIAL && YYSTYPE_IS_TRIVIAL)))

/* A type that is properly aligned for any stack member.  */
union yyalloc
{
  yytype_int16 yyss_alloc;
  YYSTYPE yyvs_alloc;
};

/* The size of the maximum gap between one aligned stack and the next.  */
# define YYSTACK_GAP_MAXIMUM (sizeof (union yyalloc) - 1)

/* The size of an array large to enough to hold all stacks, each with
   N elements.  */
# define YYSTACK_BYTES(N) \
     ((N) * (sizeof (yytype_int16) + sizeof (YYSTYPE)) \
      + YYSTACK_GAP_MAXIMUM)

/* Copy COUNT objects from FROM to TO.  The source and destination do
   not overlap.  */
# ifndef YYCOPY
#  if defined __GNUC__ && 1 < __GNUC__
#   define YYCOPY(To, From, Count) \
      __builtin_memcpy (To, From, (Count) * sizeof (*(From)))
#  else
#   define YYCOPY(To, From, Count)		\
      do					\
	{					\
	  YYSIZE_T yyi;				\
	  for (yyi = 0; yyi < (Count); yyi++)	\
	    (To)[yyi] = (From)[yyi];		\
	}					\
      while (YYID (0))
#  endif
# endif

/* Relocate STACK from its old location to the new one.  The
   local variables YYSIZE and YYSTACKSIZE give the old and new number of
   elements in the stack, and YYPTR gives the new location of the
   stack.  Advance YYPTR to a properly aligned location for the next
   stack.  */
# define YYSTACK_RELOCATE(Stack_alloc, Stack)				\
    do									\
      {									\
	YYSIZE_T yynewbytes;						\
	YYCOPY (&yyptr->Stack_alloc, Stack, yysize);			\
	Stack = &yyptr->Stack_alloc;					\
	yynewbytes = yystacksize * sizeof (*Stack) + YYSTACK_GAP_MAXIMUM; \
	yyptr += yynewbytes / sizeof (*yyptr);				\
      }									\
    while (YYID (0))

#endif

/* YYFINAL -- State number of the termination state.  */
#define YYFINAL  60
/* YYLAST -- Last index in YYTABLE.  */
#define YYLAST   2043

/* YYNTOKENS -- Number of terminals.  */
#define YYNTOKENS  59
/* YYNNTS -- Number of nonterminals.  */
#define YYNNTS  53
/* YYNRULES -- Number of rules.  */
#define YYNRULES  227
/* YYNRULES -- Number of states.  */
#define YYNSTATES  433

/* YYTRANSLATE(YYLEX) -- Bison symbol number corresponding to YYLEX.  */
#define YYUNDEFTOK  2
#define YYMAXUTOK   313

#define YYTRANSLATE(YYX)						\
  ((unsigned int) (YYX) <= YYMAXUTOK ? yytranslate[YYX] : YYUNDEFTOK)

/* YYTRANSLATE[YYLEX] -- Bison symbol number corresponding to YYLEX.  */
static const yytype_uint8 yytranslate[] =
{
       0,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     1,     2,     3,     4,
       5,     6,     7,     8,     9,    10,    11,    12,    13,    14,
      15,    16,    17,    18,    19,    20,    21,    22,    23,    24,
      25,    26,    27,    28,    29,    30,    31,    32,    33,    34,
      35,    36,    37,    38,    39,    40,    41,    42,    43,    44,
      45,    46,    47,    48,    49,    50,    51,    52,    53,    54,
      55,    56,    57,    58
};

#if YYDEBUG
/* YYPRHS[YYN] -- Index of the first RHS symbol of rule number YYN in
   YYRHS.  */
static const yytype_uint16 yyprhs[] =
{
       0,     0,     3,     5,     8,    10,    12,    14,    16,    18,
      20,    22,    24,    26,    28,    30,    32,    34,    36,    38,
      40,    42,    44,    46,    48,    50,    52,    54,    56,    58,
      61,    63,    65,    67,    70,    72,    74,    76,    78,    80,
      82,    84,    86,    89,    93,    97,   101,   106,   110,   114,
     118,   122,   124,   127,   130,   134,   136,   139,   141,   143,
     145,   151,   156,   161,   169,   172,   176,   179,   182,   185,
     189,   192,   195,   198,   202,   205,   208,   210,   212,   215,
     218,   220,   222,   225,   228,   230,   234,   236,   238,   240,
     242,   244,   246,   248,   250,   254,   259,   261,   263,   265,
     267,   269,   271,   273,   275,   277,   279,   281,   283,   285,
     289,   294,   298,   303,   305,   309,   314,   317,   320,   323,
     327,   332,   337,   339,   341,   349,   358,   367,   369,   371,
     375,   382,   389,   394,   402,   407,   415,   420,   425,   433,
     438,   446,   451,   453,   455,   459,   465,   470,   477,   482,
     489,   494,   501,   507,   515,   517,   523,   531,   533,   534,
     537,   541,   547,   552,   557,   565,   567,   569,   571,   574,
     577,   580,   582,   586,   588,   591,   595,   597,   601,   603,
     605,   607,   610,   614,   618,   622,   626,   631,   637,   639,
     643,   645,   648,   649,   651,   655,   660,   664,   666,   670,
     672,   675,   676,   680,   685,   689,   691,   694,   696,   700,
     705,   707,   710,   712,   716,   721,   723,   726,   730,   732,
     735,   738,   742,   746,   750,   755,   759,   763
};

/* YYRHS -- A `-1'-separated list of the rules' RHS.  */
static const yytype_int8 yyrhs[] =
{
      60,     0,    -1,    69,    -1,    60,    69,    -1,    48,    -1,
      29,    -1,    38,    -1,    36,    -1,    37,    -1,    34,    -1,
      30,    -1,    39,    -1,    46,    -1,    49,    -1,    50,    -1,
      51,    -1,    33,    -1,    35,    -1,    41,    -1,    31,    -1,
      47,    -1,    42,    -1,    28,    -1,    45,    -1,    32,    -1,
      40,    -1,    43,    -1,    55,    -1,    63,    -1,    62,    63,
      -1,     8,    -1,     7,    -1,    65,    -1,    64,    65,    -1,
       8,    -1,     7,    -1,    56,    -1,    57,    -1,    61,    -1,
      52,    -1,    53,    -1,    54,    -1,     5,     6,    -1,     5,
      64,     6,    -1,     3,    62,     4,    -1,    11,    67,    12,
      -1,    66,     9,    67,    10,    -1,    66,    25,    56,    -1,
      66,    25,    57,    -1,    66,    15,    56,    -1,    66,    15,
      57,    -1,    66,    -1,    17,    66,    -1,    18,    66,    -1,
      67,    24,    67,    -1,    67,    -1,    80,    23,    -1,    70,
      -1,    73,    -1,    76,    -1,    80,    45,    80,    81,    23,
      -1,    45,    80,    81,    23,    -1,    80,    45,    81,    23,
      -1,    44,    80,    98,    21,    93,   101,    23,    -1,    71,
      72,    -1,    71,   110,    72,    -1,    32,    13,    -1,    14,
      23,    -1,    74,    75,    -1,    74,   110,    75,    -1,    40,
      13,    -1,    14,    23,    -1,    77,    78,    -1,    77,   110,
      78,    -1,    43,    13,    -1,    14,    23,    -1,    28,    -1,
      82,    -1,    79,    28,    -1,    79,    82,    -1,    28,    -1,
      83,    -1,    80,    28,    -1,    80,    83,    -1,   106,    -1,
      81,    27,   106,    -1,    29,    -1,    38,    -1,    36,    -1,
      37,    -1,    39,    -1,    46,    -1,    49,    -1,    57,    -1,
      35,    13,    14,    -1,    35,    13,   110,    14,    -1,    48,
      -1,    29,    -1,    38,    -1,    36,    -1,    37,    -1,    34,
      -1,    30,    -1,    39,    -1,    46,    -1,    49,    -1,    50,
      -1,    51,    -1,    57,    -1,    33,    13,    14,    -1,    33,
      13,   110,    14,    -1,    35,    13,    14,    -1,    35,    13,
     110,    14,    -1,    41,    -1,    41,    13,    14,    -1,    41,
      13,   110,    14,    -1,    31,    90,    -1,    47,    87,    -1,
      42,    84,    -1,    85,    91,    86,    -1,    56,    85,    91,
      86,    -1,    57,    85,    91,    86,    -1,    56,    -1,    57,
      -1,    85,    91,    86,    55,    11,    67,    12,    -1,    56,
      85,    91,    86,    55,    11,    67,    12,    -1,    57,    85,
      91,    86,    55,    11,    67,    12,    -1,    13,    -1,    14,
      -1,    88,    91,    89,    -1,    19,    56,    20,    88,    91,
      89,    -1,    19,    57,    20,    88,    91,    89,    -1,    56,
      88,    91,    89,    -1,    56,    19,    56,    20,    88,    91,
      89,    -1,    56,    19,    56,    20,    -1,    56,    19,    57,
      20,    88,    91,    89,    -1,    56,    19,    57,    20,    -1,
      57,    88,    91,    89,    -1,    57,    19,    56,    20,    88,
      91,    89,    -1,    57,    19,    56,    20,    -1,    57,    19,
      57,    20,    88,    91,    89,    -1,    57,    19,    57,    20,
      -1,    13,    -1,    14,    -1,    13,    96,    14,    -1,    22,
      79,    13,    96,    14,    -1,    56,    13,    96,    14,    -1,
      56,    22,    79,    13,    96,    14,    -1,    57,    13,    96,
      14,    -1,    57,    22,    79,    13,    96,    14,    -1,    13,
      96,    27,    14,    -1,    22,    79,    13,    96,    27,    14,
      -1,    56,    13,    96,    27,    14,    -1,    56,    22,    79,
      13,    96,    27,    14,    -1,    56,    -1,    57,    13,    96,
      27,    14,    -1,    57,    22,    79,    13,    96,    27,    14,
      -1,    57,    -1,    -1,    91,    92,    -1,    80,    94,    23,
      -1,    80,    45,    80,    81,    23,    -1,    45,    80,    81,
      23,    -1,    80,    45,    81,    23,    -1,    44,    80,    98,
      21,    93,   101,    23,    -1,    28,    -1,    83,    -1,    56,
      -1,    93,    28,    -1,    93,    83,    -1,    93,    56,    -1,
      95,    -1,    94,    27,    95,    -1,   104,    -1,    22,    67,
      -1,   104,    22,    67,    -1,    97,    -1,    96,    27,    97,
      -1,    56,    -1,    57,    -1,    61,    -1,     5,     6,    -1,
       5,    64,     6,    -1,    56,    26,    68,    -1,    57,    26,
      68,    -1,    61,    26,    68,    -1,     5,     6,    26,    68,
      -1,     5,    64,     6,    26,    68,    -1,    99,    -1,    98,
      27,    99,    -1,   100,    -1,   108,   100,    -1,    -1,    56,
      -1,    11,    99,    12,    -1,   100,     9,    67,    10,    -1,
     100,     9,    10,    -1,   102,    -1,   101,    27,   102,    -1,
     103,    -1,   108,   103,    -1,    -1,    11,   102,    12,    -1,
     103,     9,    67,    10,    -1,   103,     9,    10,    -1,   105,
      -1,   108,   105,    -1,    56,    -1,    11,   104,    12,    -1,
     105,     9,    67,    10,    -1,   107,    -1,   108,   107,    -1,
      56,    -1,    11,   106,    12,    -1,   107,     9,    67,    10,
      -1,    16,    -1,    16,   108,    -1,    16,   109,   108,    -1,
      28,    -1,   109,    28,    -1,   111,    23,    -1,   110,   111,
      23,    -1,    67,    26,    67,    -1,    67,    21,    80,    -1,
      80,    45,    80,    81,    -1,    45,    80,    81,    -1,    80,
      45,    81,    -1,    44,    80,    98,    21,    93,   101,    -1
};

/* YYRLINE[YYN] -- source line where rule number YYN was defined.  */
static const yytype_uint16 yyrline[] =
{
       0,   908,   908,   913,   921,   923,   925,   927,   929,   931,
     933,   935,   937,   939,   941,   943,   945,   947,   949,   951,
     953,   955,   957,   959,   961,   963,   965,   967,   974,   976,
     981,   983,   992,   994,   999,  1001,  1010,  1016,  1022,  1028,
    1035,  1042,  1049,  1055,  1061,  1067,  1073,  1081,  1090,  1099,
    1108,  1120,  1122,  1124,  1143,  1149,  1156,  1158,  1160,  1162,
    1164,  1175,  1185,  1195,  1216,  1220,  1229,  1234,  1240,  1244,
    1253,  1258,  1264,  1268,  1277,  1282,  1287,  1296,  1304,  1313,
    1321,  1330,  1338,  1347,  1355,  1357,  1365,  1370,  1375,  1380,
    1385,  1390,  1395,  1400,  1406,  1412,  1423,  1428,  1433,  1438,
    1443,  1448,  1453,  1458,  1463,  1468,  1473,  1478,  1483,  1489,
    1495,  1503,  1509,  1517,  1523,  1529,  1537,  1543,  1549,  1558,
    1565,  1573,  1581,  1587,  1593,  1601,  1610,  1622,  1627,  1632,
    1639,  1647,  1655,  1663,  1672,  1679,  1688,  1695,  1703,  1712,
    1719,  1728,  1738,  1743,  1748,  1754,  1761,  1768,  1776,  1783,
    1791,  1797,  1804,  1811,  1819,  1825,  1832,  1840,  1850,  1851,
    1864,  1874,  1885,  1895,  1905,  1926,  1935,  1943,  1954,  1963,
    1968,  1982,  1984,  1992,  1994,  1996,  2005,  2007,  2015,  2020,
    2025,  2030,  2035,  2040,  2046,  2052,  2058,  2064,  2073,  2075,
    2083,  2085,  2094,  2099,  2105,  2111,  2119,  2129,  2131,  2139,
    2141,  2150,  2155,  2161,  2169,  2179,  2181,  2189,  2195,  2201,
    2212,  2214,  2222,  2229,  2235,  2246,  2250,  2255,  2265,  2266,
    2272,  2274,  2282,  2294,  2306,  2317,  2327,  2337
};
#endif

#if YYDEBUG || YYERROR_VERBOSE || YYTOKEN_TABLE
/* YYTNAME[SYMBOL-NUM] -- String name of the symbol SYMBOL-NUM.
   First, the terminals, then, starting at YYNTOKENS, nonterminals.  */
static const char *const yytname[] =
{
  "$end", "error", "$undefined", "CHARACTER_CONSTANT_START", "SQUOTE",
  "STRING_LITERAL_START", "DQUOTE", "ESCSEQ", "CHAR_STRING_TOKEN",
  "LSBRAC", "RSBRAC", "LPAREN", "RPAREN", "LBRAC", "RBRAC", "RARROW",
  "STAR", "PLUS", "MINUS", "LT", "GT", "TYPEASSIGN", "COLON", "SEMICOLON",
  "DOTDOTDOT", "DOT", "EQUAL", "COMMA", "CONST", "CHAR", "DOUBLE", "ENUM",
  "EVENT", "FLOATING_POINT", "FLOAT", "INTEGER", "INT", "LONG", "SHORT",
  "SIGNED", "STREAM", "STRING", "STRUCT", "TRACE", "TYPEALIAS", "TYPEDEF",
  "UNSIGNED", "VARIANT", "VOID", "_BOOL", "_COMPLEX", "_IMAGINARY",
  "DECIMAL_CONSTANT", "OCTAL_CONSTANT", "HEXADECIMAL_CONSTANT",
  "TOK_ALIGN", "IDENTIFIER", "ID_TYPE", "ERROR", "$accept", "file",
  "keywords", "c_char_sequence", "c_char", "s_char_sequence", "s_char",
  "postfix_expression", "unary_expression", "unary_expression_or_range",
  "declaration", "event_declaration", "event_declaration_begin",
  "event_declaration_end", "stream_declaration",
  "stream_declaration_begin", "stream_declaration_end",
  "trace_declaration", "trace_declaration_begin", "trace_declaration_end",
  "integer_declaration_specifiers", "declaration_specifiers",
  "type_declarator_list", "integer_type_specifier", "type_specifier",
  "struct_type_specifier", "struct_declaration_begin",
  "struct_declaration_end", "variant_type_specifier",
  "variant_declaration_begin", "variant_declaration_end",
  "enum_type_specifier", "struct_or_variant_declaration_list",
  "struct_or_variant_declaration", "alias_declaration_specifiers",
  "struct_or_variant_declarator_list", "struct_or_variant_declarator",
  "enumerator_list", "enumerator", "abstract_declarator_list",
  "abstract_declarator", "direct_abstract_declarator",
  "alias_abstract_declarator_list", "alias_abstract_declarator",
  "direct_alias_abstract_declarator", "declarator", "direct_declarator",
  "type_declarator", "direct_type_declarator", "pointer",
  "type_qualifier_list", "ctf_assignment_expression_list",
  "ctf_assignment_expression", 0
};
#endif

# ifdef YYPRINT
/* YYTOKNUM[YYLEX-NUM] -- Internal token number corresponding to
   token YYLEX-NUM.  */
static const yytype_uint16 yytoknum[] =
{
       0,   256,   257,   258,   259,   260,   261,   262,   263,   264,
     265,   266,   267,   268,   269,   270,   271,   272,   273,   274,
     275,   276,   277,   278,   279,   280,   281,   282,   283,   284,
     285,   286,   287,   288,   289,   290,   291,   292,   293,   294,
     295,   296,   297,   298,   299,   300,   301,   302,   303,   304,
     305,   306,   307,   308,   309,   310,   311,   312,   313
};
# endif

/* YYR1[YYN] -- Symbol number of symbol that rule YYN derives.  */
static const yytype_uint8 yyr1[] =
{
       0,    59,    60,    60,    61,    61,    61,    61,    61,    61,
      61,    61,    61,    61,    61,    61,    61,    61,    61,    61,
      61,    61,    61,    61,    61,    61,    61,    61,    62,    62,
      63,    63,    64,    64,    65,    65,    66,    66,    66,    66,
      66,    66,    66,    66,    66,    66,    66,    66,    66,    66,
      66,    67,    67,    67,    68,    68,    69,    69,    69,    69,
      69,    69,    69,    69,    70,    70,    71,    72,    73,    73,
      74,    75,    76,    76,    77,    78,    79,    79,    79,    79,
      80,    80,    80,    80,    81,    81,    82,    82,    82,    82,
      82,    82,    82,    82,    82,    82,    83,    83,    83,    83,
      83,    83,    83,    83,    83,    83,    83,    83,    83,    83,
      83,    83,    83,    83,    83,    83,    83,    83,    83,    84,
      84,    84,    84,    84,    84,    84,    84,    85,    86,    87,
      87,    87,    87,    87,    87,    87,    87,    87,    87,    87,
      87,    87,    88,    89,    90,    90,    90,    90,    90,    90,
      90,    90,    90,    90,    90,    90,    90,    90,    91,    91,
      92,    92,    92,    92,    92,    93,    93,    93,    93,    93,
      93,    94,    94,    95,    95,    95,    96,    96,    97,    97,
      97,    97,    97,    97,    97,    97,    97,    97,    98,    98,
      99,    99,   100,   100,   100,   100,   100,   101,   101,   102,
     102,   103,   103,   103,   103,   104,   104,   105,   105,   105,
     106,   106,   107,   107,   107,   108,   108,   108,   109,   109,
     110,   110,   111,   111,   111,   111,   111,   111
};

/* YYR2[YYN] -- Number of symbols composing right hand side of rule YYN.  */
static const yytype_uint8 yyr2[] =
{
       0,     2,     1,     2,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     2,
       1,     1,     1,     2,     1,     1,     1,     1,     1,     1,
       1,     1,     2,     3,     3,     3,     4,     3,     3,     3,
       3,     1,     2,     2,     3,     1,     2,     1,     1,     1,
       5,     4,     4,     7,     2,     3,     2,     2,     2,     3,
       2,     2,     2,     3,     2,     2,     1,     1,     2,     2,
       1,     1,     2,     2,     1,     3,     1,     1,     1,     1,
       1,     1,     1,     1,     3,     4,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     3,
       4,     3,     4,     1,     3,     4,     2,     2,     2,     3,
       4,     4,     1,     1,     7,     8,     8,     1,     1,     3,
       6,     6,     4,     7,     4,     7,     4,     4,     7,     4,
       7,     4,     1,     1,     3,     5,     4,     6,     4,     6,
       4,     6,     5,     7,     1,     5,     7,     1,     0,     2,
       3,     5,     4,     4,     7,     1,     1,     1,     2,     2,
       2,     1,     3,     1,     2,     3,     1,     3,     1,     1,
       1,     2,     3,     3,     3,     3,     4,     5,     1,     3,
       1,     2,     0,     1,     3,     4,     3,     1,     3,     1,
       2,     0,     3,     4,     3,     1,     2,     1,     3,     4,
       1,     2,     1,     3,     4,     1,     2,     3,     1,     2,
       2,     3,     3,     3,     4,     3,     3,     6
};

/* YYDEFACT[STATE-NAME] -- Default rule to reduce with in state
   STATE-NUM when YYTABLE doesn't specify something else to do.  Zero
   means the default is an error.  */
static const yytype_uint8 yydefact[] =
{
       0,    80,    97,   102,     0,     0,     0,   101,     0,    99,
     100,    98,   103,     0,   113,     0,     0,     0,     0,   104,
       0,    96,   105,   106,   107,   108,     0,     2,    57,     0,
      58,     0,    59,     0,     0,    81,     0,     0,   154,   157,
     116,    66,     0,     0,    70,     0,   127,   122,   123,   118,
     158,    74,   192,     0,   142,     0,     0,     0,   117,   158,
       1,     3,     0,     0,     0,     0,     0,     0,    80,    97,
     102,    19,    24,    16,   101,    17,    99,   100,    98,   103,
      25,   113,    21,    26,     0,    23,   104,    20,    96,   105,
     106,   107,    39,    40,    41,    27,    36,   108,    38,    51,
       0,    64,     0,     0,     0,     0,    68,     0,     0,    72,
       0,    56,    82,     0,    83,     0,    22,     5,    10,    19,
      16,     9,    17,     7,     8,     6,    11,    18,    21,    23,
      12,    20,     4,    13,    14,    15,   178,   179,   180,     0,
     176,    76,    86,     0,    88,    89,    87,    90,    91,    92,
      93,     0,    77,     0,     0,     0,     0,   109,     0,   111,
       0,   114,     0,   158,   158,     0,   192,   215,   193,     0,
     188,   190,   192,     0,   212,     0,    84,   210,     0,     0,
       0,     0,   158,     0,   158,     0,    31,    30,     0,    28,
      42,    35,    34,     0,    32,    37,     0,    67,    52,    53,
     192,     0,     0,     0,     0,     0,     0,     0,    65,     0,
     220,    71,    69,    75,    73,     0,     0,   181,     0,     0,
       0,     0,   144,     0,     0,     0,    78,    79,     0,     0,
       0,     0,   110,   112,   115,     0,     0,   128,     0,     0,
       0,   119,   159,     0,   218,   216,     0,     0,   192,     0,
     191,     0,    61,     0,     0,   211,     0,     0,     0,     0,
       0,     0,     0,     0,   143,   129,    44,    29,    43,    33,
      45,     0,   225,     0,    49,    50,    47,    48,   223,   222,
       0,   226,   221,     0,    62,     0,   182,    55,   183,   184,
     185,   150,   177,    94,     0,     0,   146,     0,     0,   148,
       0,     0,   120,   121,   192,     0,     0,     0,     0,   207,
       0,   171,   173,   205,     0,     0,   194,   219,   217,   165,
     167,   166,   201,   189,   196,     0,   213,    85,     0,   158,
     158,   134,   136,   132,   139,   141,   137,     0,    46,   224,
      60,   186,     0,     0,    95,   145,     0,   152,     0,   155,
       0,     0,     0,     0,     0,     0,   174,     0,     0,   160,
       0,     0,     0,   206,     0,   201,   168,   170,   169,     0,
     197,   199,   201,   195,   214,     0,     0,   158,   158,   158,
     158,   201,   187,    54,   151,   147,     0,   149,     0,     0,
       0,     0,   162,   208,     0,   163,   172,   175,     0,     0,
       0,    63,   201,     0,   200,   130,   131,     0,     0,     0,
       0,   227,   153,   156,     0,     0,   201,   161,   209,   124,
     202,   198,   204,     0,   133,   135,   138,   140,   125,   126,
       0,   203,   164
};

/* YYDEFGOTO[NTERM-NUM].  */
static const yytype_int16 yydefgoto[] =
{
      -1,    26,    98,   188,   189,   193,   194,    99,   100,   288,
      27,    28,    29,   101,    30,    31,   106,    32,    33,   109,
     151,   102,   175,   152,    35,    49,    50,   241,    58,    59,
     265,    40,   165,   242,   322,   310,   311,   139,   140,   169,
     170,   171,   369,   370,   371,   312,   313,   176,   177,   178,
     246,   103,   104
};

/* YYPACT[STATE-NUM] -- Index in YYTABLE of the portion describing
   STATE-NUM.  */
#define YYPACT_NINF -336
static const yytype_int16 yypact[] =
{
    1857,  -336,  -336,  -336,    37,    52,    62,  -336,    94,  -336,
    -336,  -336,  -336,   115,   123,    48,   126,  1937,  1937,  -336,
      41,  -336,  -336,  -336,  -336,  -336,   383,  -336,  -336,   432,
    -336,   487,  -336,   542,  1827,  -336,  1489,  1986,   119,   120,
    -336,  -336,   597,   652,  -336,   707,  -336,   130,   130,  -336,
    -336,  -336,  1573,  1615,  -336,   137,   116,   140,  -336,  -336,
    -336,  -336,   202,   211,  1147,    25,  1202,  1202,   145,   261,
     274,    37,  -336,    62,   302,    94,   371,   378,   380,   427,
    -336,   125,    48,  -336,  1937,  1937,   430,    41,   482,   485,
     537,   540,  -336,  -336,  -336,  -336,  -336,   592,  -336,    43,
      36,  -336,  1882,   432,   129,   141,  -336,   487,   144,  -336,
     542,  -336,  -336,  1657,  -336,   250,  -336,  -336,  -336,  -336,
    -336,  -336,  -336,  -336,  -336,  -336,  -336,  -336,  -336,  -336,
    -336,  -336,  -336,  -336,  -336,  -336,   175,   206,   226,    29,
    -336,  -336,  -336,   198,  -336,  -336,  -336,  -336,  -336,  -336,
    -336,   185,  -336,  1489,  1986,  1489,  1986,  -336,   762,  -336,
     817,  -336,   872,  -336,  -336,  1759,    22,    35,  -336,    75,
    -336,   257,    24,    23,  -336,    91,  -336,   260,    26,   239,
     268,   188,  -336,   205,  -336,  1797,  -336,  -336,   221,  -336,
    -336,  -336,  -336,   271,  -336,  -336,   279,  -336,    43,    43,
    1573,  1615,  1147,   218,   224,  1937,  1147,  1657,  -336,   284,
    -336,  -336,  -336,  -336,  -336,  1615,    98,   286,   290,  1147,
    1147,  1147,  -336,  1255,   927,  1489,  -336,  -336,    39,   333,
      50,  1729,  -336,  -336,  -336,  1759,  1759,  -336,  1937,  1937,
    1531,   255,  -336,   282,  -336,  -336,    83,  1907,    22,  1037,
     257,   310,  -336,    23,  1147,   260,   311,   311,   306,   309,
    1797,   313,   316,  1797,  -336,  -336,  -336,  -336,  -336,  -336,
    -336,   151,   312,   327,  -336,  -336,  -336,  -336,  1962,  -336,
    1615,   312,  -336,   157,  -336,  1147,   318,   314,  -336,  -336,
    -336,  -336,  -336,  -336,   982,    59,  -336,  1294,  1489,  -336,
    1333,  1489,   292,   293,  1573,  1615,    33,  1147,  1657,  -336,
     177,  -336,   328,   343,    34,   345,  -336,  -336,  -336,  -336,
    -336,  -336,  1699,  -336,  -336,   344,  -336,  -336,   347,  -336,
    -336,   311,   311,  -336,   311,   311,  -336,  1907,  -336,   312,
    -336,  -336,  1147,  1147,  -336,  -336,  1372,  -336,    92,  -336,
     103,   349,   352,   154,   189,   346,  -336,  1615,   203,  -336,
      20,  1147,  1147,   343,  1147,   171,  -336,  -336,  -336,   210,
    -336,   355,   356,  -336,  -336,  1797,  1797,  -336,  -336,  -336,
    -336,  1699,  -336,  -336,  -336,  -336,  1411,  -336,  1450,  1147,
    1147,  1907,  -336,  -336,   220,  -336,  -336,  -336,   363,   354,
     362,  -336,   171,  1092,   355,  -336,  -336,  1797,  1797,  1797,
    1797,   350,  -336,  -336,   366,   369,  1699,  -336,  -336,  -336,
    -336,  -336,  -336,   375,  -336,  -336,  -336,  -336,  -336,  -336,
     227,  -336,  -336
};

/* YYPGOTO[NTERM-NUM].  */
static const yytype_int16 yypgoto[] =
{
    -336,  -336,   -33,  -336,   200,   276,  -146,   235,   -58,  -211,
     368,  -336,  -336,   295,  -336,  -336,   331,  -336,  -336,   334,
      32,     0,  -106,  -119,   -32,  -336,   273,    99,  -336,   -16,
    -252,  -336,   -37,  -336,  -308,  -336,    40,  -125,  -209,  -196,
    -161,   230,  -335,  -310,    69,   148,   133,  -150,   280,   -51,
    -336,   -18,   -91
};

/* YYTABLE[YYPACT[STATE-NUM]].  What to do in state STATE-NUM.  If
   positive, shift that token.  If negative, reduce the rule which
   number is the opposite.  If zero, do what YYDEFACT says.
   If YYTABLE_NINF, syntax error.  */
#define YYTABLE_NINF -38
static const yytype_int16 yytable[] =
{
      34,   172,   114,   138,   271,   243,   196,   216,   333,   289,
     290,   336,   209,   107,   292,   110,   209,    52,    53,   209,
     114,   114,   185,   251,   158,   160,    34,   162,   228,   381,
     230,   306,   227,   166,   173,   166,   167,   173,   167,   167,
     182,   184,   307,   222,   306,   306,   411,   269,   197,   167,
      36,   167,   202,   296,    54,   400,   223,   205,   203,    37,
      55,    46,   206,   244,   299,    41,   297,   209,   204,   209,
     114,   209,   269,   345,   341,    42,   309,   300,   168,   174,
     168,   430,   174,   416,   200,   201,   346,   323,   292,   309,
     309,   292,   421,    38,    39,   272,   247,    56,    57,   167,
     295,   281,   248,   327,    47,    48,   385,    43,   353,   283,
     227,   317,   227,   215,   252,   172,   245,   387,   253,   386,
     138,   284,   138,   405,   406,   253,   235,   236,    44,    54,
     388,   382,   153,   155,   -18,   181,    45,   292,    45,    51,
     -18,   154,   156,    46,   273,   260,   -18,   263,   279,   172,
     -18,   -18,   210,    54,   -22,   424,   425,   426,   427,   183,
     -22,   287,   287,   287,   211,   240,   -22,   213,   114,   114,
     -22,   -22,   337,   348,   339,   391,   350,   292,   248,   292,
     340,   248,   365,   114,   253,   240,   229,   167,   231,   314,
     138,   325,   138,   179,   180,   318,   328,   172,   225,   354,
     359,   219,   358,   209,   360,   278,   294,   280,   114,   186,
     187,   224,   392,   226,   142,   321,   253,   190,   191,   192,
     143,   144,   145,   146,   147,   266,   395,   287,   186,   187,
     253,   148,   220,   401,   149,   240,   240,   402,   304,   305,
     329,   330,   150,   417,   258,   259,   114,   253,   114,   356,
     432,   394,   221,   172,   402,   314,   217,   191,   192,   256,
     240,   261,   262,   240,   138,   138,   249,   138,   138,   254,
      -5,   372,   114,   114,   274,   275,    -5,   268,   191,   192,
     276,   277,    -5,   -10,   287,   383,    -5,    -5,   257,   -10,
     368,   270,   375,   376,   316,   -10,   286,   191,   192,   -10,
     -10,   198,   199,   397,   398,   321,   399,   282,   357,   314,
     315,    -9,   285,   138,   372,   377,   378,    -9,   379,   380,
     163,   164,   326,    -9,    54,   114,   331,    -9,    -9,   332,
     372,   414,   415,   334,   302,   303,   335,   338,   343,   253,
     407,   408,   409,   410,   342,   423,   298,   351,   352,   368,
     361,   372,   362,   138,   373,   138,   364,   374,   393,   321,
     389,   226,   142,   390,   403,   372,   419,   365,   143,   144,
     145,   146,   147,   418,   420,   240,   240,   402,   428,   148,
      -7,   429,   149,    60,   368,   431,    -7,    -8,   267,    -6,
     150,   218,    -7,    -8,    61,    -6,    -7,    -7,   208,    -8,
     396,    -6,   250,    -8,    -8,    -6,    -6,   240,   240,   240,
     240,     1,     2,     3,     4,     5,     6,     7,     8,     9,
      10,    11,    12,    13,    14,    15,    16,    17,    18,    19,
      20,    21,    22,    23,    24,    62,   -11,    63,   212,   -12,
      25,   404,   -11,    64,   214,   -12,    65,   363,   -11,    66,
      67,   -12,   -11,   -11,   355,   -12,   -12,     0,   255,     0,
      68,    69,    70,    71,    72,    73,    74,    75,    76,    77,
      78,    79,    80,    81,    82,    83,    84,    85,    86,    87,
      88,    89,    90,    91,    92,    93,    94,    95,    96,    97,
      62,    -4,    63,     0,   -13,     0,     0,    -4,    64,     0,
     -13,   105,     0,    -4,    66,    67,   -13,    -4,    -4,     0,
     -13,   -13,     0,     0,     0,    68,    69,    70,    71,    72,
      73,    74,    75,    76,    77,    78,    79,    80,    81,    82,
      83,    84,    85,    86,    87,    88,    89,    90,    91,    92,
      93,    94,    95,    96,    97,    62,   -14,    63,     0,   -15,
       0,     0,   -14,    64,     0,   -15,   108,     0,   -14,    66,
      67,   -15,   -14,   -14,     0,   -15,   -15,     0,     0,     0,
      68,    69,    70,    71,    72,    73,    74,    75,    76,    77,
      78,    79,    80,    81,    82,    83,    84,    85,    86,    87,
      88,    89,    90,    91,    92,    93,    94,    95,    96,    97,
      62,   -37,    63,     0,     0,     0,     0,   -37,    64,     0,
       0,   157,     0,   -37,    66,    67,     0,   -37,   -37,     0,
       0,     0,     0,     0,     0,    68,    69,    70,    71,    72,
      73,    74,    75,    76,    77,    78,    79,    80,    81,    82,
      83,    84,    85,    86,    87,    88,    89,    90,    91,    92,
      93,    94,    95,    96,    97,    62,     0,    63,     0,     0,
       0,     0,     0,    64,     0,     0,   159,     0,     0,    66,
      67,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      68,    69,    70,    71,    72,    73,    74,    75,    76,    77,
      78,    79,    80,    81,    82,    83,    84,    85,    86,    87,
      88,    89,    90,    91,    92,    93,    94,    95,    96,    97,
      62,     0,    63,     0,     0,     0,     0,     0,    64,     0,
       0,   161,     0,     0,    66,    67,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    68,    69,    70,    71,    72,
      73,    74,    75,    76,    77,    78,    79,    80,    81,    82,
      83,    84,    85,    86,    87,    88,    89,    90,    91,    92,
      93,    94,    95,    96,    97,    62,     0,    63,     0,     0,
       0,     0,     0,    64,     0,     0,   232,     0,     0,    66,
      67,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      68,    69,    70,    71,    72,    73,    74,    75,    76,    77,
      78,    79,    80,    81,    82,    83,    84,    85,    86,    87,
      88,    89,    90,    91,    92,    93,    94,    95,    96,    97,
      62,     0,    63,     0,     0,     0,     0,     0,    64,     0,
       0,   233,     0,     0,    66,    67,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    68,    69,    70,    71,    72,
      73,    74,    75,    76,    77,    78,    79,    80,    81,    82,
      83,    84,    85,    86,    87,    88,    89,    90,    91,    92,
      93,    94,    95,    96,    97,    62,     0,    63,     0,     0,
       0,     0,     0,    64,     0,     0,   234,     0,     0,    66,
      67,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      68,    69,    70,    71,    72,    73,    74,    75,    76,    77,
      78,    79,    80,    81,    82,    83,    84,    85,    86,    87,
      88,    89,    90,    91,    92,    93,    94,    95,    96,    97,
      62,     0,    63,     0,     0,     0,     0,     0,    64,     0,
       0,   293,     0,     0,    66,    67,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    68,    69,    70,    71,    72,
      73,    74,    75,    76,    77,    78,    79,    80,    81,    82,
      83,    84,    85,    86,    87,    88,    89,    90,    91,    92,
      93,    94,    95,    96,    97,    62,     0,    63,     0,     0,
       0,     0,     0,    64,     0,     0,   344,     0,     0,    66,
      67,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      68,    69,    70,    71,    72,    73,    74,    75,    76,    77,
      78,    79,    80,    81,    82,    83,    84,    85,    86,    87,
      88,    89,    90,    91,    92,    93,    94,    95,    96,    97,
      62,     0,    63,     0,     0,     0,     0,   324,    64,     0,
       0,     0,     0,     0,    66,    67,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   116,   117,   118,   119,    72,
     120,   121,   122,   123,   124,   125,   126,    80,   127,   128,
      83,     0,   129,   130,   131,   132,   133,   134,   135,    92,
      93,    94,    95,    96,   195,    62,     0,    63,     0,     0,
       0,     0,   422,    64,     0,     0,     0,     0,     0,    66,
      67,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     116,   117,   118,   119,    72,   120,   121,   122,   123,   124,
     125,   126,    80,   127,   128,    83,     0,   129,   130,   131,
     132,   133,   134,   135,    92,    93,    94,    95,    96,   195,
      62,     0,    63,     0,     0,     0,     0,     0,    64,     0,
       0,     0,     0,     0,    66,    67,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   116,   117,   118,   119,    72,
     120,   121,   122,   123,   124,   125,   126,    80,   127,   128,
      83,     0,   129,   130,   131,   132,   133,   134,   135,    92,
      93,    94,    95,    96,   195,    62,     0,    63,     0,     0,
       0,     0,     0,    64,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     116,   117,   118,   119,    72,   120,   121,   122,   123,   124,
     125,   126,    80,   127,   128,    83,     0,   129,   130,   131,
     132,   133,   134,   135,    92,    93,    94,    95,    96,   195,
     115,     0,     0,     0,     0,     0,     0,     0,     0,   291,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   116,   117,   118,   119,    72,   120,   121,
     122,   123,   124,   125,   126,    80,   127,   128,    83,   115,
     129,   130,   131,   132,   133,   134,   135,     0,   347,     0,
      95,   136,   137,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   116,   117,   118,   119,    72,   120,   121,   122,
     123,   124,   125,   126,    80,   127,   128,    83,   115,   129,
     130,   131,   132,   133,   134,   135,     0,   349,     0,    95,
     136,   137,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   116,   117,   118,   119,    72,   120,   121,   122,   123,
     124,   125,   126,    80,   127,   128,    83,   115,   129,   130,
     131,   132,   133,   134,   135,     0,   384,     0,    95,   136,
     137,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     116,   117,   118,   119,    72,   120,   121,   122,   123,   124,
     125,   126,    80,   127,   128,    83,   115,   129,   130,   131,
     132,   133,   134,   135,     0,   412,     0,    95,   136,   137,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   116,
     117,   118,   119,    72,   120,   121,   122,   123,   124,   125,
     126,    80,   127,   128,    83,   115,   129,   130,   131,   132,
     133,   134,   135,     0,   413,     0,    95,   136,   137,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   116,   117,
     118,   119,    72,   120,   121,   122,   123,   124,   125,   126,
      80,   127,   128,    83,   115,   129,   130,   131,   132,   133,
     134,   135,     0,     0,     0,    95,   136,   137,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   116,   117,   118,
     119,    72,   120,   121,   122,   123,   124,   125,   126,    80,
     127,   128,    83,     0,   129,   130,   131,   132,   133,   134,
     135,     0,   306,     0,    95,   136,   137,   167,     0,     0,
       0,     0,     0,   307,     0,     0,     0,     0,     0,   112,
       2,     3,     4,     0,     6,     7,     8,     9,    10,    11,
      12,     0,    14,    15,     0,     0,   308,    19,    20,    21,
      22,    23,    24,     0,   166,     0,     0,   309,    25,   167,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   112,     2,     3,     4,     0,     6,     7,     8,     9,
      10,    11,    12,     0,    14,    15,     0,     0,     0,    19,
      20,    21,    22,    23,    24,     0,   173,     0,     0,   168,
      25,   167,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   112,     2,     3,     4,     0,     6,     7,
       8,     9,    10,    11,    12,     0,    14,    15,     0,     0,
       0,    19,    20,    21,    22,    23,    24,     0,   173,     0,
       0,   174,    25,   167,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     1,     2,     3,     4,     0,
       6,     7,     8,     9,    10,    11,    12,     0,    14,    15,
       0,     0,     0,    19,    20,    21,    22,    23,    24,     0,
     365,     0,     0,   174,    25,   167,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   366,     2,     3,
       4,     0,     6,     7,     8,     9,    10,    11,    12,     0,
      14,    15,   301,     0,     0,    19,    20,    21,    22,    23,
      24,     0,     0,     0,     0,   367,    25,   226,   142,     0,
       0,     0,     0,     0,   143,   144,   145,   146,   147,     0,
       0,     0,     0,   237,     0,   148,     0,     0,   149,     0,
       0,     0,     0,     0,     0,     0,   150,     1,     2,     3,
       4,     0,     6,     7,     8,     9,    10,    11,    12,     0,
      14,    15,     0,   238,   239,    19,    20,    21,    22,    23,
      24,   264,     0,     0,     0,     0,    25,     0,     0,     0,
       0,     0,     0,     0,     0,     1,     2,     3,     4,     0,
       6,     7,     8,     9,    10,    11,    12,     0,    14,    15,
       0,   238,   239,    19,    20,    21,    22,    23,    24,     0,
     111,     0,     0,     0,    25,   112,     2,     3,     4,     0,
       6,     7,     8,     9,    10,    11,    12,     0,    14,    15,
       0,     0,   113,    19,    20,    21,    22,    23,    24,     0,
       0,     0,     0,     0,    25,     1,     2,     3,     4,     5,
       6,     7,     8,     9,    10,    11,    12,    13,    14,    15,
      16,    17,    18,    19,    20,    21,    22,    23,    24,     0,
     112,     2,     3,     4,    25,     6,     7,     8,     9,    10,
      11,    12,     0,    14,    15,     0,     0,   207,    19,    20,
      21,    22,    23,    24,     0,   319,     2,     3,     4,    25,
       6,     7,     8,     9,    10,    11,    12,     0,    14,    15,
       0,     0,     0,    19,    20,    21,    22,    23,    24,     0,
       0,     0,     0,   320,    25,     1,     2,     3,     4,     0,
       6,     7,     8,     9,    10,    11,    12,     0,    14,    15,
       0,     0,     0,    19,    20,    21,    22,    23,    24,     0,
     112,     2,     3,     4,    25,     6,     7,     8,     9,    10,
      11,    12,     0,    14,    15,     0,     0,     0,    19,    20,
      21,    22,    23,    24,   141,   142,     0,     0,     0,    25,
       0,   143,   144,   145,   146,   147,     0,     0,     0,     0,
       0,     0,   148,     0,     0,   149,     0,     0,     0,     0,
       0,     0,     0,   150
};

static const yytype_int16 yycheck[] =
{
       0,    52,    34,    36,   200,   166,    64,   113,   260,   220,
     221,   263,   103,    31,   223,    33,   107,    17,    18,   110,
      52,    53,    59,   173,    42,    43,    26,    45,   153,   337,
     155,    11,   151,    11,    11,    11,    16,    11,    16,    16,
      56,    57,    22,    14,    11,    11,   381,   193,    23,    16,
      13,    16,     9,    14,    13,   365,    27,    21,    15,    22,
      19,    13,    26,    28,    14,    13,    27,   158,    25,   160,
     102,   162,   218,    14,   285,    13,    56,    27,    56,    56,
      56,   416,    56,   391,    84,    85,    27,   248,   297,    56,
      56,   300,   402,    56,    57,   201,    21,    56,    57,    16,
     225,   207,    27,   253,    56,    57,    14,    13,   304,   215,
     229,    28,   231,   113,    23,   166,   167,    14,    27,    27,
     153,    23,   155,   375,   376,    27,   163,   164,    13,    13,
      27,   342,    13,    13,     9,    19,    13,   346,    13,    13,
      15,    22,    22,    13,   202,   182,    21,   184,   206,   200,
      25,    26,    23,    13,     9,   407,   408,   409,   410,    19,
      15,   219,   220,   221,    23,   165,    21,    23,   200,   201,
      25,    26,    21,   298,   280,    21,   301,   386,    27,   388,
      23,    27,    11,   215,    27,   185,   154,    16,   156,   240,
     223,   249,   225,    56,    57,   246,   254,   248,    13,   305,
      23,    26,   308,   294,    27,   205,   224,   207,   240,     7,
       8,    13,    23,    28,    29,   247,    27,     6,     7,     8,
      35,    36,    37,    38,    39,     4,    23,   285,     7,     8,
      27,    46,    26,    23,    49,   235,   236,    27,   238,   239,
     256,   257,    57,    23,    56,    57,   278,    27,   280,   307,
      23,   357,    26,   304,    27,   306,     6,     7,     8,    20,
     260,    56,    57,   263,   297,   298,     9,   300,   301,     9,
       9,   322,   304,   305,    56,    57,    15,     6,     7,     8,
      56,    57,    21,     9,   342,   343,    25,    26,    20,    15,
     322,    12,   329,   330,    12,    21,     6,     7,     8,    25,
      26,    66,    67,   361,   362,   337,   364,    23,   308,   360,
      55,     9,    26,   346,   365,   331,   332,    15,   334,   335,
      47,    48,    12,    21,    13,   357,    20,    25,    26,    20,
     381,   389,   390,    20,   235,   236,    20,    10,    24,    27,
     377,   378,   379,   380,    26,   403,    13,    55,    55,   381,
      22,   402,     9,   386,    10,   388,    11,    10,    12,   391,
      11,    28,    29,    11,     9,   416,    12,    11,    35,    36,
      37,    38,    39,    10,    12,   375,   376,    27,    12,    46,
       9,    12,    49,     0,   416,    10,    15,     9,   188,     9,
      57,   115,    21,    15,    26,    15,    25,    26,   103,    21,
     360,    21,   172,    25,    26,    25,    26,   407,   408,   409,
     410,    28,    29,    30,    31,    32,    33,    34,    35,    36,
      37,    38,    39,    40,    41,    42,    43,    44,    45,    46,
      47,    48,    49,    50,    51,     3,     9,     5,   107,     9,
      57,   372,    15,    11,   110,    15,    14,   314,    21,    17,
      18,    21,    25,    26,   306,    25,    26,    -1,   178,    -1,
      28,    29,    30,    31,    32,    33,    34,    35,    36,    37,
      38,    39,    40,    41,    42,    43,    44,    45,    46,    47,
      48,    49,    50,    51,    52,    53,    54,    55,    56,    57,
       3,     9,     5,    -1,     9,    -1,    -1,    15,    11,    -1,
      15,    14,    -1,    21,    17,    18,    21,    25,    26,    -1,
      25,    26,    -1,    -1,    -1,    28,    29,    30,    31,    32,
      33,    34,    35,    36,    37,    38,    39,    40,    41,    42,
      43,    44,    45,    46,    47,    48,    49,    50,    51,    52,
      53,    54,    55,    56,    57,     3,     9,     5,    -1,     9,
      -1,    -1,    15,    11,    -1,    15,    14,    -1,    21,    17,
      18,    21,    25,    26,    -1,    25,    26,    -1,    -1,    -1,
      28,    29,    30,    31,    32,    33,    34,    35,    36,    37,
      38,    39,    40,    41,    42,    43,    44,    45,    46,    47,
      48,    49,    50,    51,    52,    53,    54,    55,    56,    57,
       3,     9,     5,    -1,    -1,    -1,    -1,    15,    11,    -1,
      -1,    14,    -1,    21,    17,    18,    -1,    25,    26,    -1,
      -1,    -1,    -1,    -1,    -1,    28,    29,    30,    31,    32,
      33,    34,    35,    36,    37,    38,    39,    40,    41,    42,
      43,    44,    45,    46,    47,    48,    49,    50,    51,    52,
      53,    54,    55,    56,    57,     3,    -1,     5,    -1,    -1,
      -1,    -1,    -1,    11,    -1,    -1,    14,    -1,    -1,    17,
      18,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      28,    29,    30,    31,    32,    33,    34,    35,    36,    37,
      38,    39,    40,    41,    42,    43,    44,    45,    46,    47,
      48,    49,    50,    51,    52,    53,    54,    55,    56,    57,
       3,    -1,     5,    -1,    -1,    -1,    -1,    -1,    11,    -1,
      -1,    14,    -1,    -1,    17,    18,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    28,    29,    30,    31,    32,
      33,    34,    35,    36,    37,    38,    39,    40,    41,    42,
      43,    44,    45,    46,    47,    48,    49,    50,    51,    52,
      53,    54,    55,    56,    57,     3,    -1,     5,    -1,    -1,
      -1,    -1,    -1,    11,    -1,    -1,    14,    -1,    -1,    17,
      18,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      28,    29,    30,    31,    32,    33,    34,    35,    36,    37,
      38,    39,    40,    41,    42,    43,    44,    45,    46,    47,
      48,    49,    50,    51,    52,    53,    54,    55,    56,    57,
       3,    -1,     5,    -1,    -1,    -1,    -1,    -1,    11,    -1,
      -1,    14,    -1,    -1,    17,    18,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    28,    29,    30,    31,    32,
      33,    34,    35,    36,    37,    38,    39,    40,    41,    42,
      43,    44,    45,    46,    47,    48,    49,    50,    51,    52,
      53,    54,    55,    56,    57,     3,    -1,     5,    -1,    -1,
      -1,    -1,    -1,    11,    -1,    -1,    14,    -1,    -1,    17,
      18,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      28,    29,    30,    31,    32,    33,    34,    35,    36,    37,
      38,    39,    40,    41,    42,    43,    44,    45,    46,    47,
      48,    49,    50,    51,    52,    53,    54,    55,    56,    57,
       3,    -1,     5,    -1,    -1,    -1,    -1,    -1,    11,    -1,
      -1,    14,    -1,    -1,    17,    18,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    28,    29,    30,    31,    32,
      33,    34,    35,    36,    37,    38,    39,    40,    41,    42,
      43,    44,    45,    46,    47,    48,    49,    50,    51,    52,
      53,    54,    55,    56,    57,     3,    -1,     5,    -1,    -1,
      -1,    -1,    -1,    11,    -1,    -1,    14,    -1,    -1,    17,
      18,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      28,    29,    30,    31,    32,    33,    34,    35,    36,    37,
      38,    39,    40,    41,    42,    43,    44,    45,    46,    47,
      48,    49,    50,    51,    52,    53,    54,    55,    56,    57,
       3,    -1,     5,    -1,    -1,    -1,    -1,    10,    11,    -1,
      -1,    -1,    -1,    -1,    17,    18,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    28,    29,    30,    31,    32,
      33,    34,    35,    36,    37,    38,    39,    40,    41,    42,
      43,    -1,    45,    46,    47,    48,    49,    50,    51,    52,
      53,    54,    55,    56,    57,     3,    -1,     5,    -1,    -1,
      -1,    -1,    10,    11,    -1,    -1,    -1,    -1,    -1,    17,
      18,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      28,    29,    30,    31,    32,    33,    34,    35,    36,    37,
      38,    39,    40,    41,    42,    43,    -1,    45,    46,    47,
      48,    49,    50,    51,    52,    53,    54,    55,    56,    57,
       3,    -1,     5,    -1,    -1,    -1,    -1,    -1,    11,    -1,
      -1,    -1,    -1,    -1,    17,    18,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    28,    29,    30,    31,    32,
      33,    34,    35,    36,    37,    38,    39,    40,    41,    42,
      43,    -1,    45,    46,    47,    48,    49,    50,    51,    52,
      53,    54,    55,    56,    57,     3,    -1,     5,    -1,    -1,
      -1,    -1,    -1,    11,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      28,    29,    30,    31,    32,    33,    34,    35,    36,    37,
      38,    39,    40,    41,    42,    43,    -1,    45,    46,    47,
      48,    49,    50,    51,    52,    53,    54,    55,    56,    57,
       5,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    14,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    28,    29,    30,    31,    32,    33,    34,
      35,    36,    37,    38,    39,    40,    41,    42,    43,     5,
      45,    46,    47,    48,    49,    50,    51,    -1,    14,    -1,
      55,    56,    57,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    28,    29,    30,    31,    32,    33,    34,    35,
      36,    37,    38,    39,    40,    41,    42,    43,     5,    45,
      46,    47,    48,    49,    50,    51,    -1,    14,    -1,    55,
      56,    57,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    28,    29,    30,    31,    32,    33,    34,    35,    36,
      37,    38,    39,    40,    41,    42,    43,     5,    45,    46,
      47,    48,    49,    50,    51,    -1,    14,    -1,    55,    56,
      57,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      28,    29,    30,    31,    32,    33,    34,    35,    36,    37,
      38,    39,    40,    41,    42,    43,     5,    45,    46,    47,
      48,    49,    50,    51,    -1,    14,    -1,    55,    56,    57,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    28,
      29,    30,    31,    32,    33,    34,    35,    36,    37,    38,
      39,    40,    41,    42,    43,     5,    45,    46,    47,    48,
      49,    50,    51,    -1,    14,    -1,    55,    56,    57,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    28,    29,
      30,    31,    32,    33,    34,    35,    36,    37,    38,    39,
      40,    41,    42,    43,     5,    45,    46,    47,    48,    49,
      50,    51,    -1,    -1,    -1,    55,    56,    57,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    28,    29,    30,
      31,    32,    33,    34,    35,    36,    37,    38,    39,    40,
      41,    42,    43,    -1,    45,    46,    47,    48,    49,    50,
      51,    -1,    11,    -1,    55,    56,    57,    16,    -1,    -1,
      -1,    -1,    -1,    22,    -1,    -1,    -1,    -1,    -1,    28,
      29,    30,    31,    -1,    33,    34,    35,    36,    37,    38,
      39,    -1,    41,    42,    -1,    -1,    45,    46,    47,    48,
      49,    50,    51,    -1,    11,    -1,    -1,    56,    57,    16,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    28,    29,    30,    31,    -1,    33,    34,    35,    36,
      37,    38,    39,    -1,    41,    42,    -1,    -1,    -1,    46,
      47,    48,    49,    50,    51,    -1,    11,    -1,    -1,    56,
      57,    16,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    28,    29,    30,    31,    -1,    33,    34,
      35,    36,    37,    38,    39,    -1,    41,    42,    -1,    -1,
      -1,    46,    47,    48,    49,    50,    51,    -1,    11,    -1,
      -1,    56,    57,    16,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    28,    29,    30,    31,    -1,
      33,    34,    35,    36,    37,    38,    39,    -1,    41,    42,
      -1,    -1,    -1,    46,    47,    48,    49,    50,    51,    -1,
      11,    -1,    -1,    56,    57,    16,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    28,    29,    30,
      31,    -1,    33,    34,    35,    36,    37,    38,    39,    -1,
      41,    42,    13,    -1,    -1,    46,    47,    48,    49,    50,
      51,    -1,    -1,    -1,    -1,    56,    57,    28,    29,    -1,
      -1,    -1,    -1,    -1,    35,    36,    37,    38,    39,    -1,
      -1,    -1,    -1,    14,    -1,    46,    -1,    -1,    49,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    57,    28,    29,    30,
      31,    -1,    33,    34,    35,    36,    37,    38,    39,    -1,
      41,    42,    -1,    44,    45,    46,    47,    48,    49,    50,
      51,    14,    -1,    -1,    -1,    -1,    57,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    28,    29,    30,    31,    -1,
      33,    34,    35,    36,    37,    38,    39,    -1,    41,    42,
      -1,    44,    45,    46,    47,    48,    49,    50,    51,    -1,
      23,    -1,    -1,    -1,    57,    28,    29,    30,    31,    -1,
      33,    34,    35,    36,    37,    38,    39,    -1,    41,    42,
      -1,    -1,    45,    46,    47,    48,    49,    50,    51,    -1,
      -1,    -1,    -1,    -1,    57,    28,    29,    30,    31,    32,
      33,    34,    35,    36,    37,    38,    39,    40,    41,    42,
      43,    44,    45,    46,    47,    48,    49,    50,    51,    -1,
      28,    29,    30,    31,    57,    33,    34,    35,    36,    37,
      38,    39,    -1,    41,    42,    -1,    -1,    45,    46,    47,
      48,    49,    50,    51,    -1,    28,    29,    30,    31,    57,
      33,    34,    35,    36,    37,    38,    39,    -1,    41,    42,
      -1,    -1,    -1,    46,    47,    48,    49,    50,    51,    -1,
      -1,    -1,    -1,    56,    57,    28,    29,    30,    31,    -1,
      33,    34,    35,    36,    37,    38,    39,    -1,    41,    42,
      -1,    -1,    -1,    46,    47,    48,    49,    50,    51,    -1,
      28,    29,    30,    31,    57,    33,    34,    35,    36,    37,
      38,    39,    -1,    41,    42,    -1,    -1,    -1,    46,    47,
      48,    49,    50,    51,    28,    29,    -1,    -1,    -1,    57,
      -1,    35,    36,    37,    38,    39,    -1,    -1,    -1,    -1,
      -1,    -1,    46,    -1,    -1,    49,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    57
};

/* YYSTOS[STATE-NUM] -- The (internal number of the) accessing
   symbol of state STATE-NUM.  */
static const yytype_uint8 yystos[] =
{
       0,    28,    29,    30,    31,    32,    33,    34,    35,    36,
      37,    38,    39,    40,    41,    42,    43,    44,    45,    46,
      47,    48,    49,    50,    51,    57,    60,    69,    70,    71,
      73,    74,    76,    77,    80,    83,    13,    22,    56,    57,
      90,    13,    13,    13,    13,    13,    13,    56,    57,    84,
      85,    13,    80,    80,    13,    19,    56,    57,    87,    88,
       0,    69,     3,     5,    11,    14,    17,    18,    28,    29,
      30,    31,    32,    33,    34,    35,    36,    37,    38,    39,
      40,    41,    42,    43,    44,    45,    46,    47,    48,    49,
      50,    51,    52,    53,    54,    55,    56,    57,    61,    66,
      67,    72,    80,   110,   111,    14,    75,   110,    14,    78,
     110,    23,    28,    45,    83,     5,    28,    29,    30,    31,
      33,    34,    35,    36,    37,    38,    39,    41,    42,    45,
      46,    47,    48,    49,    50,    51,    56,    57,    61,    96,
      97,    28,    29,    35,    36,    37,    38,    39,    46,    49,
      57,    79,    82,    13,    22,    13,    22,    14,   110,    14,
     110,    14,   110,    85,    85,    91,    11,    16,    56,    98,
      99,   100,   108,    11,    56,    81,   106,   107,   108,    56,
      57,    19,    88,    19,    88,    91,     7,     8,    62,    63,
       6,     7,     8,    64,    65,    57,    67,    23,    66,    66,
      80,    80,     9,    15,    25,    21,    26,    45,    72,   111,
      23,    23,    75,    23,    78,    80,    81,     6,    64,    26,
      26,    26,    14,    27,    13,    13,    28,    82,    96,    79,
      96,    79,    14,    14,    14,    91,    91,    14,    44,    45,
      80,    86,    92,    99,    28,   108,   109,    21,    27,     9,
     100,   106,    23,    27,     9,   107,    20,    20,    56,    57,
      91,    56,    57,    91,    14,    89,     4,    63,     6,    65,
      12,    98,    81,    67,    56,    57,    56,    57,    80,    67,
      80,    81,    23,    81,    23,    26,     6,    67,    68,    68,
      68,    14,    97,    14,   110,    96,    14,    27,    13,    14,
      27,    13,    86,    86,    80,    80,    11,    22,    45,    56,
      94,    95,   104,   105,   108,    55,    12,    28,   108,    28,
      56,    83,    93,    99,    10,    67,    12,   106,    67,    88,
      88,    20,    20,    89,    20,    20,    89,    21,    10,    81,
      23,    68,    26,    24,    14,    14,    27,    14,    96,    14,
      96,    55,    55,    98,    81,   104,    67,    80,    81,    23,
      27,    22,     9,   105,    11,    11,    28,    56,    83,   101,
     102,   103,   108,    10,    10,    91,    91,    88,    88,    88,
      88,    93,    68,    67,    14,    14,    27,    14,    27,    11,
      11,    21,    23,    12,    81,    23,    95,    67,    67,    67,
     102,    23,    27,     9,   103,    89,    89,    91,    91,    91,
      91,   101,    14,    14,    67,    67,    93,    23,    10,    12,
      12,   102,    10,    67,    89,    89,    89,    89,    12,    12,
     101,    10,    23
};

#define yyerrok		(yyerrstatus = 0)
#define yyclearin	(yychar = YYEMPTY)
#define YYEMPTY		(-2)
#define YYEOF		0

#define YYACCEPT	goto yyacceptlab
#define YYABORT		goto yyabortlab
#define YYERROR		goto yyerrorlab


/* Like YYERROR except do call yyerror.  This remains here temporarily
   to ease the transition to the new meaning of YYERROR, for GCC.
   Once GCC version 2 has supplanted version 1, this can go.  */

#define YYFAIL		goto yyerrlab

#define YYRECOVERING()  (!!yyerrstatus)

#define YYBACKUP(Token, Value)					\
do								\
  if (yychar == YYEMPTY && yylen == 1)				\
    {								\
      yychar = (Token);						\
      yylval = (Value);						\
      yytoken = YYTRANSLATE (yychar);				\
      YYPOPSTACK (1);						\
      goto yybackup;						\
    }								\
  else								\
    {								\
      yyerror (scanner, YY_("syntax error: cannot back up")); \
      YYERROR;							\
    }								\
while (YYID (0))


#define YYTERROR	1
#define YYERRCODE	256


/* YYLLOC_DEFAULT -- Set CURRENT to span from RHS[1] to RHS[N].
   If N is 0, then set CURRENT to the empty location which ends
   the previous symbol: RHS[0] (always defined).  */

#define YYRHSLOC(Rhs, K) ((Rhs)[K])
#ifndef YYLLOC_DEFAULT
# define YYLLOC_DEFAULT(Current, Rhs, N)				\
    do									\
      if (YYID (N))                                                    \
	{								\
	  (Current).first_line   = YYRHSLOC (Rhs, 1).first_line;	\
	  (Current).first_column = YYRHSLOC (Rhs, 1).first_column;	\
	  (Current).last_line    = YYRHSLOC (Rhs, N).last_line;		\
	  (Current).last_column  = YYRHSLOC (Rhs, N).last_column;	\
	}								\
      else								\
	{								\
	  (Current).first_line   = (Current).last_line   =		\
	    YYRHSLOC (Rhs, 0).last_line;				\
	  (Current).first_column = (Current).last_column =		\
	    YYRHSLOC (Rhs, 0).last_column;				\
	}								\
    while (YYID (0))
#endif


/* YY_LOCATION_PRINT -- Print the location on the stream.
   This macro was not mandated originally: define only if we know
   we won't break user code: when these are the locations we know.  */

#ifndef YY_LOCATION_PRINT
# if YYLTYPE_IS_TRIVIAL
#  define YY_LOCATION_PRINT(File, Loc)			\
     fprintf (File, "%d.%d-%d.%d",			\
	      (Loc).first_line, (Loc).first_column,	\
	      (Loc).last_line,  (Loc).last_column)
# else
#  define YY_LOCATION_PRINT(File, Loc) ((void) 0)
# endif
#endif


/* YYLEX -- calling `yylex' with the right arguments.  */

#ifdef YYLEX_PARAM
# define YYLEX yylex (&yylval, YYLEX_PARAM)
#else
# define YYLEX yylex (&yylval, scanner)
#endif

/* Enable debugging if requested.  */
#if YYDEBUG

# ifndef YYFPRINTF
#  include <stdio.h> /* INFRINGES ON USER NAME SPACE */
#  define YYFPRINTF fprintf
# endif

# define YYDPRINTF(Args)			\
do {						\
  if (yydebug)					\
    YYFPRINTF Args;				\
} while (YYID (0))

# define YY_SYMBOL_PRINT(Title, Type, Value, Location)			  \
do {									  \
  if (yydebug)								  \
    {									  \
      YYFPRINTF (stderr, "%s ", Title);					  \
      yy_symbol_print (stderr,						  \
		  Type, Value, scanner); \
      YYFPRINTF (stderr, "\n");						  \
    }									  \
} while (YYID (0))


/*--------------------------------.
| Print this symbol on YYOUTPUT.  |
`--------------------------------*/

/*ARGSUSED*/
#if (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
static void
yy_symbol_value_print (FILE *yyoutput, int yytype, YYSTYPE const * const yyvaluep, struct ctf_scanner *scanner)
#else
static void
yy_symbol_value_print (yyoutput, yytype, yyvaluep, scanner)
    FILE *yyoutput;
    int yytype;
    YYSTYPE const * const yyvaluep;
    struct ctf_scanner *scanner;
#endif
{
  if (!yyvaluep)
    return;
  YYUSE (scanner);
# ifdef YYPRINT
  if (yytype < YYNTOKENS)
    YYPRINT (yyoutput, yytoknum[yytype], *yyvaluep);
# else
  YYUSE (yyoutput);
# endif
  switch (yytype)
    {
      default:
	break;
    }
}


/*--------------------------------.
| Print this symbol on YYOUTPUT.  |
`--------------------------------*/

#if (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
static void
yy_symbol_print (FILE *yyoutput, int yytype, YYSTYPE const * const yyvaluep, struct ctf_scanner *scanner)
#else
static void
yy_symbol_print (yyoutput, yytype, yyvaluep, scanner)
    FILE *yyoutput;
    int yytype;
    YYSTYPE const * const yyvaluep;
    struct ctf_scanner *scanner;
#endif
{
  if (yytype < YYNTOKENS)
    YYFPRINTF (yyoutput, "token %s (", yytname[yytype]);
  else
    YYFPRINTF (yyoutput, "nterm %s (", yytname[yytype]);

  yy_symbol_value_print (yyoutput, yytype, yyvaluep, scanner);
  YYFPRINTF (yyoutput, ")");
}

/*------------------------------------------------------------------.
| yy_stack_print -- Print the state stack from its BOTTOM up to its |
| TOP (included).                                                   |
`------------------------------------------------------------------*/

#if (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
static void
yy_stack_print (yytype_int16 *yybottom, yytype_int16 *yytop)
#else
static void
yy_stack_print (yybottom, yytop)
    yytype_int16 *yybottom;
    yytype_int16 *yytop;
#endif
{
  YYFPRINTF (stderr, "Stack now");
  for (; yybottom <= yytop; yybottom++)
    {
      int yybot = *yybottom;
      YYFPRINTF (stderr, " %d", yybot);
    }
  YYFPRINTF (stderr, "\n");
}

# define YY_STACK_PRINT(Bottom, Top)				\
do {								\
  if (yydebug)							\
    yy_stack_print ((Bottom), (Top));				\
} while (YYID (0))


/*------------------------------------------------.
| Report that the YYRULE is going to be reduced.  |
`------------------------------------------------*/

#if (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
static void
yy_reduce_print (YYSTYPE *yyvsp, int yyrule, struct ctf_scanner *scanner)
#else
static void
yy_reduce_print (yyvsp, yyrule, scanner)
    YYSTYPE *yyvsp;
    int yyrule;
    struct ctf_scanner *scanner;
#endif
{
  int yynrhs = yyr2[yyrule];
  int yyi;
  unsigned long int yylno = yyrline[yyrule];
  YYFPRINTF (stderr, "Reducing stack by rule %d (line %lu):\n",
	     yyrule - 1, yylno);
  /* The symbols being reduced.  */
  for (yyi = 0; yyi < yynrhs; yyi++)
    {
      YYFPRINTF (stderr, "   $%d = ", yyi + 1);
      yy_symbol_print (stderr, yyrhs[yyprhs[yyrule] + yyi],
		       &(yyvsp[(yyi + 1) - (yynrhs)])
		       		       , scanner);
      YYFPRINTF (stderr, "\n");
    }
}

# define YY_REDUCE_PRINT(Rule)		\
do {					\
  if (yydebug)				\
    yy_reduce_print (yyvsp, Rule, scanner); \
} while (YYID (0))

/* Nonzero means print parse trace.  It is left uninitialized so that
   multiple parsers can coexist.  */
int yydebug;
#else /* !YYDEBUG */
# define YYDPRINTF(Args)
# define YY_SYMBOL_PRINT(Title, Type, Value, Location)
# define YY_STACK_PRINT(Bottom, Top)
# define YY_REDUCE_PRINT(Rule)
#endif /* !YYDEBUG */


/* YYINITDEPTH -- initial size of the parser's stacks.  */
#ifndef	YYINITDEPTH
# define YYINITDEPTH 200
#endif

/* YYMAXDEPTH -- maximum size the stacks can grow to (effective only
   if the built-in stack extension method is used).

   Do not make this value too large; the results are undefined if
   YYSTACK_ALLOC_MAXIMUM < YYSTACK_BYTES (YYMAXDEPTH)
   evaluated with infinite-precision integer arithmetic.  */

#ifndef YYMAXDEPTH
# define YYMAXDEPTH 10000
#endif



#if YYERROR_VERBOSE

# ifndef yystrlen
#  if defined __GLIBC__ && defined _STRING_H
#   define yystrlen strlen
#  else
/* Return the length of YYSTR.  */
#if (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
static YYSIZE_T
yystrlen (const char *yystr)
#else
static YYSIZE_T
yystrlen (yystr)
    const char *yystr;
#endif
{
  YYSIZE_T yylen;
  for (yylen = 0; yystr[yylen]; yylen++)
    continue;
  return yylen;
}
#  endif
# endif

# ifndef yystpcpy
#  if defined __GLIBC__ && defined _STRING_H && defined _GNU_SOURCE
#   define yystpcpy stpcpy
#  else
/* Copy YYSRC to YYDEST, returning the address of the terminating '\0' in
   YYDEST.  */
#if (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
static char *
yystpcpy (char *yydest, const char *yysrc)
#else
static char *
yystpcpy (yydest, yysrc)
    char *yydest;
    const char *yysrc;
#endif
{
  char *yyd = yydest;
  const char *yys = yysrc;

  while ((*yyd++ = *yys++) != '\0')
    continue;

  return yyd - 1;
}
#  endif
# endif

# ifndef yytnamerr
/* Copy to YYRES the contents of YYSTR after stripping away unnecessary
   quotes and backslashes, so that it's suitable for yyerror.  The
   heuristic is that double-quoting is unnecessary unless the string
   contains an apostrophe, a comma, or backslash (other than
   backslash-backslash).  YYSTR is taken from yytname.  If YYRES is
   null, do not copy; instead, return the length of what the result
   would have been.  */
static YYSIZE_T
yytnamerr (char *yyres, const char *yystr)
{
  if (*yystr == '"')
    {
      YYSIZE_T yyn = 0;
      char const *yyp = yystr;

      for (;;)
	switch (*++yyp)
	  {
	  case '\'':
	  case ',':
	    goto do_not_strip_quotes;

	  case '\\':
	    if (*++yyp != '\\')
	      goto do_not_strip_quotes;
	    /* Fall through.  */
	  default:
	    if (yyres)
	      yyres[yyn] = *yyp;
	    yyn++;
	    break;

	  case '"':
	    if (yyres)
	      yyres[yyn] = '\0';
	    return yyn;
	  }
    do_not_strip_quotes: ;
    }

  if (! yyres)
    return yystrlen (yystr);

  return yystpcpy (yyres, yystr) - yyres;
}
# endif

/* Copy into YYRESULT an error message about the unexpected token
   YYCHAR while in state YYSTATE.  Return the number of bytes copied,
   including the terminating null byte.  If YYRESULT is null, do not
   copy anything; just return the number of bytes that would be
   copied.  As a special case, return 0 if an ordinary "syntax error"
   message will do.  Return YYSIZE_MAXIMUM if overflow occurs during
   size calculation.  */
static YYSIZE_T
yysyntax_error (char *yyresult, int yystate, int yychar)
{
  int yyn = yypact[yystate];

  if (! (YYPACT_NINF < yyn && yyn <= YYLAST))
    return 0;
  else
    {
      int yytype = YYTRANSLATE (yychar);
      YYSIZE_T yysize0 = yytnamerr (0, yytname[yytype]);
      YYSIZE_T yysize = yysize0;
      YYSIZE_T yysize1;
      int yysize_overflow = 0;
      enum { YYERROR_VERBOSE_ARGS_MAXIMUM = 5 };
      char const *yyarg[YYERROR_VERBOSE_ARGS_MAXIMUM];
      int yyx;

# if 0
      /* This is so xgettext sees the translatable formats that are
	 constructed on the fly.  */
      YY_("syntax error, unexpected %s");
      YY_("syntax error, unexpected %s, expecting %s");
      YY_("syntax error, unexpected %s, expecting %s or %s");
      YY_("syntax error, unexpected %s, expecting %s or %s or %s");
      YY_("syntax error, unexpected %s, expecting %s or %s or %s or %s");
# endif
      char *yyfmt;
      char const *yyf;
      static char const yyunexpected[] = "syntax error, unexpected %s";
      static char const yyexpecting[] = ", expecting %s";
      static char const yyor[] = " or %s";
      char yyformat[sizeof yyunexpected
		    + sizeof yyexpecting - 1
		    + ((YYERROR_VERBOSE_ARGS_MAXIMUM - 2)
		       * (sizeof yyor - 1))];
      char const *yyprefix = yyexpecting;

      /* Start YYX at -YYN if negative to avoid negative indexes in
	 YYCHECK.  */
      int yyxbegin = yyn < 0 ? -yyn : 0;

      /* Stay within bounds of both yycheck and yytname.  */
      int yychecklim = YYLAST - yyn + 1;
      int yyxend = yychecklim < YYNTOKENS ? yychecklim : YYNTOKENS;
      int yycount = 1;

      yyarg[0] = yytname[yytype];
      yyfmt = yystpcpy (yyformat, yyunexpected);

      for (yyx = yyxbegin; yyx < yyxend; ++yyx)
	if (yycheck[yyx + yyn] == yyx && yyx != YYTERROR)
	  {
	    if (yycount == YYERROR_VERBOSE_ARGS_MAXIMUM)
	      {
		yycount = 1;
		yysize = yysize0;
		yyformat[sizeof yyunexpected - 1] = '\0';
		break;
	      }
	    yyarg[yycount++] = yytname[yyx];
	    yysize1 = yysize + yytnamerr (0, yytname[yyx]);
	    yysize_overflow |= (yysize1 < yysize);
	    yysize = yysize1;
	    yyfmt = yystpcpy (yyfmt, yyprefix);
	    yyprefix = yyor;
	  }

      yyf = YY_(yyformat);
      yysize1 = yysize + yystrlen (yyf);
      yysize_overflow |= (yysize1 < yysize);
      yysize = yysize1;

      if (yysize_overflow)
	return YYSIZE_MAXIMUM;

      if (yyresult)
	{
	  /* Avoid sprintf, as that infringes on the user's name space.
	     Don't have undefined behavior even if the translation
	     produced a string with the wrong number of "%s"s.  */
	  char *yyp = yyresult;
	  int yyi = 0;
	  while ((*yyp = *yyf) != '\0')
	    {
	      if (*yyp == '%' && yyf[1] == 's' && yyi < yycount)
		{
		  yyp += yytnamerr (yyp, yyarg[yyi++]);
		  yyf += 2;
		}
	      else
		{
		  yyp++;
		  yyf++;
		}
	    }
	}
      return yysize;
    }
}
#endif /* YYERROR_VERBOSE */


/*-----------------------------------------------.
| Release the memory associated to this symbol.  |
`-----------------------------------------------*/

/*ARGSUSED*/
#if (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
static void
yydestruct (const char *yymsg, int yytype, YYSTYPE *yyvaluep, struct ctf_scanner *scanner)
#else
static void
yydestruct (yymsg, yytype, yyvaluep, scanner)
    const char *yymsg;
    int yytype;
    YYSTYPE *yyvaluep;
    struct ctf_scanner *scanner;
#endif
{
  YYUSE (yyvaluep);
  YYUSE (scanner);

  if (!yymsg)
    yymsg = "Deleting";
  YY_SYMBOL_PRINT (yymsg, yytype, yyvaluep, yylocationp);

  switch (yytype)
    {

      default:
	break;
    }
}

/* Prevent warnings from -Wmissing-prototypes.  */
#ifdef YYPARSE_PARAM
#if defined __STDC__ || defined __cplusplus
int yyparse (void *YYPARSE_PARAM);
#else
int yyparse ();
#endif
#else /* ! YYPARSE_PARAM */
#if defined __STDC__ || defined __cplusplus
int yyparse (struct ctf_scanner *scanner);
#else
int yyparse ();
#endif
#endif /* ! YYPARSE_PARAM */





/*-------------------------.
| yyparse or yypush_parse.  |
`-------------------------*/

#ifdef YYPARSE_PARAM
#if (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
int
yyparse (void *YYPARSE_PARAM)
#else
int
yyparse (YYPARSE_PARAM)
    void *YYPARSE_PARAM;
#endif
#else /* ! YYPARSE_PARAM */
#if (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
int
yyparse (struct ctf_scanner *scanner)
#else
int
yyparse (scanner)
    struct ctf_scanner *scanner;
#endif
#endif
{
/* The lookahead symbol.  */
int yychar;

/* The semantic value of the lookahead symbol.  */
YYSTYPE yylval;

    /* Number of syntax errors so far.  */
    int yynerrs;

    int yystate;
    /* Number of tokens to shift before error messages enabled.  */
    int yyerrstatus;

    /* The stacks and their tools:
       `yyss': related to states.
       `yyvs': related to semantic values.

       Refer to the stacks thru separate pointers, to allow yyoverflow
       to reallocate them elsewhere.  */

    /* The state stack.  */
    yytype_int16 yyssa[YYINITDEPTH];
    yytype_int16 *yyss;
    yytype_int16 *yyssp;

    /* The semantic value stack.  */
    YYSTYPE yyvsa[YYINITDEPTH];
    YYSTYPE *yyvs;
    YYSTYPE *yyvsp;

    YYSIZE_T yystacksize;

  int yyn;
  int yyresult;
  /* Lookahead token as an internal (translated) token number.  */
  int yytoken;
  /* The variables used to return semantic value and location from the
     action routines.  */
  YYSTYPE yyval;

#if YYERROR_VERBOSE
  /* Buffer for error messages, and its allocated size.  */
  char yymsgbuf[128];
  char *yymsg = yymsgbuf;
  YYSIZE_T yymsg_alloc = sizeof yymsgbuf;
#endif

#define YYPOPSTACK(N)   (yyvsp -= (N), yyssp -= (N))

  /* The number of symbols on the RHS of the reduced rule.
     Keep to zero when no symbol should be popped.  */
  int yylen = 0;

  yytoken = 0;
  yyss = yyssa;
  yyvs = yyvsa;
  yystacksize = YYINITDEPTH;

  YYDPRINTF ((stderr, "Starting parse\n"));

  yystate = 0;
  yyerrstatus = 0;
  yynerrs = 0;
  yychar = YYEMPTY; /* Cause a token to be read.  */

  /* Initialize stack pointers.
     Waste one element of value and location stack
     so that they stay on the same level as the state stack.
     The wasted elements are never initialized.  */
  yyssp = yyss;
  yyvsp = yyvs;

  goto yysetstate;

/*------------------------------------------------------------.
| yynewstate -- Push a new state, which is found in yystate.  |
`------------------------------------------------------------*/
 yynewstate:
  /* In all cases, when you get here, the value and location stacks
     have just been pushed.  So pushing a state here evens the stacks.  */
  yyssp++;

 yysetstate:
  *yyssp = yystate;

  if (yyss + yystacksize - 1 <= yyssp)
    {
      /* Get the current used size of the three stacks, in elements.  */
      YYSIZE_T yysize = yyssp - yyss + 1;

#ifdef yyoverflow
      {
	/* Give user a chance to reallocate the stack.  Use copies of
	   these so that the &'s don't force the real ones into
	   memory.  */
	YYSTYPE *yyvs1 = yyvs;
	yytype_int16 *yyss1 = yyss;

	/* Each stack pointer address is followed by the size of the
	   data in use in that stack, in bytes.  This used to be a
	   conditional around just the two extra args, but that might
	   be undefined if yyoverflow is a macro.  */
	yyoverflow (YY_("memory exhausted"),
		    &yyss1, yysize * sizeof (*yyssp),
		    &yyvs1, yysize * sizeof (*yyvsp),
		    &yystacksize);

	yyss = yyss1;
	yyvs = yyvs1;
      }
#else /* no yyoverflow */
# ifndef YYSTACK_RELOCATE
      goto yyexhaustedlab;
# else
      /* Extend the stack our own way.  */
      if (YYMAXDEPTH <= yystacksize)
	goto yyexhaustedlab;
      yystacksize *= 2;
      if (YYMAXDEPTH < yystacksize)
	yystacksize = YYMAXDEPTH;

      {
	yytype_int16 *yyss1 = yyss;
	union yyalloc *yyptr =
	  (union yyalloc *) YYSTACK_ALLOC (YYSTACK_BYTES (yystacksize));
	if (! yyptr)
	  goto yyexhaustedlab;
	YYSTACK_RELOCATE (yyss_alloc, yyss);
	YYSTACK_RELOCATE (yyvs_alloc, yyvs);
#  undef YYSTACK_RELOCATE
	if (yyss1 != yyssa)
	  YYSTACK_FREE (yyss1);
      }
# endif
#endif /* no yyoverflow */

      yyssp = yyss + yysize - 1;
      yyvsp = yyvs + yysize - 1;

      YYDPRINTF ((stderr, "Stack size increased to %lu\n",
		  (unsigned long int) yystacksize));

      if (yyss + yystacksize - 1 <= yyssp)
	YYABORT;
    }

  YYDPRINTF ((stderr, "Entering state %d\n", yystate));

  if (yystate == YYFINAL)
    YYACCEPT;

  goto yybackup;

/*-----------.
| yybackup.  |
`-----------*/
yybackup:

  /* Do appropriate processing given the current state.  Read a
     lookahead token if we need one and don't already have one.  */

  /* First try to decide what to do without reference to lookahead token.  */
  yyn = yypact[yystate];
  if (yyn == YYPACT_NINF)
    goto yydefault;

  /* Not known => get a lookahead token if don't already have one.  */

  /* YYCHAR is either YYEMPTY or YYEOF or a valid lookahead symbol.  */
  if (yychar == YYEMPTY)
    {
      YYDPRINTF ((stderr, "Reading a token: "));
      yychar = YYLEX;
    }

  if (yychar <= YYEOF)
    {
      yychar = yytoken = YYEOF;
      YYDPRINTF ((stderr, "Now at end of input.\n"));
    }
  else
    {
      yytoken = YYTRANSLATE (yychar);
      YY_SYMBOL_PRINT ("Next token is", yytoken, &yylval, &yylloc);
    }

  /* If the proper action on seeing token YYTOKEN is to reduce or to
     detect an error, take that action.  */
  yyn += yytoken;
  if (yyn < 0 || YYLAST < yyn || yycheck[yyn] != yytoken)
    goto yydefault;
  yyn = yytable[yyn];
  if (yyn <= 0)
    {
      if (yyn == 0 || yyn == YYTABLE_NINF)
	goto yyerrlab;
      yyn = -yyn;
      goto yyreduce;
    }

  /* Count tokens shifted since error; after three, turn off error
     status.  */
  if (yyerrstatus)
    yyerrstatus--;

  /* Shift the lookahead token.  */
  YY_SYMBOL_PRINT ("Shifting", yytoken, &yylval, &yylloc);

  /* Discard the shifted token.  */
  yychar = YYEMPTY;

  yystate = yyn;
  *++yyvsp = yylval;

  goto yynewstate;


/*-----------------------------------------------------------.
| yydefault -- do the default action for the current state.  |
`-----------------------------------------------------------*/
yydefault:
  yyn = yydefact[yystate];
  if (yyn == 0)
    goto yyerrlab;
  goto yyreduce;


/*-----------------------------.
| yyreduce -- Do a reduction.  |
`-----------------------------*/
yyreduce:
  /* yyn is the number of a rule to reduce with.  */
  yylen = yyr2[yyn];

  /* If YYLEN is nonzero, implement the default value of the action:
     `$$ = $1'.

     Otherwise, the following line sets YYVAL to garbage.
     This behavior is undocumented and Bison
     users should not rely upon it.  Assigning to YYVAL
     unconditionally makes the parser a bit smaller, and it avoids a
     GCC warning that YYVAL may be used uninitialized.  */
  yyval = yyvsp[1-yylen];


  YY_REDUCE_PRINT (yyn);
  switch (yyn)
    {
        case 2:

/* Line 1455 of yacc.c  */
#line 909 "ctf-parser.y"
    {
			if (set_parent_node((yyvsp[(1) - (1)].n), &ctf_scanner_get_ast(scanner)->root))
				reparent_error(scanner, "error reparenting to root");
		}
    break;

  case 3:

/* Line 1455 of yacc.c  */
#line 914 "ctf-parser.y"
    {
			if (set_parent_node((yyvsp[(2) - (2)].n), &ctf_scanner_get_ast(scanner)->root))
				reparent_error(scanner, "error reparenting to root");
		}
    break;

  case 4:

/* Line 1455 of yacc.c  */
#line 922 "ctf-parser.y"
    {	(yyval.gs) = yylval.gs;		}
    break;

  case 5:

/* Line 1455 of yacc.c  */
#line 924 "ctf-parser.y"
    {	(yyval.gs) = yylval.gs;		}
    break;

  case 6:

/* Line 1455 of yacc.c  */
#line 926 "ctf-parser.y"
    {	(yyval.gs) = yylval.gs;		}
    break;

  case 7:

/* Line 1455 of yacc.c  */
#line 928 "ctf-parser.y"
    {	(yyval.gs) = yylval.gs;		}
    break;

  case 8:

/* Line 1455 of yacc.c  */
#line 930 "ctf-parser.y"
    {	(yyval.gs) = yylval.gs;		}
    break;

  case 9:

/* Line 1455 of yacc.c  */
#line 932 "ctf-parser.y"
    {	(yyval.gs) = yylval.gs;		}
    break;

  case 10:

/* Line 1455 of yacc.c  */
#line 934 "ctf-parser.y"
    {	(yyval.gs) = yylval.gs;		}
    break;

  case 11:

/* Line 1455 of yacc.c  */
#line 936 "ctf-parser.y"
    {	(yyval.gs) = yylval.gs;		}
    break;

  case 12:

/* Line 1455 of yacc.c  */
#line 938 "ctf-parser.y"
    {	(yyval.gs) = yylval.gs;		}
    break;

  case 13:

/* Line 1455 of yacc.c  */
#line 940 "ctf-parser.y"
    {	(yyval.gs) = yylval.gs;		}
    break;

  case 14:

/* Line 1455 of yacc.c  */
#line 942 "ctf-parser.y"
    {	(yyval.gs) = yylval.gs;		}
    break;

  case 15:

/* Line 1455 of yacc.c  */
#line 944 "ctf-parser.y"
    {	(yyval.gs) = yylval.gs;		}
    break;

  case 16:

/* Line 1455 of yacc.c  */
#line 946 "ctf-parser.y"
    {	(yyval.gs) = yylval.gs;		}
    break;

  case 17:

/* Line 1455 of yacc.c  */
#line 948 "ctf-parser.y"
    {	(yyval.gs) = yylval.gs;		}
    break;

  case 18:

/* Line 1455 of yacc.c  */
#line 950 "ctf-parser.y"
    {	(yyval.gs) = yylval.gs;		}
    break;

  case 19:

/* Line 1455 of yacc.c  */
#line 952 "ctf-parser.y"
    {	(yyval.gs) = yylval.gs;		}
    break;

  case 20:

/* Line 1455 of yacc.c  */
#line 954 "ctf-parser.y"
    {	(yyval.gs) = yylval.gs;		}
    break;

  case 21:

/* Line 1455 of yacc.c  */
#line 956 "ctf-parser.y"
    {	(yyval.gs) = yylval.gs;		}
    break;

  case 22:

/* Line 1455 of yacc.c  */
#line 958 "ctf-parser.y"
    {	(yyval.gs) = yylval.gs;		}
    break;

  case 23:

/* Line 1455 of yacc.c  */
#line 960 "ctf-parser.y"
    {	(yyval.gs) = yylval.gs;		}
    break;

  case 24:

/* Line 1455 of yacc.c  */
#line 962 "ctf-parser.y"
    {	(yyval.gs) = yylval.gs;		}
    break;

  case 25:

/* Line 1455 of yacc.c  */
#line 964 "ctf-parser.y"
    {	(yyval.gs) = yylval.gs;		}
    break;

  case 26:

/* Line 1455 of yacc.c  */
#line 966 "ctf-parser.y"
    {	(yyval.gs) = yylval.gs;		}
    break;

  case 27:

/* Line 1455 of yacc.c  */
#line 968 "ctf-parser.y"
    {	(yyval.gs) = yylval.gs;		}
    break;

  case 28:

/* Line 1455 of yacc.c  */
#line 975 "ctf-parser.y"
    {	(yyval.gs) = (yyvsp[(1) - (1)].gs);					}
    break;

  case 29:

/* Line 1455 of yacc.c  */
#line 977 "ctf-parser.y"
    {	(yyval.gs) = gc_string_append(scanner, (yyvsp[(1) - (2)].gs), (yyvsp[(2) - (2)].gs));		}
    break;

  case 30:

/* Line 1455 of yacc.c  */
#line 982 "ctf-parser.y"
    {	(yyval.gs) = yylval.gs;					}
    break;

  case 31:

/* Line 1455 of yacc.c  */
#line 984 "ctf-parser.y"
    {
			reparent_error(scanner, "escape sequences not supported yet");
		}
    break;

  case 32:

/* Line 1455 of yacc.c  */
#line 993 "ctf-parser.y"
    {	(yyval.gs) = (yyvsp[(1) - (1)].gs);					}
    break;

  case 33:

/* Line 1455 of yacc.c  */
#line 995 "ctf-parser.y"
    {	(yyval.gs) = gc_string_append(scanner, (yyvsp[(1) - (2)].gs), (yyvsp[(2) - (2)].gs));		}
    break;

  case 34:

/* Line 1455 of yacc.c  */
#line 1000 "ctf-parser.y"
    {	(yyval.gs) = yylval.gs;					}
    break;

  case 35:

/* Line 1455 of yacc.c  */
#line 1002 "ctf-parser.y"
    {
			reparent_error(scanner, "escape sequences not supported yet");
		}
    break;

  case 36:

/* Line 1455 of yacc.c  */
#line 1011 "ctf-parser.y"
    {
			(yyval.n) = make_node(scanner, NODE_UNARY_EXPRESSION);
			(yyval.n)->u.unary_expression.type = UNARY_STRING;
			(yyval.n)->u.unary_expression.u.string = yylval.gs->s;
		}
    break;

  case 37:

/* Line 1455 of yacc.c  */
#line 1017 "ctf-parser.y"
    {
			(yyval.n) = make_node(scanner, NODE_UNARY_EXPRESSION);
			(yyval.n)->u.unary_expression.type = UNARY_STRING;
			(yyval.n)->u.unary_expression.u.string = yylval.gs->s;
		}
    break;

  case 38:

/* Line 1455 of yacc.c  */
#line 1023 "ctf-parser.y"
    {
			(yyval.n) = make_node(scanner, NODE_UNARY_EXPRESSION);
			(yyval.n)->u.unary_expression.type = UNARY_STRING;
			(yyval.n)->u.unary_expression.u.string = yylval.gs->s;
		}
    break;

  case 39:

/* Line 1455 of yacc.c  */
#line 1029 "ctf-parser.y"
    {
			(yyval.n) = make_node(scanner, NODE_UNARY_EXPRESSION);
			(yyval.n)->u.unary_expression.type = UNARY_UNSIGNED_CONSTANT;
			sscanf(yylval.gs->s, "%" PRIu64,
			       &(yyval.n)->u.unary_expression.u.unsigned_constant);
		}
    break;

  case 40:

/* Line 1455 of yacc.c  */
#line 1036 "ctf-parser.y"
    {
			(yyval.n) = make_node(scanner, NODE_UNARY_EXPRESSION);
			(yyval.n)->u.unary_expression.type = UNARY_UNSIGNED_CONSTANT;
			sscanf(yylval.gs->s, "0%" PRIo64,
			       &(yyval.n)->u.unary_expression.u.unsigned_constant);
		}
    break;

  case 41:

/* Line 1455 of yacc.c  */
#line 1043 "ctf-parser.y"
    {
			(yyval.n) = make_node(scanner, NODE_UNARY_EXPRESSION);
			(yyval.n)->u.unary_expression.type = UNARY_UNSIGNED_CONSTANT;
			sscanf(yylval.gs->s, "0x%" PRIx64,
			       &(yyval.n)->u.unary_expression.u.unsigned_constant);
		}
    break;

  case 42:

/* Line 1455 of yacc.c  */
#line 1050 "ctf-parser.y"
    {
			(yyval.n) = make_node(scanner, NODE_UNARY_EXPRESSION);
			(yyval.n)->u.unary_expression.type = UNARY_STRING;
			(yyval.n)->u.unary_expression.u.string = "";
		}
    break;

  case 43:

/* Line 1455 of yacc.c  */
#line 1056 "ctf-parser.y"
    {
			(yyval.n) = make_node(scanner, NODE_UNARY_EXPRESSION);
			(yyval.n)->u.unary_expression.type = UNARY_STRING;
			(yyval.n)->u.unary_expression.u.string = (yyvsp[(2) - (3)].gs)->s;
		}
    break;

  case 44:

/* Line 1455 of yacc.c  */
#line 1062 "ctf-parser.y"
    {
			(yyval.n) = make_node(scanner, NODE_UNARY_EXPRESSION);
			(yyval.n)->u.unary_expression.type = UNARY_STRING;
			(yyval.n)->u.unary_expression.u.string = (yyvsp[(2) - (3)].gs)->s;
		}
    break;

  case 45:

/* Line 1455 of yacc.c  */
#line 1068 "ctf-parser.y"
    {
			(yyval.n) = make_node(scanner, NODE_UNARY_EXPRESSION);
			(yyval.n)->u.unary_expression.type = UNARY_NESTED;
			(yyval.n)->u.unary_expression.u.nested_exp = (yyvsp[(2) - (3)].n);
		}
    break;

  case 46:

/* Line 1455 of yacc.c  */
#line 1074 "ctf-parser.y"
    {
			(yyval.n) = make_node(scanner, NODE_UNARY_EXPRESSION);
			(yyval.n)->u.unary_expression.type = UNARY_SBRAC;
			(yyval.n)->u.unary_expression.u.sbrac_exp = (yyvsp[(3) - (4)].n);
			cds_list_splice(&((yyvsp[(1) - (4)].n))->tmp_head, &((yyval.n))->tmp_head);
			cds_list_add_tail(&((yyval.n))->siblings, &((yyval.n))->tmp_head);
		}
    break;

  case 47:

/* Line 1455 of yacc.c  */
#line 1082 "ctf-parser.y"
    {
			(yyval.n) = make_node(scanner, NODE_UNARY_EXPRESSION);
			(yyval.n)->u.unary_expression.type = UNARY_STRING;
			(yyval.n)->u.unary_expression.u.string = yylval.gs->s;
			(yyval.n)->u.unary_expression.link = UNARY_DOTLINK;
			cds_list_splice(&((yyvsp[(1) - (3)].n))->tmp_head, &((yyval.n))->tmp_head);
			cds_list_add_tail(&((yyval.n))->siblings, &((yyval.n))->tmp_head);
		}
    break;

  case 48:

/* Line 1455 of yacc.c  */
#line 1091 "ctf-parser.y"
    {
			(yyval.n) = make_node(scanner, NODE_UNARY_EXPRESSION);
			(yyval.n)->u.unary_expression.type = UNARY_STRING;
			(yyval.n)->u.unary_expression.u.string = yylval.gs->s;
			(yyval.n)->u.unary_expression.link = UNARY_DOTLINK;
			cds_list_splice(&((yyvsp[(1) - (3)].n))->tmp_head, &((yyval.n))->tmp_head);
			cds_list_add_tail(&((yyval.n))->siblings, &((yyval.n))->tmp_head);
		}
    break;

  case 49:

/* Line 1455 of yacc.c  */
#line 1100 "ctf-parser.y"
    {
			(yyval.n) = make_node(scanner, NODE_UNARY_EXPRESSION);
			(yyval.n)->u.unary_expression.type = UNARY_STRING;
			(yyval.n)->u.unary_expression.u.string = yylval.gs->s;
			(yyval.n)->u.unary_expression.link = UNARY_ARROWLINK;
			cds_list_splice(&((yyvsp[(1) - (3)].n))->tmp_head, &((yyval.n))->tmp_head);
			cds_list_add_tail(&((yyval.n))->siblings, &((yyval.n))->tmp_head);
		}
    break;

  case 50:

/* Line 1455 of yacc.c  */
#line 1109 "ctf-parser.y"
    {
			(yyval.n) = make_node(scanner, NODE_UNARY_EXPRESSION);
			(yyval.n)->u.unary_expression.type = UNARY_STRING;
			(yyval.n)->u.unary_expression.u.string = yylval.gs->s;
			(yyval.n)->u.unary_expression.link = UNARY_ARROWLINK;
			cds_list_splice(&((yyvsp[(1) - (3)].n))->tmp_head, &((yyval.n))->tmp_head);
			cds_list_add_tail(&((yyval.n))->siblings, &((yyval.n))->tmp_head);
		}
    break;

  case 51:

/* Line 1455 of yacc.c  */
#line 1121 "ctf-parser.y"
    {	(yyval.n) = (yyvsp[(1) - (1)].n);				}
    break;

  case 52:

/* Line 1455 of yacc.c  */
#line 1123 "ctf-parser.y"
    {	(yyval.n) = (yyvsp[(2) - (2)].n);				}
    break;

  case 53:

/* Line 1455 of yacc.c  */
#line 1125 "ctf-parser.y"
    {
			(yyval.n) = (yyvsp[(2) - (2)].n);
			if ((yyval.n)->u.unary_expression.type != UNARY_SIGNED_CONSTANT
				&& (yyval.n)->u.unary_expression.type != UNARY_UNSIGNED_CONSTANT)
				reparent_error(scanner, "expecting numeric constant");

			if ((yyval.n)->u.unary_expression.type == UNARY_UNSIGNED_CONSTANT) {
				(yyval.n)->u.unary_expression.type = UNARY_SIGNED_CONSTANT;
				(yyval.n)->u.unary_expression.u.signed_constant =
					-((yyval.n)->u.unary_expression.u.unsigned_constant);
			} else {
				(yyval.n)->u.unary_expression.u.signed_constant =
					-((yyval.n)->u.unary_expression.u.signed_constant);
			}
		}
    break;

  case 54:

/* Line 1455 of yacc.c  */
#line 1144 "ctf-parser.y"
    {
			(yyval.n) = (yyvsp[(1) - (3)].n);
			_cds_list_splice_tail(&((yyvsp[(3) - (3)].n))->tmp_head, &((yyval.n))->tmp_head);
			(yyvsp[(3) - (3)].n)->u.unary_expression.link = UNARY_DOTDOTDOT;
		}
    break;

  case 55:

/* Line 1455 of yacc.c  */
#line 1150 "ctf-parser.y"
    {	(yyval.n) = (yyvsp[(1) - (1)].n);		}
    break;

  case 56:

/* Line 1455 of yacc.c  */
#line 1157 "ctf-parser.y"
    {	(yyval.n) = (yyvsp[(1) - (2)].n);	}
    break;

  case 57:

/* Line 1455 of yacc.c  */
#line 1159 "ctf-parser.y"
    {	(yyval.n) = (yyvsp[(1) - (1)].n);	}
    break;

  case 58:

/* Line 1455 of yacc.c  */
#line 1161 "ctf-parser.y"
    {	(yyval.n) = (yyvsp[(1) - (1)].n);	}
    break;

  case 59:

/* Line 1455 of yacc.c  */
#line 1163 "ctf-parser.y"
    {	(yyval.n) = (yyvsp[(1) - (1)].n);	}
    break;

  case 60:

/* Line 1455 of yacc.c  */
#line 1165 "ctf-parser.y"
    {
			struct ctf_node *list;

			(yyval.n) = make_node(scanner, NODE_TYPEDEF);
			list = make_node(scanner, NODE_TYPE_SPECIFIER_LIST);
			(yyval.n)->u._typedef.type_specifier_list = list;
			_cds_list_splice_tail(&((yyvsp[(1) - (5)].n))->u.type_specifier_list.head, &list->u.type_specifier_list.head);
			_cds_list_splice_tail(&((yyvsp[(3) - (5)].n))->u.type_specifier_list.head, &list->u.type_specifier_list.head);
			_cds_list_splice_tail(&((yyvsp[(4) - (5)].n))->tmp_head, &((yyval.n))->u._typedef.type_declarators);
		}
    break;

  case 61:

/* Line 1455 of yacc.c  */
#line 1176 "ctf-parser.y"
    {
			struct ctf_node *list;

			(yyval.n) = make_node(scanner, NODE_TYPEDEF);
			list = make_node(scanner, NODE_TYPE_SPECIFIER_LIST);
			(yyval.n)->u._typedef.type_specifier_list = list;
			_cds_list_splice_tail(&((yyvsp[(2) - (4)].n))->u.type_specifier_list.head, &list->u.type_specifier_list.head);
			_cds_list_splice_tail(&((yyvsp[(3) - (4)].n))->tmp_head, &((yyval.n))->u._typedef.type_declarators);
		}
    break;

  case 62:

/* Line 1455 of yacc.c  */
#line 1186 "ctf-parser.y"
    {
			struct ctf_node *list;

			(yyval.n) = make_node(scanner, NODE_TYPEDEF);
			list = make_node(scanner, NODE_TYPE_SPECIFIER_LIST);
			(yyval.n)->u._typedef.type_specifier_list = list;
			_cds_list_splice_tail(&((yyvsp[(1) - (4)].n))->u.type_specifier_list.head, &list->u.type_specifier_list.head);
			_cds_list_splice_tail(&((yyvsp[(3) - (4)].n))->tmp_head, &((yyval.n))->u._typedef.type_declarators);
		}
    break;

  case 63:

/* Line 1455 of yacc.c  */
#line 1196 "ctf-parser.y"
    {
			struct ctf_node *list;

			(yyval.n) = make_node(scanner, NODE_TYPEALIAS);
			(yyval.n)->u.typealias.target = make_node(scanner, NODE_TYPEALIAS_TARGET);
			(yyval.n)->u.typealias.alias = make_node(scanner, NODE_TYPEALIAS_ALIAS);

			list = make_node(scanner, NODE_TYPE_SPECIFIER_LIST);
			(yyval.n)->u.typealias.target->u.typealias_target.type_specifier_list = list;
			_cds_list_splice_tail(&((yyvsp[(2) - (7)].n))->u.type_specifier_list.head, &list->u.type_specifier_list.head);
			_cds_list_splice_tail(&((yyvsp[(3) - (7)].n))->tmp_head, &((yyval.n))->u.typealias.target->u.typealias_target.type_declarators);

			list = make_node(scanner, NODE_TYPE_SPECIFIER_LIST);
			(yyval.n)->u.typealias.alias->u.typealias_alias.type_specifier_list = list;
			_cds_list_splice_tail(&((yyvsp[(5) - (7)].n))->u.type_specifier_list.head, &list->u.type_specifier_list.head);
			_cds_list_splice_tail(&((yyvsp[(6) - (7)].n))->tmp_head, &((yyval.n))->u.typealias.alias->u.typealias_alias.type_declarators);
		}
    break;

  case 64:

/* Line 1455 of yacc.c  */
#line 1217 "ctf-parser.y"
    {
			(yyval.n) = make_node(scanner, NODE_EVENT);
		}
    break;

  case 65:

/* Line 1455 of yacc.c  */
#line 1221 "ctf-parser.y"
    {
			(yyval.n) = make_node(scanner, NODE_EVENT);
			if (set_parent_node((yyvsp[(2) - (3)].n), (yyval.n)))
				reparent_error(scanner, "event_declaration");
		}
    break;

  case 66:

/* Line 1455 of yacc.c  */
#line 1230 "ctf-parser.y"
    {	push_scope(scanner);	}
    break;

  case 67:

/* Line 1455 of yacc.c  */
#line 1235 "ctf-parser.y"
    {	pop_scope(scanner);	}
    break;

  case 68:

/* Line 1455 of yacc.c  */
#line 1241 "ctf-parser.y"
    {
			(yyval.n) = make_node(scanner, NODE_STREAM);
		}
    break;

  case 69:

/* Line 1455 of yacc.c  */
#line 1245 "ctf-parser.y"
    {
			(yyval.n) = make_node(scanner, NODE_STREAM);
			if (set_parent_node((yyvsp[(2) - (3)].n), (yyval.n)))
				reparent_error(scanner, "stream_declaration");
		}
    break;

  case 70:

/* Line 1455 of yacc.c  */
#line 1254 "ctf-parser.y"
    {	push_scope(scanner);	}
    break;

  case 71:

/* Line 1455 of yacc.c  */
#line 1259 "ctf-parser.y"
    {	pop_scope(scanner);	}
    break;

  case 72:

/* Line 1455 of yacc.c  */
#line 1265 "ctf-parser.y"
    {
			(yyval.n) = make_node(scanner, NODE_TRACE);
		}
    break;

  case 73:

/* Line 1455 of yacc.c  */
#line 1269 "ctf-parser.y"
    {
			(yyval.n) = make_node(scanner, NODE_TRACE);
			if (set_parent_node((yyvsp[(2) - (3)].n), (yyval.n)))
				reparent_error(scanner, "trace_declaration");
		}
    break;

  case 74:

/* Line 1455 of yacc.c  */
#line 1278 "ctf-parser.y"
    {	push_scope(scanner);	}
    break;

  case 75:

/* Line 1455 of yacc.c  */
#line 1283 "ctf-parser.y"
    {	pop_scope(scanner);	}
    break;

  case 76:

/* Line 1455 of yacc.c  */
#line 1288 "ctf-parser.y"
    {
			struct ctf_node *node;

			(yyval.n) = make_node(scanner, NODE_TYPE_SPECIFIER_LIST);
			node = make_node(scanner, NODE_TYPE_SPECIFIER);
			node->u.type_specifier.type = TYPESPEC_CONST;
			cds_list_add_tail(&node->siblings, &((yyval.n))->u.type_specifier_list.head);
		}
    break;

  case 77:

/* Line 1455 of yacc.c  */
#line 1297 "ctf-parser.y"
    {
			struct ctf_node *node;

			(yyval.n) = make_node(scanner, NODE_TYPE_SPECIFIER_LIST);
			node = (yyvsp[(1) - (1)].n);
			cds_list_add_tail(&node->siblings, &((yyval.n))->u.type_specifier_list.head);
		}
    break;

  case 78:

/* Line 1455 of yacc.c  */
#line 1305 "ctf-parser.y"
    {
			struct ctf_node *node;

			(yyval.n) = (yyvsp[(1) - (2)].n);
			node = make_node(scanner, NODE_TYPE_SPECIFIER);
			node->u.type_specifier.type = TYPESPEC_CONST;
			cds_list_add_tail(&node->siblings, &((yyval.n))->u.type_specifier_list.head);
		}
    break;

  case 79:

/* Line 1455 of yacc.c  */
#line 1314 "ctf-parser.y"
    {
			(yyval.n) = (yyvsp[(1) - (2)].n);
			cds_list_add_tail(&((yyvsp[(2) - (2)].n))->siblings, &((yyval.n))->u.type_specifier_list.head);
		}
    break;

  case 80:

/* Line 1455 of yacc.c  */
#line 1322 "ctf-parser.y"
    {
			struct ctf_node *node;

			(yyval.n) = make_node(scanner, NODE_TYPE_SPECIFIER_LIST);
			node = make_node(scanner, NODE_TYPE_SPECIFIER);
			node->u.type_specifier.type = TYPESPEC_CONST;
			cds_list_add_tail(&node->siblings, &((yyval.n))->u.type_specifier_list.head);
		}
    break;

  case 81:

/* Line 1455 of yacc.c  */
#line 1331 "ctf-parser.y"
    {
			struct ctf_node *node;

			(yyval.n) = make_node(scanner, NODE_TYPE_SPECIFIER_LIST);
			node = (yyvsp[(1) - (1)].n);
			cds_list_add_tail(&node->siblings, &((yyval.n))->u.type_specifier_list.head);
		}
    break;

  case 82:

/* Line 1455 of yacc.c  */
#line 1339 "ctf-parser.y"
    {
			struct ctf_node *node;

			(yyval.n) = (yyvsp[(1) - (2)].n);
			node = make_node(scanner, NODE_TYPE_SPECIFIER);
			node->u.type_specifier.type = TYPESPEC_CONST;
			cds_list_add_tail(&node->siblings, &((yyval.n))->u.type_specifier_list.head);
		}
    break;

  case 83:

/* Line 1455 of yacc.c  */
#line 1348 "ctf-parser.y"
    {
			(yyval.n) = (yyvsp[(1) - (2)].n);
			cds_list_add_tail(&((yyvsp[(2) - (2)].n))->siblings, &((yyval.n))->u.type_specifier_list.head);
		}
    break;

  case 84:

/* Line 1455 of yacc.c  */
#line 1356 "ctf-parser.y"
    {	(yyval.n) = (yyvsp[(1) - (1)].n);	}
    break;

  case 85:

/* Line 1455 of yacc.c  */
#line 1358 "ctf-parser.y"
    {
			(yyval.n) = (yyvsp[(1) - (3)].n);
			cds_list_add_tail(&((yyvsp[(3) - (3)].n))->siblings, &((yyval.n))->tmp_head);
		}
    break;

  case 86:

/* Line 1455 of yacc.c  */
#line 1366 "ctf-parser.y"
    {
			(yyval.n) = make_node(scanner, NODE_TYPE_SPECIFIER);
			(yyval.n)->u.type_specifier.type = TYPESPEC_CHAR;
		}
    break;

  case 87:

/* Line 1455 of yacc.c  */
#line 1371 "ctf-parser.y"
    {
			(yyval.n) = make_node(scanner, NODE_TYPE_SPECIFIER);
			(yyval.n)->u.type_specifier.type = TYPESPEC_SHORT;
		}
    break;

  case 88:

/* Line 1455 of yacc.c  */
#line 1376 "ctf-parser.y"
    {
			(yyval.n) = make_node(scanner, NODE_TYPE_SPECIFIER);
			(yyval.n)->u.type_specifier.type = TYPESPEC_INT;
		}
    break;

  case 89:

/* Line 1455 of yacc.c  */
#line 1381 "ctf-parser.y"
    {
			(yyval.n) = make_node(scanner, NODE_TYPE_SPECIFIER);
			(yyval.n)->u.type_specifier.type = TYPESPEC_LONG;
		}
    break;

  case 90:

/* Line 1455 of yacc.c  */
#line 1386 "ctf-parser.y"
    {
			(yyval.n) = make_node(scanner, NODE_TYPE_SPECIFIER);
			(yyval.n)->u.type_specifier.type = TYPESPEC_SIGNED;
		}
    break;

  case 91:

/* Line 1455 of yacc.c  */
#line 1391 "ctf-parser.y"
    {
			(yyval.n) = make_node(scanner, NODE_TYPE_SPECIFIER);
			(yyval.n)->u.type_specifier.type = TYPESPEC_UNSIGNED;
		}
    break;

  case 92:

/* Line 1455 of yacc.c  */
#line 1396 "ctf-parser.y"
    {
			(yyval.n) = make_node(scanner, NODE_TYPE_SPECIFIER);
			(yyval.n)->u.type_specifier.type = TYPESPEC_BOOL;
		}
    break;

  case 93:

/* Line 1455 of yacc.c  */
#line 1401 "ctf-parser.y"
    {
			(yyval.n) = make_node(scanner, NODE_TYPE_SPECIFIER);
			(yyval.n)->u.type_specifier.type = TYPESPEC_ID_TYPE;
			(yyval.n)->u.type_specifier.id_type = yylval.gs->s;
		}
    break;

  case 94:

/* Line 1455 of yacc.c  */
#line 1407 "ctf-parser.y"
    {
			(yyval.n) = make_node(scanner, NODE_TYPE_SPECIFIER);
			(yyval.n)->u.type_specifier.type = TYPESPEC_INTEGER;
			(yyval.n)->u.type_specifier.node = make_node(scanner, NODE_INTEGER);
		}
    break;

  case 95:

/* Line 1455 of yacc.c  */
#line 1413 "ctf-parser.y"
    {
			(yyval.n) = make_node(scanner, NODE_TYPE_SPECIFIER);
			(yyval.n)->u.type_specifier.type = TYPESPEC_INTEGER;
			(yyval.n)->u.type_specifier.node = make_node(scanner, NODE_INTEGER);
			if (set_parent_node((yyvsp[(3) - (4)].n), (yyval.n)->u.type_specifier.node))
				reparent_error(scanner, "integer reparent error");
		}
    break;

  case 96:

/* Line 1455 of yacc.c  */
#line 1424 "ctf-parser.y"
    {
			(yyval.n) = make_node(scanner, NODE_TYPE_SPECIFIER);
			(yyval.n)->u.type_specifier.type = TYPESPEC_VOID;
		}
    break;

  case 97:

/* Line 1455 of yacc.c  */
#line 1429 "ctf-parser.y"
    {
			(yyval.n) = make_node(scanner, NODE_TYPE_SPECIFIER);
			(yyval.n)->u.type_specifier.type = TYPESPEC_CHAR;
		}
    break;

  case 98:

/* Line 1455 of yacc.c  */
#line 1434 "ctf-parser.y"
    {
			(yyval.n) = make_node(scanner, NODE_TYPE_SPECIFIER);
			(yyval.n)->u.type_specifier.type = TYPESPEC_SHORT;
		}
    break;

  case 99:

/* Line 1455 of yacc.c  */
#line 1439 "ctf-parser.y"
    {
			(yyval.n) = make_node(scanner, NODE_TYPE_SPECIFIER);
			(yyval.n)->u.type_specifier.type = TYPESPEC_INT;
		}
    break;

  case 100:

/* Line 1455 of yacc.c  */
#line 1444 "ctf-parser.y"
    {
			(yyval.n) = make_node(scanner, NODE_TYPE_SPECIFIER);
			(yyval.n)->u.type_specifier.type = TYPESPEC_LONG;
		}
    break;

  case 101:

/* Line 1455 of yacc.c  */
#line 1449 "ctf-parser.y"
    {
			(yyval.n) = make_node(scanner, NODE_TYPE_SPECIFIER);
			(yyval.n)->u.type_specifier.type = TYPESPEC_FLOAT;
		}
    break;

  case 102:

/* Line 1455 of yacc.c  */
#line 1454 "ctf-parser.y"
    {
			(yyval.n) = make_node(scanner, NODE_TYPE_SPECIFIER);
			(yyval.n)->u.type_specifier.type = TYPESPEC_DOUBLE;
		}
    break;

  case 103:

/* Line 1455 of yacc.c  */
#line 1459 "ctf-parser.y"
    {
			(yyval.n) = make_node(scanner, NODE_TYPE_SPECIFIER);
			(yyval.n)->u.type_specifier.type = TYPESPEC_SIGNED;
		}
    break;

  case 104:

/* Line 1455 of yacc.c  */
#line 1464 "ctf-parser.y"
    {
			(yyval.n) = make_node(scanner, NODE_TYPE_SPECIFIER);
			(yyval.n)->u.type_specifier.type = TYPESPEC_UNSIGNED;
		}
    break;

  case 105:

/* Line 1455 of yacc.c  */
#line 1469 "ctf-parser.y"
    {
			(yyval.n) = make_node(scanner, NODE_TYPE_SPECIFIER);
			(yyval.n)->u.type_specifier.type = TYPESPEC_BOOL;
		}
    break;

  case 106:

/* Line 1455 of yacc.c  */
#line 1474 "ctf-parser.y"
    {
			(yyval.n) = make_node(scanner, NODE_TYPE_SPECIFIER);
			(yyval.n)->u.type_specifier.type = TYPESPEC_COMPLEX;
		}
    break;

  case 107:

/* Line 1455 of yacc.c  */
#line 1479 "ctf-parser.y"
    {
			(yyval.n) = make_node(scanner, NODE_TYPE_SPECIFIER);
			(yyval.n)->u.type_specifier.type = TYPESPEC_IMAGINARY;
		}
    break;

  case 108:

/* Line 1455 of yacc.c  */
#line 1484 "ctf-parser.y"
    {
			(yyval.n) = make_node(scanner, NODE_TYPE_SPECIFIER);
			(yyval.n)->u.type_specifier.type = TYPESPEC_ID_TYPE;
			(yyval.n)->u.type_specifier.id_type = yylval.gs->s;
		}
    break;

  case 109:

/* Line 1455 of yacc.c  */
#line 1490 "ctf-parser.y"
    {
			(yyval.n) = make_node(scanner, NODE_TYPE_SPECIFIER);
			(yyval.n)->u.type_specifier.type = TYPESPEC_FLOATING_POINT;
			(yyval.n)->u.type_specifier.node = make_node(scanner, NODE_FLOATING_POINT);
		}
    break;

  case 110:

/* Line 1455 of yacc.c  */
#line 1496 "ctf-parser.y"
    {
			(yyval.n) = make_node(scanner, NODE_TYPE_SPECIFIER);
			(yyval.n)->u.type_specifier.type = TYPESPEC_FLOATING_POINT;
			(yyval.n)->u.type_specifier.node = make_node(scanner, NODE_FLOATING_POINT);
			if (set_parent_node((yyvsp[(3) - (4)].n), (yyval.n)->u.type_specifier.node))
				reparent_error(scanner, "floating point reparent error");
		}
    break;

  case 111:

/* Line 1455 of yacc.c  */
#line 1504 "ctf-parser.y"
    {
			(yyval.n) = make_node(scanner, NODE_TYPE_SPECIFIER);
			(yyval.n)->u.type_specifier.type = TYPESPEC_INTEGER;
			(yyval.n)->u.type_specifier.node = make_node(scanner, NODE_INTEGER);
		}
    break;

  case 112:

/* Line 1455 of yacc.c  */
#line 1510 "ctf-parser.y"
    {
			(yyval.n) = make_node(scanner, NODE_TYPE_SPECIFIER);
			(yyval.n)->u.type_specifier.type = TYPESPEC_INTEGER;
			(yyval.n)->u.type_specifier.node = make_node(scanner, NODE_INTEGER);
			if (set_parent_node((yyvsp[(3) - (4)].n), (yyval.n)->u.type_specifier.node))
				reparent_error(scanner, "integer reparent error");
		}
    break;

  case 113:

/* Line 1455 of yacc.c  */
#line 1518 "ctf-parser.y"
    {
			(yyval.n) = make_node(scanner, NODE_TYPE_SPECIFIER);
			(yyval.n)->u.type_specifier.type = TYPESPEC_STRING;
			(yyval.n)->u.type_specifier.node = make_node(scanner, NODE_STRING);
		}
    break;

  case 114:

/* Line 1455 of yacc.c  */
#line 1524 "ctf-parser.y"
    {
			(yyval.n) = make_node(scanner, NODE_TYPE_SPECIFIER);
			(yyval.n)->u.type_specifier.type = TYPESPEC_STRING;
			(yyval.n)->u.type_specifier.node = make_node(scanner, NODE_STRING);
		}
    break;

  case 115:

/* Line 1455 of yacc.c  */
#line 1530 "ctf-parser.y"
    {
			(yyval.n) = make_node(scanner, NODE_TYPE_SPECIFIER);
			(yyval.n)->u.type_specifier.type = TYPESPEC_STRING;
			(yyval.n)->u.type_specifier.node = make_node(scanner, NODE_STRING);
			if (set_parent_node((yyvsp[(3) - (4)].n), (yyval.n)->u.type_specifier.node))
				reparent_error(scanner, "string reparent error");
		}
    break;

  case 116:

/* Line 1455 of yacc.c  */
#line 1538 "ctf-parser.y"
    {
			(yyval.n) = make_node(scanner, NODE_TYPE_SPECIFIER);
			(yyval.n)->u.type_specifier.type = TYPESPEC_ENUM;
			(yyval.n)->u.type_specifier.node = (yyvsp[(2) - (2)].n);
		}
    break;

  case 117:

/* Line 1455 of yacc.c  */
#line 1544 "ctf-parser.y"
    {
			(yyval.n) = make_node(scanner, NODE_TYPE_SPECIFIER);
			(yyval.n)->u.type_specifier.type = TYPESPEC_VARIANT;
			(yyval.n)->u.type_specifier.node = (yyvsp[(2) - (2)].n);
		}
    break;

  case 118:

/* Line 1455 of yacc.c  */
#line 1550 "ctf-parser.y"
    {
			(yyval.n) = make_node(scanner, NODE_TYPE_SPECIFIER);
			(yyval.n)->u.type_specifier.type = TYPESPEC_STRUCT;
			(yyval.n)->u.type_specifier.node = (yyvsp[(2) - (2)].n);
		}
    break;

  case 119:

/* Line 1455 of yacc.c  */
#line 1559 "ctf-parser.y"
    {
			(yyval.n) = make_node(scanner, NODE_STRUCT);
			(yyval.n)->u._struct.has_body = 1;
			if ((yyvsp[(2) - (3)].n) && set_parent_node((yyvsp[(2) - (3)].n), (yyval.n)))
				reparent_error(scanner, "struct reparent error");
		}
    break;

  case 120:

/* Line 1455 of yacc.c  */
#line 1566 "ctf-parser.y"
    {
			(yyval.n) = make_node(scanner, NODE_STRUCT);
			(yyval.n)->u._struct.has_body = 1;
			(yyval.n)->u._struct.name = (yyvsp[(1) - (4)].gs)->s;
			if ((yyvsp[(3) - (4)].n) && set_parent_node((yyvsp[(3) - (4)].n), (yyval.n)))
				reparent_error(scanner, "struct reparent error");
		}
    break;

  case 121:

/* Line 1455 of yacc.c  */
#line 1574 "ctf-parser.y"
    {
			(yyval.n) = make_node(scanner, NODE_STRUCT);
			(yyval.n)->u._struct.has_body = 1;
			(yyval.n)->u._struct.name = (yyvsp[(1) - (4)].gs)->s;
			if ((yyvsp[(3) - (4)].n) && set_parent_node((yyvsp[(3) - (4)].n), (yyval.n)))
				reparent_error(scanner, "struct reparent error");
		}
    break;

  case 122:

/* Line 1455 of yacc.c  */
#line 1582 "ctf-parser.y"
    {
			(yyval.n) = make_node(scanner, NODE_STRUCT);
			(yyval.n)->u._struct.has_body = 0;
			(yyval.n)->u._struct.name = (yyvsp[(1) - (1)].gs)->s;
		}
    break;

  case 123:

/* Line 1455 of yacc.c  */
#line 1588 "ctf-parser.y"
    {
			(yyval.n) = make_node(scanner, NODE_STRUCT);
			(yyval.n)->u._struct.has_body = 0;
			(yyval.n)->u._struct.name = (yyvsp[(1) - (1)].gs)->s;
		}
    break;

  case 124:

/* Line 1455 of yacc.c  */
#line 1594 "ctf-parser.y"
    {
			(yyval.n) = make_node(scanner, NODE_STRUCT);
			(yyval.n)->u._struct.has_body = 1;
			cds_list_add_tail(&((yyvsp[(6) - (7)].n))->siblings, &(yyval.n)->u._struct.min_align);
			if ((yyvsp[(2) - (7)].n) && set_parent_node((yyvsp[(2) - (7)].n), (yyval.n)))
				reparent_error(scanner, "struct reparent error");
		}
    break;

  case 125:

/* Line 1455 of yacc.c  */
#line 1602 "ctf-parser.y"
    {
			(yyval.n) = make_node(scanner, NODE_STRUCT);
			(yyval.n)->u._struct.has_body = 1;
			(yyval.n)->u._struct.name = (yyvsp[(1) - (8)].gs)->s;
			cds_list_add_tail(&((yyvsp[(7) - (8)].n))->siblings, &(yyval.n)->u._struct.min_align);
			if ((yyvsp[(3) - (8)].n) && set_parent_node((yyvsp[(3) - (8)].n), (yyval.n)))
				reparent_error(scanner, "struct reparent error");
		}
    break;

  case 126:

/* Line 1455 of yacc.c  */
#line 1611 "ctf-parser.y"
    {
			(yyval.n) = make_node(scanner, NODE_STRUCT);
			(yyval.n)->u._struct.has_body = 1;
			(yyval.n)->u._struct.name = (yyvsp[(1) - (8)].gs)->s;
			cds_list_add_tail(&((yyvsp[(7) - (8)].n))->siblings, &(yyval.n)->u._struct.min_align);
			if ((yyvsp[(3) - (8)].n) && set_parent_node((yyvsp[(3) - (8)].n), (yyval.n)))
				reparent_error(scanner, "struct reparent error");
		}
    break;

  case 127:

/* Line 1455 of yacc.c  */
#line 1623 "ctf-parser.y"
    {	push_scope(scanner);	}
    break;

  case 128:

/* Line 1455 of yacc.c  */
#line 1628 "ctf-parser.y"
    {	pop_scope(scanner);	}
    break;

  case 129:

/* Line 1455 of yacc.c  */
#line 1633 "ctf-parser.y"
    {
			(yyval.n) = make_node(scanner, NODE_VARIANT);
			(yyval.n)->u.variant.has_body = 1;
			if ((yyvsp[(2) - (3)].n) && set_parent_node((yyvsp[(2) - (3)].n), (yyval.n)))
				reparent_error(scanner, "variant reparent error");
		}
    break;

  case 130:

/* Line 1455 of yacc.c  */
#line 1640 "ctf-parser.y"
    {
			(yyval.n) = make_node(scanner, NODE_VARIANT);
			(yyval.n)->u.variant.has_body = 1;
			(yyval.n)->u.variant.choice = (yyvsp[(2) - (6)].gs)->s;
			if ((yyvsp[(5) - (6)].n) && set_parent_node((yyvsp[(5) - (6)].n), (yyval.n)))
				reparent_error(scanner, "variant reparent error");
		}
    break;

  case 131:

/* Line 1455 of yacc.c  */
#line 1648 "ctf-parser.y"
    {
			(yyval.n) = make_node(scanner, NODE_VARIANT);
			(yyval.n)->u.variant.has_body = 1;
			(yyval.n)->u.variant.choice = (yyvsp[(2) - (6)].gs)->s;
			if ((yyvsp[(5) - (6)].n) && set_parent_node((yyvsp[(5) - (6)].n), (yyval.n)))
				reparent_error(scanner, "variant reparent error");
		}
    break;

  case 132:

/* Line 1455 of yacc.c  */
#line 1656 "ctf-parser.y"
    {
			(yyval.n) = make_node(scanner, NODE_VARIANT);
			(yyval.n)->u.variant.has_body = 1;
			(yyval.n)->u.variant.name = (yyvsp[(1) - (4)].gs)->s;
			if ((yyvsp[(3) - (4)].n) && set_parent_node((yyvsp[(3) - (4)].n), (yyval.n)))
				reparent_error(scanner, "variant reparent error");
		}
    break;

  case 133:

/* Line 1455 of yacc.c  */
#line 1664 "ctf-parser.y"
    {
			(yyval.n) = make_node(scanner, NODE_VARIANT);
			(yyval.n)->u.variant.has_body = 1;
			(yyval.n)->u.variant.name = (yyvsp[(1) - (7)].gs)->s;
			(yyval.n)->u.variant.choice = (yyvsp[(3) - (7)].gs)->s;
			if ((yyvsp[(6) - (7)].n) && set_parent_node((yyvsp[(6) - (7)].n), (yyval.n)))
				reparent_error(scanner, "variant reparent error");
		}
    break;

  case 134:

/* Line 1455 of yacc.c  */
#line 1673 "ctf-parser.y"
    {
			(yyval.n) = make_node(scanner, NODE_VARIANT);
			(yyval.n)->u.variant.has_body = 0;
			(yyval.n)->u.variant.name = (yyvsp[(1) - (4)].gs)->s;
			(yyval.n)->u.variant.choice = (yyvsp[(3) - (4)].gs)->s;
		}
    break;

  case 135:

/* Line 1455 of yacc.c  */
#line 1680 "ctf-parser.y"
    {
			(yyval.n) = make_node(scanner, NODE_VARIANT);
			(yyval.n)->u.variant.has_body = 1;
			(yyval.n)->u.variant.name = (yyvsp[(1) - (7)].gs)->s;
			(yyval.n)->u.variant.choice = (yyvsp[(3) - (7)].gs)->s;
			if ((yyvsp[(6) - (7)].n) && set_parent_node((yyvsp[(6) - (7)].n), (yyval.n)))
				reparent_error(scanner, "variant reparent error");
		}
    break;

  case 136:

/* Line 1455 of yacc.c  */
#line 1689 "ctf-parser.y"
    {
			(yyval.n) = make_node(scanner, NODE_VARIANT);
			(yyval.n)->u.variant.has_body = 0;
			(yyval.n)->u.variant.name = (yyvsp[(1) - (4)].gs)->s;
			(yyval.n)->u.variant.choice = (yyvsp[(3) - (4)].gs)->s;
		}
    break;

  case 137:

/* Line 1455 of yacc.c  */
#line 1696 "ctf-parser.y"
    {
			(yyval.n) = make_node(scanner, NODE_VARIANT);
			(yyval.n)->u.variant.has_body = 1;
			(yyval.n)->u.variant.name = (yyvsp[(1) - (4)].gs)->s;
			if ((yyvsp[(3) - (4)].n) && set_parent_node((yyvsp[(3) - (4)].n), (yyval.n)))
				reparent_error(scanner, "variant reparent error");
		}
    break;

  case 138:

/* Line 1455 of yacc.c  */
#line 1704 "ctf-parser.y"
    {
			(yyval.n) = make_node(scanner, NODE_VARIANT);
			(yyval.n)->u.variant.has_body = 1;
			(yyval.n)->u.variant.name = (yyvsp[(1) - (7)].gs)->s;
			(yyval.n)->u.variant.choice = (yyvsp[(3) - (7)].gs)->s;
			if ((yyvsp[(6) - (7)].n) && set_parent_node((yyvsp[(6) - (7)].n), (yyval.n)))
				reparent_error(scanner, "variant reparent error");
		}
    break;

  case 139:

/* Line 1455 of yacc.c  */
#line 1713 "ctf-parser.y"
    {
			(yyval.n) = make_node(scanner, NODE_VARIANT);
			(yyval.n)->u.variant.has_body = 0;
			(yyval.n)->u.variant.name = (yyvsp[(1) - (4)].gs)->s;
			(yyval.n)->u.variant.choice = (yyvsp[(3) - (4)].gs)->s;
		}
    break;

  case 140:

/* Line 1455 of yacc.c  */
#line 1720 "ctf-parser.y"
    {
			(yyval.n) = make_node(scanner, NODE_VARIANT);
			(yyval.n)->u.variant.has_body = 1;
			(yyval.n)->u.variant.name = (yyvsp[(1) - (7)].gs)->s;
			(yyval.n)->u.variant.choice = (yyvsp[(3) - (7)].gs)->s;
			if ((yyvsp[(6) - (7)].n) && set_parent_node((yyvsp[(6) - (7)].n), (yyval.n)))
				reparent_error(scanner, "variant reparent error");
		}
    break;

  case 141:

/* Line 1455 of yacc.c  */
#line 1729 "ctf-parser.y"
    {
			(yyval.n) = make_node(scanner, NODE_VARIANT);
			(yyval.n)->u.variant.has_body = 0;
			(yyval.n)->u.variant.name = (yyvsp[(1) - (4)].gs)->s;
			(yyval.n)->u.variant.choice = (yyvsp[(3) - (4)].gs)->s;
		}
    break;

  case 142:

/* Line 1455 of yacc.c  */
#line 1739 "ctf-parser.y"
    {	push_scope(scanner);	}
    break;

  case 143:

/* Line 1455 of yacc.c  */
#line 1744 "ctf-parser.y"
    {	pop_scope(scanner);	}
    break;

  case 144:

/* Line 1455 of yacc.c  */
#line 1749 "ctf-parser.y"
    {
			(yyval.n) = make_node(scanner, NODE_ENUM);
			(yyval.n)->u._enum.has_body = 1;
			_cds_list_splice_tail(&((yyvsp[(2) - (3)].n))->tmp_head, &((yyval.n))->u._enum.enumerator_list);
		}
    break;

  case 145:

/* Line 1455 of yacc.c  */
#line 1755 "ctf-parser.y"
    {
			(yyval.n) = make_node(scanner, NODE_ENUM);
			(yyval.n)->u._enum.has_body = 1;
			((yyval.n))->u._enum.container_type = (yyvsp[(2) - (5)].n);
			_cds_list_splice_tail(&((yyvsp[(4) - (5)].n))->tmp_head, &((yyval.n))->u._enum.enumerator_list);
		}
    break;

  case 146:

/* Line 1455 of yacc.c  */
#line 1762 "ctf-parser.y"
    {
			(yyval.n) = make_node(scanner, NODE_ENUM);
			(yyval.n)->u._enum.has_body = 1;
			(yyval.n)->u._enum.enum_id = (yyvsp[(1) - (4)].gs)->s;
			_cds_list_splice_tail(&((yyvsp[(3) - (4)].n))->tmp_head, &((yyval.n))->u._enum.enumerator_list);
		}
    break;

  case 147:

/* Line 1455 of yacc.c  */
#line 1769 "ctf-parser.y"
    {
			(yyval.n) = make_node(scanner, NODE_ENUM);
			(yyval.n)->u._enum.has_body = 1;
			(yyval.n)->u._enum.enum_id = (yyvsp[(1) - (6)].gs)->s;
			((yyval.n))->u._enum.container_type = (yyvsp[(3) - (6)].n);
			_cds_list_splice_tail(&((yyvsp[(5) - (6)].n))->tmp_head, &((yyval.n))->u._enum.enumerator_list);
		}
    break;

  case 148:

/* Line 1455 of yacc.c  */
#line 1777 "ctf-parser.y"
    {
			(yyval.n) = make_node(scanner, NODE_ENUM);
			(yyval.n)->u._enum.has_body = 1;
			(yyval.n)->u._enum.enum_id = (yyvsp[(1) - (4)].gs)->s;
			_cds_list_splice_tail(&((yyvsp[(3) - (4)].n))->tmp_head, &((yyval.n))->u._enum.enumerator_list);
		}
    break;

  case 149:

/* Line 1455 of yacc.c  */
#line 1784 "ctf-parser.y"
    {
			(yyval.n) = make_node(scanner, NODE_ENUM);
			(yyval.n)->u._enum.has_body = 1;
			(yyval.n)->u._enum.enum_id = (yyvsp[(1) - (6)].gs)->s;
			((yyval.n))->u._enum.container_type = (yyvsp[(3) - (6)].n);
			_cds_list_splice_tail(&((yyvsp[(5) - (6)].n))->tmp_head, &((yyval.n))->u._enum.enumerator_list);
		}
    break;

  case 150:

/* Line 1455 of yacc.c  */
#line 1792 "ctf-parser.y"
    {
			(yyval.n) = make_node(scanner, NODE_ENUM);
			(yyval.n)->u._enum.has_body = 1;
			_cds_list_splice_tail(&((yyvsp[(2) - (4)].n))->tmp_head, &((yyval.n))->u._enum.enumerator_list);
		}
    break;

  case 151:

/* Line 1455 of yacc.c  */
#line 1798 "ctf-parser.y"
    {
			(yyval.n) = make_node(scanner, NODE_ENUM);
			(yyval.n)->u._enum.has_body = 1;
			((yyval.n))->u._enum.container_type = (yyvsp[(2) - (6)].n);
			_cds_list_splice_tail(&((yyvsp[(4) - (6)].n))->tmp_head, &((yyval.n))->u._enum.enumerator_list);
		}
    break;

  case 152:

/* Line 1455 of yacc.c  */
#line 1805 "ctf-parser.y"
    {
			(yyval.n) = make_node(scanner, NODE_ENUM);
			(yyval.n)->u._enum.has_body = 1;
			(yyval.n)->u._enum.enum_id = (yyvsp[(1) - (5)].gs)->s;
			_cds_list_splice_tail(&((yyvsp[(3) - (5)].n))->tmp_head, &((yyval.n))->u._enum.enumerator_list);
		}
    break;

  case 153:

/* Line 1455 of yacc.c  */
#line 1812 "ctf-parser.y"
    {
			(yyval.n) = make_node(scanner, NODE_ENUM);
			(yyval.n)->u._enum.has_body = 1;
			(yyval.n)->u._enum.enum_id = (yyvsp[(1) - (7)].gs)->s;
			((yyval.n))->u._enum.container_type = (yyvsp[(3) - (7)].n);
			_cds_list_splice_tail(&((yyvsp[(5) - (7)].n))->tmp_head, &((yyval.n))->u._enum.enumerator_list);
		}
    break;

  case 154:

/* Line 1455 of yacc.c  */
#line 1820 "ctf-parser.y"
    {
			(yyval.n) = make_node(scanner, NODE_ENUM);
			(yyval.n)->u._enum.has_body = 0;
			(yyval.n)->u._enum.enum_id = (yyvsp[(1) - (1)].gs)->s;
		}
    break;

  case 155:

/* Line 1455 of yacc.c  */
#line 1826 "ctf-parser.y"
    {
			(yyval.n) = make_node(scanner, NODE_ENUM);
			(yyval.n)->u._enum.has_body = 1;
			(yyval.n)->u._enum.enum_id = (yyvsp[(1) - (5)].gs)->s;
			_cds_list_splice_tail(&((yyvsp[(3) - (5)].n))->tmp_head, &((yyval.n))->u._enum.enumerator_list);
		}
    break;

  case 156:

/* Line 1455 of yacc.c  */
#line 1833 "ctf-parser.y"
    {
			(yyval.n) = make_node(scanner, NODE_ENUM);
			(yyval.n)->u._enum.has_body = 1;
			(yyval.n)->u._enum.enum_id = (yyvsp[(1) - (7)].gs)->s;
			((yyval.n))->u._enum.container_type = (yyvsp[(3) - (7)].n);
			_cds_list_splice_tail(&((yyvsp[(5) - (7)].n))->tmp_head, &((yyval.n))->u._enum.enumerator_list);
		}
    break;

  case 157:

/* Line 1455 of yacc.c  */
#line 1841 "ctf-parser.y"
    {
			(yyval.n) = make_node(scanner, NODE_ENUM);
			(yyval.n)->u._enum.has_body = 0;
			(yyval.n)->u._enum.enum_id = (yyvsp[(1) - (1)].gs)->s;
		}
    break;

  case 158:

/* Line 1455 of yacc.c  */
#line 1850 "ctf-parser.y"
    {	(yyval.n) = NULL;	}
    break;

  case 159:

/* Line 1455 of yacc.c  */
#line 1852 "ctf-parser.y"
    {
			if ((yyvsp[(1) - (2)].n)) {
				(yyval.n) = (yyvsp[(1) - (2)].n);
				cds_list_add_tail(&((yyvsp[(2) - (2)].n))->siblings, &((yyval.n))->tmp_head);
			} else {
				(yyval.n) = (yyvsp[(2) - (2)].n);
				cds_list_add_tail(&((yyval.n))->siblings, &((yyval.n))->tmp_head);
			}
		}
    break;

  case 160:

/* Line 1455 of yacc.c  */
#line 1865 "ctf-parser.y"
    {
			struct ctf_node *list;

			list = make_node(scanner, NODE_TYPE_SPECIFIER_LIST);
			_cds_list_splice_tail(&((yyvsp[(1) - (3)].n))->u.type_specifier_list.head, &list->u.type_specifier_list.head);
			(yyval.n) = make_node(scanner, NODE_STRUCT_OR_VARIANT_DECLARATION);
			((yyval.n))->u.struct_or_variant_declaration.type_specifier_list = list;
			_cds_list_splice_tail(&((yyvsp[(2) - (3)].n))->tmp_head, &((yyval.n))->u.struct_or_variant_declaration.type_declarators);
		}
    break;

  case 161:

/* Line 1455 of yacc.c  */
#line 1875 "ctf-parser.y"
    {
			struct ctf_node *list;

			(yyval.n) = make_node(scanner, NODE_TYPEDEF);
			list = make_node(scanner, NODE_TYPE_SPECIFIER_LIST);
			(yyval.n)->u._typedef.type_specifier_list = list;
			_cds_list_splice_tail(&((yyvsp[(1) - (5)].n))->u.type_specifier_list.head, &list->u.type_specifier_list.head);
			_cds_list_splice_tail(&((yyvsp[(3) - (5)].n))->u.type_specifier_list.head, &list->u.type_specifier_list.head);
			_cds_list_splice_tail(&((yyvsp[(4) - (5)].n))->tmp_head, &((yyval.n))->u._typedef.type_declarators);
		}
    break;

  case 162:

/* Line 1455 of yacc.c  */
#line 1886 "ctf-parser.y"
    {
			struct ctf_node *list;

			(yyval.n) = make_node(scanner, NODE_TYPEDEF);
			list = make_node(scanner, NODE_TYPE_SPECIFIER_LIST);
			(yyval.n)->u._typedef.type_specifier_list = list;
			_cds_list_splice_tail(&((yyvsp[(2) - (4)].n))->u.type_specifier_list.head, &list->u.type_specifier_list.head);
			_cds_list_splice_tail(&((yyvsp[(3) - (4)].n))->tmp_head, &((yyval.n))->u._typedef.type_declarators);
		}
    break;

  case 163:

/* Line 1455 of yacc.c  */
#line 1896 "ctf-parser.y"
    {
			struct ctf_node *list;

			list = make_node(scanner, NODE_TYPE_SPECIFIER_LIST);
			_cds_list_splice_tail(&((yyvsp[(1) - (4)].n))->u.type_specifier_list.head, &list->u.type_specifier_list.head);
			(yyval.n) = make_node(scanner, NODE_TYPEDEF);
			((yyval.n))->u.struct_or_variant_declaration.type_specifier_list = list;
			_cds_list_splice_tail(&((yyvsp[(3) - (4)].n))->tmp_head, &((yyval.n))->u._typedef.type_declarators);
		}
    break;

  case 164:

/* Line 1455 of yacc.c  */
#line 1906 "ctf-parser.y"
    {
			struct ctf_node *list;

			(yyval.n) = make_node(scanner, NODE_TYPEALIAS);
			(yyval.n)->u.typealias.target = make_node(scanner, NODE_TYPEALIAS_TARGET);
			(yyval.n)->u.typealias.alias = make_node(scanner, NODE_TYPEALIAS_ALIAS);

			list = make_node(scanner, NODE_TYPE_SPECIFIER_LIST);
			(yyval.n)->u.typealias.target->u.typealias_target.type_specifier_list = list;
			_cds_list_splice_tail(&((yyvsp[(2) - (7)].n))->u.type_specifier_list.head, &list->u.type_specifier_list.head);
			_cds_list_splice_tail(&((yyvsp[(3) - (7)].n))->tmp_head, &((yyval.n))->u.typealias.target->u.typealias_target.type_declarators);

			list = make_node(scanner, NODE_TYPE_SPECIFIER_LIST);
			(yyval.n)->u.typealias.alias->u.typealias_alias.type_specifier_list = list;
			_cds_list_splice_tail(&((yyvsp[(5) - (7)].n))->u.type_specifier_list.head, &list->u.type_specifier_list.head);
			_cds_list_splice_tail(&((yyvsp[(6) - (7)].n))->tmp_head, &((yyval.n))->u.typealias.alias->u.typealias_alias.type_declarators);
		}
    break;

  case 165:

/* Line 1455 of yacc.c  */
#line 1927 "ctf-parser.y"
    {
			struct ctf_node *node;

			(yyval.n) = make_node(scanner, NODE_TYPE_SPECIFIER_LIST);
			node = make_node(scanner, NODE_TYPE_SPECIFIER);
			node->u.type_specifier.type = TYPESPEC_CONST;
			cds_list_add_tail(&node->siblings, &((yyval.n))->u.type_specifier_list.head);
		}
    break;

  case 166:

/* Line 1455 of yacc.c  */
#line 1936 "ctf-parser.y"
    {
			struct ctf_node *node;

			(yyval.n) = make_node(scanner, NODE_TYPE_SPECIFIER_LIST);
			node = (yyvsp[(1) - (1)].n);
			cds_list_add_tail(&node->siblings, &((yyval.n))->u.type_specifier_list.head);
		}
    break;

  case 167:

/* Line 1455 of yacc.c  */
#line 1944 "ctf-parser.y"
    {
			struct ctf_node *node;

			add_type(scanner, (yyvsp[(1) - (1)].gs));
			(yyval.n) = make_node(scanner, NODE_TYPE_SPECIFIER_LIST);
			node = make_node(scanner, NODE_TYPE_SPECIFIER);
			node->u.type_specifier.type = TYPESPEC_ID_TYPE;
			node->u.type_specifier.id_type = yylval.gs->s;
			cds_list_add_tail(&node->siblings, &((yyval.n))->u.type_specifier_list.head);
		}
    break;

  case 168:

/* Line 1455 of yacc.c  */
#line 1955 "ctf-parser.y"
    {
			struct ctf_node *node;

			(yyval.n) = (yyvsp[(1) - (2)].n);
			node = make_node(scanner, NODE_TYPE_SPECIFIER);
			node->u.type_specifier.type = TYPESPEC_CONST;
			cds_list_add_tail(&node->siblings, &((yyval.n))->u.type_specifier_list.head);
		}
    break;

  case 169:

/* Line 1455 of yacc.c  */
#line 1964 "ctf-parser.y"
    {
			(yyval.n) = (yyvsp[(1) - (2)].n);
			cds_list_add_tail(&((yyvsp[(2) - (2)].n))->siblings, &((yyval.n))->u.type_specifier_list.head);
		}
    break;

  case 170:

/* Line 1455 of yacc.c  */
#line 1969 "ctf-parser.y"
    {
			struct ctf_node *node;

			add_type(scanner, (yyvsp[(2) - (2)].gs));
			(yyval.n) = (yyvsp[(1) - (2)].n);
			node = make_node(scanner, NODE_TYPE_SPECIFIER);
			node->u.type_specifier.type = TYPESPEC_ID_TYPE;
			node->u.type_specifier.id_type = yylval.gs->s;
			cds_list_add_tail(&node->siblings, &((yyval.n))->u.type_specifier_list.head);
		}
    break;

  case 171:

/* Line 1455 of yacc.c  */
#line 1983 "ctf-parser.y"
    {	(yyval.n) = (yyvsp[(1) - (1)].n);	}
    break;

  case 172:

/* Line 1455 of yacc.c  */
#line 1985 "ctf-parser.y"
    {
			(yyval.n) = (yyvsp[(1) - (3)].n);
			cds_list_add_tail(&((yyvsp[(3) - (3)].n))->siblings, &((yyval.n))->tmp_head);
		}
    break;

  case 173:

/* Line 1455 of yacc.c  */
#line 1993 "ctf-parser.y"
    {	(yyval.n) = (yyvsp[(1) - (1)].n);	}
    break;

  case 174:

/* Line 1455 of yacc.c  */
#line 1995 "ctf-parser.y"
    {	(yyval.n) = (yyvsp[(2) - (2)].n);	}
    break;

  case 175:

/* Line 1455 of yacc.c  */
#line 1997 "ctf-parser.y"
    {
			(yyval.n) = (yyvsp[(1) - (3)].n);
			if (set_parent_node((yyvsp[(3) - (3)].n), (yyvsp[(1) - (3)].n)))
				reparent_error(scanner, "struct_or_variant_declarator");
		}
    break;

  case 176:

/* Line 1455 of yacc.c  */
#line 2006 "ctf-parser.y"
    {	(yyval.n) = (yyvsp[(1) - (1)].n);	}
    break;

  case 177:

/* Line 1455 of yacc.c  */
#line 2008 "ctf-parser.y"
    {
			(yyval.n) = (yyvsp[(1) - (3)].n);
			cds_list_add_tail(&((yyvsp[(3) - (3)].n))->siblings, &((yyval.n))->tmp_head);
		}
    break;

  case 178:

/* Line 1455 of yacc.c  */
#line 2016 "ctf-parser.y"
    {
			(yyval.n) = make_node(scanner, NODE_ENUMERATOR);
			(yyval.n)->u.enumerator.id = (yyvsp[(1) - (1)].gs)->s;
		}
    break;

  case 179:

/* Line 1455 of yacc.c  */
#line 2021 "ctf-parser.y"
    {
			(yyval.n) = make_node(scanner, NODE_ENUMERATOR);
			(yyval.n)->u.enumerator.id = (yyvsp[(1) - (1)].gs)->s;
		}
    break;

  case 180:

/* Line 1455 of yacc.c  */
#line 2026 "ctf-parser.y"
    {
			(yyval.n) = make_node(scanner, NODE_ENUMERATOR);
			(yyval.n)->u.enumerator.id = (yyvsp[(1) - (1)].gs)->s;
		}
    break;

  case 181:

/* Line 1455 of yacc.c  */
#line 2031 "ctf-parser.y"
    {
			(yyval.n) = make_node(scanner, NODE_ENUMERATOR);
			(yyval.n)->u.enumerator.id = "";
		}
    break;

  case 182:

/* Line 1455 of yacc.c  */
#line 2036 "ctf-parser.y"
    {
			(yyval.n) = make_node(scanner, NODE_ENUMERATOR);
			(yyval.n)->u.enumerator.id = (yyvsp[(2) - (3)].gs)->s;
		}
    break;

  case 183:

/* Line 1455 of yacc.c  */
#line 2041 "ctf-parser.y"
    {
			(yyval.n) = make_node(scanner, NODE_ENUMERATOR);
			(yyval.n)->u.enumerator.id = (yyvsp[(1) - (3)].gs)->s;
			cds_list_splice(&((yyvsp[(3) - (3)].n))->tmp_head, &((yyval.n))->u.enumerator.values);
		}
    break;

  case 184:

/* Line 1455 of yacc.c  */
#line 2047 "ctf-parser.y"
    {
			(yyval.n) = make_node(scanner, NODE_ENUMERATOR);
			(yyval.n)->u.enumerator.id = (yyvsp[(1) - (3)].gs)->s;
			cds_list_splice(&((yyvsp[(3) - (3)].n))->tmp_head, &((yyval.n))->u.enumerator.values);
		}
    break;

  case 185:

/* Line 1455 of yacc.c  */
#line 2053 "ctf-parser.y"
    {
			(yyval.n) = make_node(scanner, NODE_ENUMERATOR);
			(yyval.n)->u.enumerator.id = (yyvsp[(1) - (3)].gs)->s;
			cds_list_splice(&((yyvsp[(3) - (3)].n))->tmp_head, &((yyval.n))->u.enumerator.values);
		}
    break;

  case 186:

/* Line 1455 of yacc.c  */
#line 2059 "ctf-parser.y"
    {
			(yyval.n) = make_node(scanner, NODE_ENUMERATOR);
			(yyval.n)->u.enumerator.id = "";
			cds_list_splice(&((yyvsp[(4) - (4)].n))->tmp_head, &((yyval.n))->u.enumerator.values);
		}
    break;

  case 187:

/* Line 1455 of yacc.c  */
#line 2065 "ctf-parser.y"
    {
			(yyval.n) = make_node(scanner, NODE_ENUMERATOR);
			(yyval.n)->u.enumerator.id = (yyvsp[(2) - (5)].gs)->s;
			cds_list_splice(&((yyvsp[(5) - (5)].n))->tmp_head, &((yyval.n))->u.enumerator.values);
		}
    break;

  case 188:

/* Line 1455 of yacc.c  */
#line 2074 "ctf-parser.y"
    {	(yyval.n) = (yyvsp[(1) - (1)].n);	}
    break;

  case 189:

/* Line 1455 of yacc.c  */
#line 2076 "ctf-parser.y"
    {
			(yyval.n) = (yyvsp[(1) - (3)].n);
			cds_list_add_tail(&((yyvsp[(3) - (3)].n))->siblings, &((yyval.n))->tmp_head);
		}
    break;

  case 190:

/* Line 1455 of yacc.c  */
#line 2084 "ctf-parser.y"
    {	(yyval.n) = (yyvsp[(1) - (1)].n);	}
    break;

  case 191:

/* Line 1455 of yacc.c  */
#line 2086 "ctf-parser.y"
    {
			(yyval.n) = (yyvsp[(2) - (2)].n);
			cds_list_splice(&((yyvsp[(1) - (2)].n))->tmp_head, &((yyval.n))->u.type_declarator.pointers);
		}
    break;

  case 192:

/* Line 1455 of yacc.c  */
#line 2094 "ctf-parser.y"
    {
			(yyval.n) = make_node(scanner, NODE_TYPE_DECLARATOR);
                        (yyval.n)->u.type_declarator.type = TYPEDEC_ID;
			/* id is NULL */
		}
    break;

  case 193:

/* Line 1455 of yacc.c  */
#line 2100 "ctf-parser.y"
    {
			(yyval.n) = make_node(scanner, NODE_TYPE_DECLARATOR);
			(yyval.n)->u.type_declarator.type = TYPEDEC_ID;
			(yyval.n)->u.type_declarator.u.id = (yyvsp[(1) - (1)].gs)->s;
		}
    break;

  case 194:

/* Line 1455 of yacc.c  */
#line 2106 "ctf-parser.y"
    {
			(yyval.n) = make_node(scanner, NODE_TYPE_DECLARATOR);
			(yyval.n)->u.type_declarator.type = TYPEDEC_NESTED;
			(yyval.n)->u.type_declarator.u.nested.type_declarator = (yyvsp[(2) - (3)].n);
		}
    break;

  case 195:

/* Line 1455 of yacc.c  */
#line 2112 "ctf-parser.y"
    {
			(yyval.n) = make_node(scanner, NODE_TYPE_DECLARATOR);
			(yyval.n)->u.type_declarator.type = TYPEDEC_NESTED;
			(yyval.n)->u.type_declarator.u.nested.type_declarator = (yyvsp[(1) - (4)].n);
			CDS_INIT_LIST_HEAD(&((yyval.n))->u.type_declarator.u.nested.length);
			_cds_list_splice_tail(&((yyvsp[(3) - (4)].n))->tmp_head, &((yyval.n))->u.type_declarator.u.nested.length);
		}
    break;

  case 196:

/* Line 1455 of yacc.c  */
#line 2120 "ctf-parser.y"
    {
			(yyval.n) = make_node(scanner, NODE_TYPE_DECLARATOR);
			(yyval.n)->u.type_declarator.type = TYPEDEC_NESTED;
			(yyval.n)->u.type_declarator.u.nested.type_declarator = (yyvsp[(1) - (3)].n);
			(yyval.n)->u.type_declarator.u.nested.abstract_array = 1;
		}
    break;

  case 197:

/* Line 1455 of yacc.c  */
#line 2130 "ctf-parser.y"
    {	(yyval.n) = (yyvsp[(1) - (1)].n);	}
    break;

  case 198:

/* Line 1455 of yacc.c  */
#line 2132 "ctf-parser.y"
    {
			(yyval.n) = (yyvsp[(1) - (3)].n);
			cds_list_add_tail(&((yyvsp[(3) - (3)].n))->siblings, &((yyval.n))->tmp_head);
		}
    break;

  case 199:

/* Line 1455 of yacc.c  */
#line 2140 "ctf-parser.y"
    {	(yyval.n) = (yyvsp[(1) - (1)].n);	}
    break;

  case 200:

/* Line 1455 of yacc.c  */
#line 2142 "ctf-parser.y"
    {
			(yyval.n) = (yyvsp[(2) - (2)].n);
			cds_list_splice(&((yyvsp[(1) - (2)].n))->tmp_head, &((yyval.n))->u.type_declarator.pointers);
		}
    break;

  case 201:

/* Line 1455 of yacc.c  */
#line 2150 "ctf-parser.y"
    {
			(yyval.n) = make_node(scanner, NODE_TYPE_DECLARATOR);
                        (yyval.n)->u.type_declarator.type = TYPEDEC_ID;
			/* id is NULL */
		}
    break;

  case 202:

/* Line 1455 of yacc.c  */
#line 2156 "ctf-parser.y"
    {
			(yyval.n) = make_node(scanner, NODE_TYPE_DECLARATOR);
			(yyval.n)->u.type_declarator.type = TYPEDEC_NESTED;
			(yyval.n)->u.type_declarator.u.nested.type_declarator = (yyvsp[(2) - (3)].n);
		}
    break;

  case 203:

/* Line 1455 of yacc.c  */
#line 2162 "ctf-parser.y"
    {
			(yyval.n) = make_node(scanner, NODE_TYPE_DECLARATOR);
			(yyval.n)->u.type_declarator.type = TYPEDEC_NESTED;
			(yyval.n)->u.type_declarator.u.nested.type_declarator = (yyvsp[(1) - (4)].n);
			CDS_INIT_LIST_HEAD(&((yyval.n))->u.type_declarator.u.nested.length);
			_cds_list_splice_tail(&((yyvsp[(3) - (4)].n))->tmp_head, &((yyval.n))->u.type_declarator.u.nested.length);
		}
    break;

  case 204:

/* Line 1455 of yacc.c  */
#line 2170 "ctf-parser.y"
    {
			(yyval.n) = make_node(scanner, NODE_TYPE_DECLARATOR);
			(yyval.n)->u.type_declarator.type = TYPEDEC_NESTED;
			(yyval.n)->u.type_declarator.u.nested.type_declarator = (yyvsp[(1) - (3)].n);
			(yyval.n)->u.type_declarator.u.nested.abstract_array = 1;
		}
    break;

  case 205:

/* Line 1455 of yacc.c  */
#line 2180 "ctf-parser.y"
    {	(yyval.n) = (yyvsp[(1) - (1)].n);	}
    break;

  case 206:

/* Line 1455 of yacc.c  */
#line 2182 "ctf-parser.y"
    {
			(yyval.n) = (yyvsp[(2) - (2)].n);
			cds_list_splice(&((yyvsp[(1) - (2)].n))->tmp_head, &((yyval.n))->u.type_declarator.pointers);
		}
    break;

  case 207:

/* Line 1455 of yacc.c  */
#line 2190 "ctf-parser.y"
    {
			(yyval.n) = make_node(scanner, NODE_TYPE_DECLARATOR);
			(yyval.n)->u.type_declarator.type = TYPEDEC_ID;
			(yyval.n)->u.type_declarator.u.id = (yyvsp[(1) - (1)].gs)->s;
		}
    break;

  case 208:

/* Line 1455 of yacc.c  */
#line 2196 "ctf-parser.y"
    {
			(yyval.n) = make_node(scanner, NODE_TYPE_DECLARATOR);
			(yyval.n)->u.type_declarator.type = TYPEDEC_NESTED;
			(yyval.n)->u.type_declarator.u.nested.type_declarator = (yyvsp[(2) - (3)].n);
		}
    break;

  case 209:

/* Line 1455 of yacc.c  */
#line 2202 "ctf-parser.y"
    {
			(yyval.n) = make_node(scanner, NODE_TYPE_DECLARATOR);
			(yyval.n)->u.type_declarator.type = TYPEDEC_NESTED;
			(yyval.n)->u.type_declarator.u.nested.type_declarator = (yyvsp[(1) - (4)].n);
			CDS_INIT_LIST_HEAD(&((yyval.n))->u.type_declarator.u.nested.length);
			_cds_list_splice_tail(&((yyvsp[(3) - (4)].n))->tmp_head, &((yyval.n))->u.type_declarator.u.nested.length);
		}
    break;

  case 210:

/* Line 1455 of yacc.c  */
#line 2213 "ctf-parser.y"
    {	(yyval.n) = (yyvsp[(1) - (1)].n);	}
    break;

  case 211:

/* Line 1455 of yacc.c  */
#line 2215 "ctf-parser.y"
    {
			(yyval.n) = (yyvsp[(2) - (2)].n);
			cds_list_splice(&((yyvsp[(1) - (2)].n))->tmp_head, &((yyval.n))->u.type_declarator.pointers);
		}
    break;

  case 212:

/* Line 1455 of yacc.c  */
#line 2223 "ctf-parser.y"
    {
			add_type(scanner, (yyvsp[(1) - (1)].gs));
			(yyval.n) = make_node(scanner, NODE_TYPE_DECLARATOR);
			(yyval.n)->u.type_declarator.type = TYPEDEC_ID;
			(yyval.n)->u.type_declarator.u.id = (yyvsp[(1) - (1)].gs)->s;
		}
    break;

  case 213:

/* Line 1455 of yacc.c  */
#line 2230 "ctf-parser.y"
    {
			(yyval.n) = make_node(scanner, NODE_TYPE_DECLARATOR);
			(yyval.n)->u.type_declarator.type = TYPEDEC_NESTED;
			(yyval.n)->u.type_declarator.u.nested.type_declarator = (yyvsp[(2) - (3)].n);
		}
    break;

  case 214:

/* Line 1455 of yacc.c  */
#line 2236 "ctf-parser.y"
    {
			(yyval.n) = make_node(scanner, NODE_TYPE_DECLARATOR);
			(yyval.n)->u.type_declarator.type = TYPEDEC_NESTED;
			(yyval.n)->u.type_declarator.u.nested.type_declarator = (yyvsp[(1) - (4)].n);
			CDS_INIT_LIST_HEAD(&((yyval.n))->u.type_declarator.u.nested.length);
			_cds_list_splice_tail(&((yyvsp[(3) - (4)].n))->tmp_head, &((yyval.n))->u.type_declarator.u.nested.length);
		}
    break;

  case 215:

/* Line 1455 of yacc.c  */
#line 2247 "ctf-parser.y"
    {
			(yyval.n) = make_node(scanner, NODE_POINTER);
		}
    break;

  case 216:

/* Line 1455 of yacc.c  */
#line 2251 "ctf-parser.y"
    {
			(yyval.n) = make_node(scanner, NODE_POINTER);
			cds_list_splice(&((yyvsp[(2) - (2)].n))->tmp_head, &((yyval.n))->tmp_head);
		}
    break;

  case 217:

/* Line 1455 of yacc.c  */
#line 2256 "ctf-parser.y"
    {
			(yyval.n) = make_node(scanner, NODE_POINTER);
			(yyval.n)->u.pointer.const_qualifier = 1;
			cds_list_splice(&((yyvsp[(3) - (3)].n))->tmp_head, &((yyval.n))->tmp_head);
		}
    break;

  case 220:

/* Line 1455 of yacc.c  */
#line 2273 "ctf-parser.y"
    {	(yyval.n) = (yyvsp[(1) - (2)].n);	}
    break;

  case 221:

/* Line 1455 of yacc.c  */
#line 2275 "ctf-parser.y"
    {
			(yyval.n) = (yyvsp[(1) - (3)].n);
			cds_list_add_tail(&((yyvsp[(2) - (3)].n))->siblings, &((yyval.n))->tmp_head);
		}
    break;

  case 222:

/* Line 1455 of yacc.c  */
#line 2283 "ctf-parser.y"
    {
			/*
			 * Because we have left and right, cannot use
			 * set_parent_node.
			 */
			(yyval.n) = make_node(scanner, NODE_CTF_EXPRESSION);
			_cds_list_splice_tail(&((yyvsp[(1) - (3)].n))->tmp_head, &((yyval.n))->u.ctf_expression.left);
			if ((yyvsp[(1) - (3)].n)->u.unary_expression.type != UNARY_STRING)
				reparent_error(scanner, "ctf_assignment_expression left expects string");
			_cds_list_splice_tail(&((yyvsp[(3) - (3)].n))->tmp_head, &((yyval.n))->u.ctf_expression.right);
		}
    break;

  case 223:

/* Line 1455 of yacc.c  */
#line 2295 "ctf-parser.y"
    {
			/*
			 * Because we have left and right, cannot use
			 * set_parent_node.
			 */
			(yyval.n) = make_node(scanner, NODE_CTF_EXPRESSION);
			_cds_list_splice_tail(&((yyvsp[(1) - (3)].n))->tmp_head, &((yyval.n))->u.ctf_expression.left);
			if ((yyvsp[(1) - (3)].n)->u.unary_expression.type != UNARY_STRING)
				reparent_error(scanner, "ctf_assignment_expression left expects string");
			cds_list_add_tail(&((yyvsp[(3) - (3)].n))->siblings, &((yyval.n))->u.ctf_expression.right);
		}
    break;

  case 224:

/* Line 1455 of yacc.c  */
#line 2307 "ctf-parser.y"
    {
			struct ctf_node *list;

			list = make_node(scanner, NODE_TYPE_SPECIFIER_LIST);
			_cds_list_splice_tail(&((yyvsp[(1) - (4)].n))->u.type_specifier_list.head, &list->u.type_specifier_list.head);
			_cds_list_splice_tail(&((yyvsp[(3) - (4)].n))->u.type_specifier_list.head, &list->u.type_specifier_list.head);
			(yyval.n) = make_node(scanner, NODE_TYPEDEF);
			((yyval.n))->u.struct_or_variant_declaration.type_specifier_list = list;
			_cds_list_splice_tail(&((yyvsp[(4) - (4)].n))->tmp_head, &((yyval.n))->u._typedef.type_declarators);
		}
    break;

  case 225:

/* Line 1455 of yacc.c  */
#line 2318 "ctf-parser.y"
    {
			struct ctf_node *list;

			(yyval.n) = make_node(scanner, NODE_TYPEDEF);
			list = make_node(scanner, NODE_TYPE_SPECIFIER_LIST);
			(yyval.n)->u._typedef.type_specifier_list = list;
			_cds_list_splice_tail(&((yyvsp[(2) - (3)].n))->u.type_specifier_list.head, &list->u.type_specifier_list.head);
			_cds_list_splice_tail(&((yyvsp[(3) - (3)].n))->tmp_head, &((yyval.n))->u._typedef.type_declarators);
		}
    break;

  case 226:

/* Line 1455 of yacc.c  */
#line 2328 "ctf-parser.y"
    {
			struct ctf_node *list;

			list = make_node(scanner, NODE_TYPE_SPECIFIER_LIST);
			_cds_list_splice_tail(&((yyvsp[(1) - (3)].n))->u.type_specifier_list.head, &list->u.type_specifier_list.head);
			(yyval.n) = make_node(scanner, NODE_TYPEDEF);
			((yyval.n))->u.struct_or_variant_declaration.type_specifier_list = list;
			_cds_list_splice_tail(&((yyvsp[(3) - (3)].n))->tmp_head, &((yyval.n))->u._typedef.type_declarators);
		}
    break;

  case 227:

/* Line 1455 of yacc.c  */
#line 2338 "ctf-parser.y"
    {
			struct ctf_node *list;

			(yyval.n) = make_node(scanner, NODE_TYPEALIAS);
			(yyval.n)->u.typealias.target = make_node(scanner, NODE_TYPEALIAS_TARGET);
			(yyval.n)->u.typealias.alias = make_node(scanner, NODE_TYPEALIAS_ALIAS);

			list = make_node(scanner, NODE_TYPE_SPECIFIER_LIST);
			(yyval.n)->u.typealias.target->u.typealias_target.type_specifier_list = list;
			_cds_list_splice_tail(&((yyvsp[(2) - (6)].n))->u.type_specifier_list.head, &list->u.type_specifier_list.head);
			_cds_list_splice_tail(&((yyvsp[(3) - (6)].n))->tmp_head, &((yyval.n))->u.typealias.target->u.typealias_target.type_declarators);

			list = make_node(scanner, NODE_TYPE_SPECIFIER_LIST);
			(yyval.n)->u.typealias.alias->u.typealias_alias.type_specifier_list = list;
			_cds_list_splice_tail(&((yyvsp[(5) - (6)].n))->u.type_specifier_list.head, &list->u.type_specifier_list.head);
			_cds_list_splice_tail(&((yyvsp[(6) - (6)].n))->tmp_head, &((yyval.n))->u.typealias.alias->u.typealias_alias.type_declarators);
		}
    break;



/* Line 1455 of yacc.c  */
#line 5419 "ctf-parser.c"
      default: break;
    }
  YY_SYMBOL_PRINT ("-> $$ =", yyr1[yyn], &yyval, &yyloc);

  YYPOPSTACK (yylen);
  yylen = 0;
  YY_STACK_PRINT (yyss, yyssp);

  *++yyvsp = yyval;

  /* Now `shift' the result of the reduction.  Determine what state
     that goes to, based on the state we popped back to and the rule
     number reduced by.  */

  yyn = yyr1[yyn];

  yystate = yypgoto[yyn - YYNTOKENS] + *yyssp;
  if (0 <= yystate && yystate <= YYLAST && yycheck[yystate] == *yyssp)
    yystate = yytable[yystate];
  else
    yystate = yydefgoto[yyn - YYNTOKENS];

  goto yynewstate;


/*------------------------------------.
| yyerrlab -- here on detecting error |
`------------------------------------*/
yyerrlab:
  /* If not already recovering from an error, report this error.  */
  if (!yyerrstatus)
    {
      ++yynerrs;
#if ! YYERROR_VERBOSE
      yyerror (scanner, YY_("syntax error"));
#else
      {
	YYSIZE_T yysize = yysyntax_error (0, yystate, yychar);
	if (yymsg_alloc < yysize && yymsg_alloc < YYSTACK_ALLOC_MAXIMUM)
	  {
	    YYSIZE_T yyalloc = 2 * yysize;
	    if (! (yysize <= yyalloc && yyalloc <= YYSTACK_ALLOC_MAXIMUM))
	      yyalloc = YYSTACK_ALLOC_MAXIMUM;
	    if (yymsg != yymsgbuf)
	      YYSTACK_FREE (yymsg);
	    yymsg = (char *) YYSTACK_ALLOC (yyalloc);
	    if (yymsg)
	      yymsg_alloc = yyalloc;
	    else
	      {
		yymsg = yymsgbuf;
		yymsg_alloc = sizeof yymsgbuf;
	      }
	  }

	if (0 < yysize && yysize <= yymsg_alloc)
	  {
	    (void) yysyntax_error (yymsg, yystate, yychar);
	    yyerror (scanner, yymsg);
	  }
	else
	  {
	    yyerror (scanner, YY_("syntax error"));
	    if (yysize != 0)
	      goto yyexhaustedlab;
	  }
      }
#endif
    }



  if (yyerrstatus == 3)
    {
      /* If just tried and failed to reuse lookahead token after an
	 error, discard it.  */

      if (yychar <= YYEOF)
	{
	  /* Return failure if at end of input.  */
	  if (yychar == YYEOF)
	    YYABORT;
	}
      else
	{
	  yydestruct ("Error: discarding",
		      yytoken, &yylval, scanner);
	  yychar = YYEMPTY;
	}
    }

  /* Else will try to reuse lookahead token after shifting the error
     token.  */
  goto yyerrlab1;


/*---------------------------------------------------.
| yyerrorlab -- error raised explicitly by YYERROR.  |
`---------------------------------------------------*/
yyerrorlab:

  /* Pacify compilers like GCC when the user code never invokes
     YYERROR and the label yyerrorlab therefore never appears in user
     code.  */
  if (/*CONSTCOND*/ 0)
     goto yyerrorlab;

  /* Do not reclaim the symbols of the rule which action triggered
     this YYERROR.  */
  YYPOPSTACK (yylen);
  yylen = 0;
  YY_STACK_PRINT (yyss, yyssp);
  yystate = *yyssp;
  goto yyerrlab1;


/*-------------------------------------------------------------.
| yyerrlab1 -- common code for both syntax error and YYERROR.  |
`-------------------------------------------------------------*/
yyerrlab1:
  yyerrstatus = 3;	/* Each real token shifted decrements this.  */

  for (;;)
    {
      yyn = yypact[yystate];
      if (yyn != YYPACT_NINF)
	{
	  yyn += YYTERROR;
	  if (0 <= yyn && yyn <= YYLAST && yycheck[yyn] == YYTERROR)
	    {
	      yyn = yytable[yyn];
	      if (0 < yyn)
		break;
	    }
	}

      /* Pop the current state because it cannot handle the error token.  */
      if (yyssp == yyss)
	YYABORT;


      yydestruct ("Error: popping",
		  yystos[yystate], yyvsp, scanner);
      YYPOPSTACK (1);
      yystate = *yyssp;
      YY_STACK_PRINT (yyss, yyssp);
    }

  *++yyvsp = yylval;


  /* Shift the error token.  */
  YY_SYMBOL_PRINT ("Shifting", yystos[yyn], yyvsp, yylsp);

  yystate = yyn;
  goto yynewstate;


/*-------------------------------------.
| yyacceptlab -- YYACCEPT comes here.  |
`-------------------------------------*/
yyacceptlab:
  yyresult = 0;
  goto yyreturn;

/*-----------------------------------.
| yyabortlab -- YYABORT comes here.  |
`-----------------------------------*/
yyabortlab:
  yyresult = 1;
  goto yyreturn;

#if !defined(yyoverflow) || YYERROR_VERBOSE
/*-------------------------------------------------.
| yyexhaustedlab -- memory exhaustion comes here.  |
`-------------------------------------------------*/
yyexhaustedlab:
  yyerror (scanner, YY_("memory exhausted"));
  yyresult = 2;
  /* Fall through.  */
#endif

yyreturn:
  if (yychar != YYEMPTY)
     yydestruct ("Cleanup: discarding lookahead",
		 yytoken, &yylval, scanner);
  /* Do not reclaim the symbols of the rule which action triggered
     this YYABORT or YYACCEPT.  */
  YYPOPSTACK (yylen);
  YY_STACK_PRINT (yyss, yyssp);
  while (yyssp != yyss)
    {
      yydestruct ("Cleanup: popping",
		  yystos[*yyssp], yyvsp, scanner);
      YYPOPSTACK (1);
    }
#ifndef yyoverflow
  if (yyss != yyssa)
    YYSTACK_FREE (yyss);
#endif
#if YYERROR_VERBOSE
  if (yymsg != yymsgbuf)
    YYSTACK_FREE (yymsg);
#endif
  /* Make sure YYID is used.  */
  return YYID (yyresult);
}



